/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDataEventSupport;
import com.jstatcom.model.JSCDataEventTypes;
import com.jstatcom.model.JSCDataListener;
import com.jstatcom.model.JSCPropertyTypes;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractJSCData
implements JSCData {
    protected volatile JSCDataEventSupport eventSupport = null;
    private Map<JSCPropertyTypes, Object> propertyMap = null;

    @Override
    public Object getJSCProperty(JSCPropertyTypes type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (this.getPropertyMap().containsKey(type)) {
            return this.getPropertyMap().get(type);
        }
        return null;
    }

    @Override
    public void setJSCProperty(JSCPropertyTypes type, Object val) {
        if (type == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.getPropertyMap().put(type, val);
    }

    @Override
    public void removeJSCProperty(JSCPropertyTypes type) {
        this.getPropertyMap().remove(type);
    }

    public synchronized String toString() {
        return super.toString() + " [name=" + this.name() + ",type=" + this.type() + ",value=" + this.display() + "]";
    }

    @Override
    public final synchronized void addJSCDataListener(JSCDataListener evtListener, JSCDataEventTypes evtType) {
        this.getEventSupport().addListener(evtListener, evtType);
    }

    @Override
    public synchronized String display() {
        if (this.isEmpty()) {
            return "{}";
        }
        return this.value().toString();
    }

    protected synchronized JSCDataEventSupport getEventSupport() {
        if (this.eventSupport == null) {
            this.eventSupport = new JSCDataEventSupport();
        }
        return this.eventSupport;
    }

    private synchronized Map<JSCPropertyTypes, Object> getPropertyMap() {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap<JSCPropertyTypes, Object>();
        }
        return this.propertyMap;
    }

    @Override
    public final synchronized void removeJSCDataListener(JSCDataListener evtListener) {
        if (this.eventSupport == null) {
            return;
        }
        this.eventSupport.removeListener(evtListener);
    }
}

