/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.io;

import com.jstatcom.component.TopFrameReference;
import com.jstatcom.io.DataHandler;
import com.jstatcom.io.ImportTypes;
import com.jstatcom.io.TSDataDialog;
import com.jstatcom.io.TSImportTypes;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDate;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSDateRange;
import java.awt.Frame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public final class TSGaussFMTHandler
implements DataHandler {
    private boolean noDialog = false;
    private static final TSGaussFMTHandler handler = new TSGaussFMTHandler();
    private File selectedFile = null;
    private TSDataDialog dialog = null;
    private boolean cancelled = false;
    private final SymbolTable symbolTable = new SymbolTable("TSGaussFMTHandler", false);

    public static TSGaussFMTHandler getInstance() {
        return handler;
    }

    private TSGaussFMTHandler() {
    }

    public static String[] getNamesArray(File fName, int cols, String namesFromDialog) {
        String fileName = fName.getName();
        String[] names = new String[cols];
        if (fileName.indexOf(46) > -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf(".")) + "_";
        }
        if (JSCConstants.isValidName(fileName) != null) {
            fileName = "var_";
        }
        for (int i = 0; i < names.length; ++i) {
            names[i] = fileName + (i + 1);
        }
        StringTokenizer st = new StringTokenizer(namesFromDialog);
        String[] stringArray = new String[st.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = st.nextToken();
        }
        int length = stringArray.length;
        if (names.length < stringArray.length) {
            length = names.length;
        }
        for (int i = 0; i < length; ++i) {
            if (JSCConstants.isValidName(stringArray[i]) != null) continue;
            names[i] = stringArray[i];
        }
        return names;
    }

    @Override
    public boolean importData(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Invalid data file " + file + ".");
        }
        this.selectedFile = file;
        this.cancelled = false;
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            int size = in.available();
            byte[] header = new byte[size];
            in.read(header);
            in.close();
            in = new DataInputStream(new FileInputStream(file));
            if (header[0] == -35 && header[1] == -35) {
                this.importSmallMatrixv89(in, header);
                in.close();
                return !this.cancelled;
            }
            if (header[0] == -35 && header[1] == -18 || header[0] == -18 && header[1] == -35) {
                this.importExtendedMatrixv89(in, header);
                in.close();
                return !this.cancelled;
            }
            if (header[0] == 0 && header[1] == 0) {
                this.importMatrixv92(in, header);
                in.close();
                return !this.cancelled;
            }
            if (header[0] == -1 && header[1] == -1) {
                this.importMatrixv96(in, header);
                in.close();
                return !this.cancelled;
            }
            throw new RuntimeException("Unrecognized matrix file version (neither v89, v92, v96).");
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    private void importSmallMatrixv89(DataInputStream in, byte[] header) throws IOException {
        boolean littleEndian = header[8] == -122;
        in.skipBytes(2);
        int rows = in.readShort();
        if (littleEndian) {
            rows = Short.reverseBytes((short)rows);
        }
        int cols = in.readShort();
        if (littleEndian) {
            cols = Short.reverseBytes((short)cols);
        }
        in.skipBytes(10);
        double[][] val = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                val[i][j] = littleEndian ? Double.longBitsToDouble(Long.reverseBytes(in.readLong())) : in.readDouble();
            }
        }
        this.setDataToSymbolTable(val);
    }

    private void importExtendedMatrixv89(DataInputStream in, byte[] header) throws IOException {
        boolean littleEndian = header[0] == -35;
        in.skipBytes(4);
        int rows = in.readInt();
        if (littleEndian) {
            rows = Integer.reverseBytes(rows);
        }
        int cols = in.readInt();
        if (littleEndian) {
            cols = Integer.reverseBytes(cols);
        }
        in.skipBytes(4);
        double[][] val = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                val[i][j] = littleEndian ? Double.longBitsToDouble(Long.reverseBytes(in.readLong())) : in.readDouble();
            }
        }
        this.setDataToSymbolTable(val);
    }

    private void importMatrixv92(DataInputStream in, byte[] header) throws IOException {
        boolean isLittleEndian = header[4] == -51;
        in.skipBytes(24);
        int type = in.readInt();
        if (isLittleEndian) {
            type = Integer.reverseBytes(type);
        }
        in.skipBytes(100);
        double[][] val = null;
        if (type == 0) {
            val = new double[1][1];
            val[0][0] = isLittleEndian ? Double.longBitsToDouble(Long.reverseBytes(in.readLong())) : in.readDouble();
        } else if (type == 1) {
            int rows = in.readInt();
            if (isLittleEndian) {
                rows = Integer.reverseBytes(rows);
            }
            in.skipBytes(4);
            val = new double[1][rows];
            for (int i = 0; i < rows; ++i) {
                val[0][i] = isLittleEndian ? Double.longBitsToDouble(Long.reverseBytes(in.readLong())) : in.readDouble();
            }
        } else if (type == 2) {
            int rows = in.readInt();
            if (isLittleEndian) {
                rows = Integer.reverseBytes(rows);
            }
            int cols = in.readInt();
            if (isLittleEndian) {
                cols = Integer.reverseBytes(cols);
            }
            val = new double[rows][cols];
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    val[i][j] = isLittleEndian ? Double.longBitsToDouble(Long.reverseBytes(in.readLong())) : in.readDouble();
                }
            }
        }
        this.setDataToSymbolTable(val);
    }

    private void importMatrixv96(DataInputStream in, byte[] header) throws IOException {
        boolean isLittleEndian = header[20] == 0;
        in.skipBytes(60);
        int type = in.readInt();
        if (isLittleEndian) {
            type = Integer.reverseBytes(type);
        }
        int major = in.readInt();
        if (isLittleEndian) {
            major = Integer.reverseBytes(major);
        }
        in.skipBytes(60);
        double[][] val = null;
        if (type == 0) {
            val = new double[1][1];
            val[0][0] = isLittleEndian ? Double.longBitsToDouble(Long.reverseBytes(in.readLong())) : in.readDouble();
        } else if (type == 1) {
            int rows = in.readInt();
            if (isLittleEndian) {
                rows = Integer.reverseBytes(rows);
            }
            in.skipBytes(4);
            val = new double[1][rows];
            for (int i = 0; i < rows; ++i) {
                val[0][i] = isLittleEndian ? Double.longBitsToDouble(Long.reverseBytes(in.readLong())) : in.readDouble();
            }
        } else if (type == 2) {
            int rows = in.readInt();
            if (isLittleEndian) {
                rows = Integer.reverseBytes(rows);
            }
            int cols = in.readInt();
            if (isLittleEndian) {
                cols = Integer.reverseBytes(cols);
            }
            val = new double[rows][cols];
            if (major == 1) {
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        val[i][j] = isLittleEndian ? Double.longBitsToDouble(Long.reverseBytes(in.readLong())) : in.readDouble();
                    }
                }
            } else {
                for (int i = 0; i < cols; ++i) {
                    for (int j = 0; j < rows; ++j) {
                        val[j][i] = isLittleEndian ? Double.longBitsToDouble(Long.reverseBytes(in.readLong())) : in.readDouble();
                    }
                }
            }
        }
        this.setDataToSymbolTable(val);
    }

    private void setDataToSymbolTable(double[][] values) {
        if (!this.noDialog) {
            this.getDataDialog().setVisible(true);
            if (this.getDataDialog().isCanceled()) {
                this.cancelled = true;
                return;
            }
        }
        this.symbolTable.set(new JSCNArray(TSImportTypes.DATA.name(), values));
        this.symbolTable.set(new JSCDate(TSImportTypes.STARTDATE.name(), this.getDataDialog().getTSDate()));
        String[] names = new String[]{};
        if (values.length > 0) {
            names = TSGaussFMTHandler.getNamesArray(this.selectedFile, values[0].length, this.getDataDialog().getVariableNames());
        }
        this.symbolTable.set(new JSCSArray(TSImportTypes.VARNAMES.name(), names));
    }

    @Override
    public JSCData getData(ImportTypes type) {
        if (this.symbolTable == null) {
            throw new IllegalStateException("There was nothing imported yet.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        return this.symbolTable.getJSCData(new JSCTypeDef(type.name(), type.type()));
    }

    private TSDataDialog getDataDialog() {
        if (this.dialog == null) {
            this.dialog = new TSDataDialog((Frame)TopFrameReference.getTopFrameRef(), true);
        }
        this.dialog.setLocationRelativeTo(TopFrameReference.getTopFrameRef());
        return this.dialog;
    }

    @Override
    public void exportTS(File file, TS[] ts, String description) {
        if (file == null) {
            throw new IllegalArgumentException("File argument was null.");
        }
        if (ts == null) {
            throw new IllegalArgumentException("Time series argument was null.");
        }
        if (ts.length == 0) {
            return;
        }
        TSDateRange mergedRange = TSDateRange.getMergedRange(ts);
        double[][] values = new double[mergedRange.numOfObs()][ts.length];
        for (int i = 0; i < mergedRange.numOfObs(); ++i) {
            TSDate currentDate = mergedRange.dateForIndex(i);
            for (int j = 0; j < ts.length; ++j) {
                values[i][j] = ts[j].valueAt(currentDate);
            }
        }
        this.export(values, file);
    }

    @Override
    public void exportData(File file, JSCData data, String description) {
        if (file == null) {
            throw new IllegalArgumentException("File argument was null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("Data argument was null.");
        }
        if (data.type() != JSCTypes.NARRAY) {
            throw new IllegalArgumentException("Data of type \"" + data.type() + "\" cannot be stored in Excel format.");
        }
        if (data.isEmpty()) {
            return;
        }
        this.export(((JSCNArray)data).doubleArray(), file);
    }

    private void export(double[][] values, File file) {
        try {
            int i;
            DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
            byte[] toWrite = new byte[40];
            for (i = 0; i < 4; ++i) {
                toWrite[i] = -1;
            }
            for (i = 4; i < 8; ++i) {
                toWrite[i] = 0;
            }
            for (i = 8; i < 12; ++i) {
                toWrite[i] = -1;
            }
            for (i = 12; i < 16; ++i) {
                toWrite[i] = 0;
            }
            for (i = 16; i < 20; ++i) {
                toWrite[i] = -1;
            }
            for (i = 20; i < 24; ++i) {
                toWrite[i] = -1;
            }
            for (i = 24; i < 28; ++i) {
                toWrite[i] = 0;
            }
            toWrite[28] = -85;
            toWrite[29] = -51;
            toWrite[30] = -17;
            toWrite[31] = 1;
            toWrite[32] = 0;
            toWrite[33] = 0;
            toWrite[34] = 0;
            toWrite[35] = 1;
            out.write(toWrite);
            out.writeInt(1);
            out.writeInt(1008);
            out.writeInt(8);
            out.writeInt(0);
            out.writeInt(1);
            int dim = 0;
            if (values.length == 1 && values[0].length == 1) {
                dim = 0;
            }
            if (values.length > 1 && values[0].length == 1) {
                dim = 1;
            }
            if (values.length > 1 && values[0].length > 1) {
                dim = 2;
            }
            out.writeInt(dim);
            out.writeInt(1);
            out.writeInt(0);
            int headerSize = 128 + 4 * dim;
            if (dim == 1) {
                headerSize += 4;
            }
            out.writeInt(headerSize);
            toWrite = new byte[52];
            out.write(toWrite);
            if (dim == 0) {
                out.writeDouble(values[0][0]);
            }
            if (dim == 1) {
                out.writeInt(values.length);
                toWrite = new byte[4];
                out.write(toWrite);
            }
            if (dim == 2) {
                out.writeInt(values.length);
                out.writeInt(values[0].length);
            }
            for (int i2 = 0; i2 < values.length; ++i2) {
                for (int j = 0; j < values[0].length; ++j) {
                    out.writeDouble(values[i2][j]);
                }
            }
            out.close();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void setTestMode(boolean noDialog) {
        this.noDialog = noDialog;
    }
}

