/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.io;

import com.jstatcom.io.RedirectReceiver;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public final class RedirectOutput
extends PrintStream {
    private static final Logger log = Logger.getLogger(RedirectOutput.class);
    private static RedirectReceiver redirectReceiver = null;
    private static PrintStream logFile = null;
    private static PrintStream systemOut = System.out;
    private static PrintStream systemErr = System.err;

    private RedirectOutput(PrintStream ps) {
        super(ps);
    }

    public static void start(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("File argument was null.");
        }
        System.setOut(new RedirectOutput(systemOut));
        System.setErr(new RedirectOutput(systemErr));
        try {
            logFile = new PrintStream(new FileOutputStream(fileName, true));
        }
        catch (IOException e) {
            log.error((Object)("Cannot create log file\n" + e.getMessage()), (Throwable)e);
        }
    }

    public static void start(RedirectReceiver receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        System.setOut(new RedirectOutput(systemOut));
        System.setErr(new RedirectOutput(systemErr));
        redirectReceiver = receiver;
    }

    public static void stop() {
        redirectReceiver = null;
        logFile = null;
        System.setOut(systemOut);
        System.setErr(systemErr);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        try {
            if (redirectReceiver != null) {
                redirectReceiver.append(new String(buf, off, len));
            }
            if (logFile != null) {
                logFile.write(buf, off, len);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error redirecting", e);
            this.setError();
        }
        super.write(buf, off, len);
    }

    @Override
    public void write(int b) {
        try {
            if (redirectReceiver != null) {
                redirectReceiver.append(b + "");
            }
            if (logFile != null) {
                logFile.write(b);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error redirecting", e);
            this.setError();
        }
        super.write(b);
    }
}

