/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.io;

import com.jstatcom.io.DataHandler;
import com.jstatcom.io.ExtensionFileFilter;
import com.jstatcom.io.TSASCIIHandler;
import com.jstatcom.io.TSExcelHandler;
import com.jstatcom.io.TSGaussDATHandler;
import com.jstatcom.io.TSGaussFMTHandler;
import com.jstatcom.io.TSMatlabHandler;
import javax.swing.filechooser.FileFilter;

public enum DataHandlerTypes {
    DAT{
        private final ExtensionFileFilter datFileFilter = new ExtensionFileFilter(this.getFileExtension(), "JMulTi ASCII Data", this);

        @Override
        public DataHandler getHandler() {
            return TSASCIIHandler.getInstance();
        }

        @Override
        public FileFilter getFileFilter() {
            return this.datFileFilter;
        }

        @Override
        public boolean canWriteFormat() {
            return true;
        }

        @Override
        public String getFileExtension() {
            return "dat";
        }
    }
    ,
    EXCEL{
        private final ExtensionFileFilter excelFileFilter = new ExtensionFileFilter(this.getFileExtension(), "MS Excel 97/2000", this);

        @Override
        public DataHandler getHandler() {
            return TSExcelHandler.getInstance();
        }

        @Override
        public FileFilter getFileFilter() {
            return this.excelFileFilter;
        }

        @Override
        public boolean canWriteFormat() {
            return true;
        }

        @Override
        public String getFileExtension() {
            return "xls";
        }
    }
    ,
    GAUSS_FMT{
        private final ExtensionFileFilter gaussFMTFileFilter = new ExtensionFileFilter(this.getFileExtension(), "Gauss Matrix Files", this);

        @Override
        public DataHandler getHandler() {
            return TSGaussFMTHandler.getInstance();
        }

        @Override
        public FileFilter getFileFilter() {
            return this.gaussFMTFileFilter;
        }

        @Override
        public boolean canWriteFormat() {
            return true;
        }

        @Override
        public String getFileExtension() {
            return "fmt";
        }
    }
    ,
    GAUSS_DAT{
        private final ExtensionFileFilter gaussDatFileFilter = new ExtensionFileFilter(this.getFileExtension(), "Gauss Datasets", this);

        @Override
        public DataHandler getHandler() {
            return TSGaussDATHandler.getInstance();
        }

        @Override
        public FileFilter getFileFilter() {
            return this.gaussDatFileFilter;
        }

        @Override
        public boolean canWriteFormat() {
            return true;
        }

        @Override
        public String getFileExtension() {
            return "dat";
        }
    }
    ,
    MATLAB{
        private final ExtensionFileFilter matFileFilter = new ExtensionFileFilter(this.getFileExtension(), "Matlab MAT-Files Level 5", this);

        @Override
        public DataHandler getHandler() {
            return TSMatlabHandler.getInstance();
        }

        @Override
        public FileFilter getFileFilter() {
            return this.matFileFilter;
        }

        @Override
        public boolean canWriteFormat() {
            return true;
        }

        @Override
        public String getFileExtension() {
            return "mat";
        }
    };


    public abstract DataHandler getHandler();

    public abstract FileFilter getFileFilter();

    public abstract String getFileExtension();

    public abstract boolean canWriteFormat();

    public static DataHandlerTypes getTypeFromFileName(String fName) {
        if (fName == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        String check = fName.toLowerCase();
        if (check.endsWith("xls")) {
            return EXCEL;
        }
        if (check.endsWith("fmt")) {
            return GAUSS_FMT;
        }
        if (check.endsWith("mat")) {
            return MATLAB;
        }
        return DAT;
    }
}

