/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine.gauss;

import com.jstatcom.component.StdMessages;
import com.jstatcom.engine.ConfigHolder;
import com.jstatcom.engine.EngineTypes;
import com.jstatcom.engine.gauss.GaussConfigKeys;
import com.jstatcom.engine.gauss.GaussEngine;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;
import org.apache.log4j.Logger;

public final class LIBSet {
    private static final Logger log = Logger.getLogger(LIBSet.class);
    private final List<SRCLibPair> libList = new ArrayList<SRCLibPair>();
    public final String LIBS;
    public static final XmlFormat<LIBSet> LIBSet_XML = new XmlFormat<LIBSet>(LIBSet.class){

        @Override
        public void format(LIBSet data, XmlElement xml) {
            xml.setAttribute("libs", data.LIBS);
            Iterator it = data.libList.iterator();
            while (it.hasNext()) {
                xml.add(it.next());
            }
        }

        @Override
        public LIBSet parse(XmlElement xml) {
            String libraries = xml.getAttribute("libs") + "";
            LIBSet newSet = new LIBSet(libraries);
            while (xml.hasNext()) {
                SRCLibPair pair = (SRCLibPair)xml.getNext();
                newSet.addSRCLibMapping(pair.libraryName, pair.srcFile);
            }
            return newSet;
        }
    };

    public static void main(String[] args) {
        GaussEngine gauss = GaussEngine.getInstance();
        gauss.start(false);
        String error = null;
        if (gauss != null) {
            error = gauss.createLibs();
            if (error != null) {
                StdMessages.error(error, "GAUSS Library Error");
                System.exit(0);
            } else {
                StdMessages.infoGeneral("GAUSS library generation finished ok.");
                System.exit(0);
            }
        } else {
            log.error((Object)"GAUSS could not be initialized, library generation failed.");
        }
    }

    public LIBSet(String libraries) {
        this.LIBS = libraries;
    }

    public void addSRCLibMapping(String libName, String fileName) {
        if (fileName == null || libName == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        libName = libName.trim();
        String fName = fileName.toString().trim();
        File srcFile = new File(EngineTypes.GAUSS.DIR_NAME + "/" + fName);
        String toAdd = srcFile.getAbsolutePath();
        if (!srcFile.isFile()) {
            throw new RuntimeException("\nFile \"" + toAdd + "\" does not exist.");
        }
        if (toAdd.indexOf(" ") > 0 && ConfigHolder.valueOf(EngineTypes.GAUSS).getConfig(GaussConfigKeys.GAUSS_VERSION).equals("3.2")) {
            throw new RuntimeException("\nFilename \"" + toAdd + "\" contains whitespace characters.");
        }
        if (libName.length() == 0) {
            throw new RuntimeException("\nLibrary name is empty.");
        }
        SRCLibPair pair = new SRCLibPair(libName, fileName);
        if (!this.libList.contains(pair)) {
            this.libList.add(pair);
        }
    }

    public Iterator iterator() {
        return this.libList.iterator();
    }

    public static class SRCLibPair {
        public final String srcFile;
        public final String libraryName;
        public static final XmlFormat<SRCLibPair> SRCLibPair_XML = new XmlFormat<SRCLibPair>(SRCLibPair.class){

            @Override
            public void format(SRCLibPair data, XmlElement xml) {
                xml.setAttribute("libname", data.libraryName);
                xml.setAttribute("filename", data.srcFile);
            }

            @Override
            public SRCLibPair parse(XmlElement xml) {
                String srcFile = xml.getAttribute("filename") + "";
                String lib = xml.getAttribute("libname") + "";
                return new SRCLibPair(lib, srcFile);
            }
        };

        public SRCLibPair(String libraryName, String srcFile) {
            this.srcFile = srcFile;
            this.libraryName = libraryName;
        }

        public final int hashCode() {
            int result = 17;
            result = 37 * result + this.srcFile.hashCode();
            result = 37 * result + this.libraryName.toUpperCase().hashCode();
            return result;
        }

        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SRCLibPair)) {
                return false;
            }
            SRCLibPair other = (SRCLibPair)o;
            boolean ret = this.libraryName.equalsIgnoreCase(other.libraryName) && this.srcFile.equals(other.srcFile);
            return ret;
        }
    }
}

