/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine;

import com.jstatcom.engine.AbstractConfigPanel;
import com.jstatcom.engine.ConfigHolder;
import com.jstatcom.engine.ConfigKeys;
import com.jstatcom.engine.DefaultConfigPanel;
import com.jstatcom.engine.Engine;
import com.jstatcom.engine.gauss.GaussEngineType;
import com.jstatcom.engine.grte.GRTEType;
import com.jstatcom.engine.matlab.MatlabEngineType;
import com.jstatcom.engine.mlab.StubMlabEngineType;
import com.jstatcom.engine.ox.OxEngineType;
import com.jstatcom.engine.stub.StubEngineType;
import com.jstatcom.model.JSCConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class EngineTypes {
    private static final Map<String, EngineTypes> typeMap = new HashMap<String, EngineTypes>();
    public final String name;
    public final String DIR_NAME;
    private final String cfgFile;
    private AbstractConfigPanel configPanel = null;
    private static final String cfg_filename = "engine_config.xml";
    public static final EngineTypes GAUSS = GaussEngineType.INSTANCE;
    public static final EngineTypes GRTE = GRTEType.INSTANCE;
    public static final EngineTypes STUB = StubEngineType.INSTANCE;
    public static final EngineTypes MATLAB = MatlabEngineType.INSTANCE;
    public static final EngineTypes MLAB = StubMlabEngineType.INSTANCE;
    public static final EngineTypes OX = OxEngineType.INSTANCE;
    private static List<Engine> loadedEngines = new ArrayList<Engine>();

    protected EngineTypes(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        JSCConstants.checkNameThrowEx(name);
        this.name = name;
        this.DIR_NAME = "j" + name.toLowerCase();
        this.cfgFile = this.DIR_NAME + "/" + cfg_filename;
        if (EngineTypes.valueOf(name) != null) {
            throw new IllegalStateException("Engine type \"" + name + "\" already exists.");
        }
        typeMap.put(name.toUpperCase(), this);
    }

    public final String checkConfig(ConfigHolder configHolder) {
        if (configHolder == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        Set<ConfigKeys> keySet = configHolder.getConfigKeys();
        if (keySet == null) {
            return null;
        }
        if (!keySet.containsAll(this.getConfigKeys().values())) {
            return "Some information is missing to run engine of type " + this + ".";
        }
        for (ConfigKeys currentKey : keySet) {
            String value;
            String error = currentKey.isValid(value = configHolder.getConfig(currentKey));
            if (error == null) continue;
            return error;
        }
        return this.checkSettings(configHolder);
    }

    public abstract String checkSettings(ConfigHolder var1);

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public String getConfigFile() {
        File dir = new File(this.DIR_NAME);
        if (!dir.isDirectory()) {
            dir.mkdir();
        }
        return this.cfgFile;
    }

    public abstract Map<String, ConfigKeys> getConfigKeys();

    public AbstractConfigPanel getConfigPanel() {
        if (this.configPanel == null) {
            this.configPanel = new DefaultConfigPanel();
        }
        return this.configPanel;
    }

    public abstract Engine getEngine();

    public final int hashCode() {
        return super.hashCode();
    }

    public final String toString() {
        return this.name;
    }

    public static EngineTypes valueOf(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null");
        }
        EngineTypes o = typeMap.get(name.toUpperCase());
        if (o instanceof EngineTypes) {
            return o;
        }
        return null;
    }

    public static Iterator engineIterator() {
        return loadedEngines.iterator();
    }

    protected static void addLoadedEngine(Engine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Argument was null");
        }
        if (!loadedEngines.contains(engine)) {
            loadedEngines.add(engine);
        }
    }
}

