/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine;

import com.jstatcom.component.StdMessages;
import com.jstatcom.component.TopFrameReference;
import com.jstatcom.engine.AbstractConfigPanel;
import com.jstatcom.engine.ConfigHolder;
import com.jstatcom.engine.EngineTypes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import org.apache.log4j.Logger;

public final class ConfigDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(ConfigDialog.class);
    private ConfigHolder configHolder = null;
    private static boolean isOK = true;
    private static ConfigDialog configDialog = null;
    private AbstractConfigPanel configPanel = null;
    private JPanel ivjJDialogContentPane = null;
    private JButton ivjCancelButton = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JButton ivjOKButton = null;
    private JPanel ivjButtonPanel = null;

    public ConfigDialog() {
        super((Frame)TopFrameReference.getTopFrameRef(), true);
        this.initialize();
    }

    private void cancelButton_ActionEvents() {
        isOK = false;
        this.setVisible(false);
    }

    private void connEtoC1() {
        try {
            this.oKButton_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.cancelButton_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JPanel getButtonPanel() {
        if (this.ivjButtonPanel == null) {
            try {
                this.ivjButtonPanel = new JPanel();
                this.ivjButtonPanel.setName("ButtonPanel");
                this.ivjButtonPanel.setPreferredSize(new Dimension(0, 80));
                this.ivjButtonPanel.setBorder(new BevelBorder(1));
                this.ivjButtonPanel.setLayout(this.getButtonPanelFlowLayout());
                this.getButtonPanel().add((Component)this.getOKButton(), this.getOKButton().getName());
                this.getButtonPanel().add((Component)this.getCancelButton(), this.getCancelButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonPanel;
    }

    private FlowLayout getButtonPanelFlowLayout() {
        FlowLayout ivjButtonPanelFlowLayout = null;
        try {
            ivjButtonPanelFlowLayout = new FlowLayout();
            ivjButtonPanelFlowLayout.setVgap(20);
            ivjButtonPanelFlowLayout.setHgap(60);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjButtonPanelFlowLayout;
    }

    private JButton getCancelButton() {
        if (this.ivjCancelButton == null) {
            try {
                this.ivjCancelButton = new JButton();
                this.ivjCancelButton.setName("CancelButton");
                this.ivjCancelButton.setPreferredSize(new Dimension(100, 25));
                this.ivjCancelButton.setText("Cancel");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCancelButton;
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new BorderLayout());
                this.ivjJDialogContentPane.setMinimumSize(new Dimension(500, 400));
                this.getJDialogContentPane().add((Component)this.getButtonPanel(), "South");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private JButton getOKButton() {
        if (this.ivjOKButton == null) {
            try {
                this.ivjOKButton = new JButton();
                this.ivjOKButton.setName("OKButton");
                this.ivjOKButton.setPreferredSize(new Dimension(100, 25));
                this.ivjOKButton.setText("OK");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOKButton;
    }

    private void handleException(Throwable exception) {
        log.error((Object)"Unhandled Exception", exception);
    }

    private void initConnections() throws Exception {
        this.getOKButton().addActionListener(this.ivjEventHandler);
        this.getCancelButton().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ConfigDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(500, 400);
            this.setResizable(true);
            this.setContentPane(this.getJDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setLocationRelativeTo(TopFrameReference.getTopFrameRef());
    }

    private void oKButton_ActionEvents() {
        String error = null;
        error = this.configPanel.storeConfig(this.configHolder);
        if (error == null) {
            error = this.configHolder.getEngineType().checkConfig(this.configHolder);
        }
        boolean bl = isOK = error == null;
        if (isOK) {
            this.setVisible(false);
        } else {
            StdMessages.errorInput(error);
        }
    }

    public static boolean showConfigDialog(ConfigHolder newConfigHolder) {
        if (newConfigHolder == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (configDialog == null) {
            configDialog = new ConfigDialog();
        }
        ConfigDialog.configDialog.configHolder = newConfigHolder;
        EngineTypes engineType = ConfigDialog.configDialog.configHolder.getEngineType();
        ConfigDialog.configDialog.configPanel = engineType.getConfigPanel();
        ConfigDialog.configDialog.configPanel.setConfig(ConfigDialog.configDialog.configHolder);
        configDialog.setTitle("Configuration Settings for " + engineType.toString());
        configDialog.getJDialogContentPane().removeAll();
        configDialog.getJDialogContentPane().add((Component)new JScrollPane(ConfigDialog.configDialog.configPanel), "Center");
        configDialog.getJDialogContentPane().add((Component)configDialog.getButtonPanel(), "South");
        configDialog.setVisible(true);
        return isOK;
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ConfigDialog.this.getOKButton()) {
                ConfigDialog.this.connEtoC1();
            }
            if (e.getSource() == ConfigDialog.this.getCancelButton()) {
                ConfigDialog.this.connEtoC2();
            }
        }
    }
}

