/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine;

import com.jstatcom.engine.CPtr;

public final class CMalloc
extends CPtr {
    private int size;

    public CMalloc(int size) {
        this.size = size;
        this.peer = CMalloc.malloc(size);
        if (this.peer == 0L) {
            throw new OutOfMemoryError();
        }
    }

    public void free() {
        CMalloc.free(this.peer);
        this.peer = 0L;
    }

    @Override
    public void copyIn(int bOff, byte[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 1);
        super.copyIn(bOff, buf, index, length);
    }

    @Override
    public void copyIn(int bOff, short[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 2);
        super.copyIn(bOff, buf, index, length);
    }

    @Override
    public void copyIn(int bOff, char[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 2);
        super.copyIn(bOff, buf, index, length);
    }

    @Override
    public void copyIn(int bOff, int[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 4);
        super.copyIn(bOff, buf, index, length);
    }

    @Override
    public void copyIn(int bOff, long[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 8);
        super.copyIn(bOff, buf, index, length);
    }

    @Override
    public void copyIn(int bOff, float[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 4);
        super.copyIn(bOff, buf, index, length);
    }

    @Override
    public void copyIn(int bOff, double[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 8);
        super.copyIn(bOff, buf, index, length);
    }

    @Override
    public void copyOut(int bOff, byte[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 1);
        super.copyOut(bOff, buf, index, length);
    }

    @Override
    public void copyOut(int bOff, short[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 2);
        super.copyOut(bOff, buf, index, length);
    }

    @Override
    public void copyOut(int bOff, char[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 2);
        super.copyOut(bOff, buf, index, length);
    }

    @Override
    public void copyOut(int bOff, int[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 4);
        super.copyOut(bOff, buf, index, length);
    }

    @Override
    public void copyOut(int bOff, long[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 8);
        super.copyOut(bOff, buf, index, length);
    }

    @Override
    public void copyOut(int bOff, float[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 4);
        super.copyOut(bOff, buf, index, length);
    }

    @Override
    public void copyOut(int bOff, double[] buf, int index, int length) {
        this.boundsCheck(bOff, length * 8);
        super.copyOut(bOff, buf, index, length);
    }

    @Override
    public byte getByte(int offset) {
        this.boundsCheck(offset, 1);
        return super.getByte(offset);
    }

    @Override
    public short getShort(int offset) {
        this.boundsCheck(offset, 2);
        return super.getShort(offset);
    }

    @Override
    public int getInt(int offset) {
        this.boundsCheck(offset, 4);
        return super.getInt(offset);
    }

    @Override
    public long getLong(int offset) {
        this.boundsCheck(offset, 8);
        return super.getLong(offset);
    }

    @Override
    public float getFloat(int offset) {
        this.boundsCheck(offset, 4);
        return super.getFloat(offset);
    }

    @Override
    public double getDouble(int offset) {
        this.boundsCheck(offset, 8);
        return super.getDouble(offset);
    }

    @Override
    public CPtr getCPtr(int offset) {
        this.boundsCheck(offset, SIZE);
        return super.getCPtr(offset);
    }

    @Override
    public String getString(int offset) {
        this.boundsCheck(offset, 0);
        return super.getString(offset);
    }

    @Override
    public void setByte(int offset, byte value) {
        this.boundsCheck(offset, 1);
        super.setByte(offset, value);
    }

    @Override
    public void setShort(int offset, short value) {
        this.boundsCheck(offset, 2);
        super.setShort(offset, value);
    }

    @Override
    public void setInt(int offset, int value) {
        this.boundsCheck(offset, 4);
        super.setInt(offset, value);
    }

    @Override
    public void setLong(int offset, long value) {
        this.boundsCheck(offset, 8);
        super.setLong(offset, value);
    }

    @Override
    public void setFloat(int offset, float value) {
        this.boundsCheck(offset, 4);
        super.setFloat(offset, value);
    }

    @Override
    public void setDouble(int offset, double value) {
        this.boundsCheck(offset, 8);
        super.setDouble(offset, value);
    }

    @Override
    public void setCPtr(int offset, CPtr value) {
        this.boundsCheck(offset, SIZE);
        super.setCPtr(offset, value);
    }

    @Override
    public void setString(int offset, String value) {
        byte[] bytes = value.getBytes();
        int length = bytes.length;
        this.boundsCheck(offset, length + 1);
        super.copyIn(offset, bytes, 0, length);
        super.setByte(offset + length, (byte)0);
    }

    private static native long malloc(int var0);

    private static native void free(long var0);

    private CMalloc() {
    }

    private void boundsCheck(int off, int sz) {
        if (off < 0 || off + sz > this.size) {
            throw new IndexOutOfBoundsException();
        }
    }
}

