/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.component.IValTextField;
import com.jstatcom.component.NumberFormatTypes;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.NumberRange;
import com.jstatcom.model.NumberRangeTypes;
import com.jstatcom.model.Scope;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.SymbolEvent;
import com.jstatcom.model.SymbolListener;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.parser.NumberRangeParser;
import com.jstatcom.util.UMath;
import com.jstatcom.util.UString;
import java.text.NumberFormat;

public final class NumSelector
extends IValTextField
implements SymbolListener {
    private double currentNumber = 0.0;
    private int precision = 0;
    private NumberFormat numberFormat = NumberFormatTypes.DEFAULT.getInstance();
    private NumberFormatTypes numberFormatType = NumberFormatTypes.DEFAULT;
    private boolean intType = false;
    private String symbolName = null;
    private String symbolNameLBound = null;
    private String symbolNameUBound = null;
    private NumberRange numberRange = null;
    private final NumberRange defaultRange = new NumberRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, NumberRangeTypes.OPEN);
    private NumberRangeTypes pendingRangeType = NumberRangeTypes.OPEN;
    private double pendingLowerBound = Double.NEGATIVE_INFINITY;
    private double pendingUpperBound = Double.POSITIVE_INFINITY;
    private Scope symbolScope = Scope.GLOBAL;
    private Symbol symbol = null;

    public NumSelector() {
        this.setNumberRange(this.defaultRange);
        this.setSize(50, 20);
    }

    @Override
    public void valueChanged(SymbolEvent evt) {
        this.symbol = evt.getSource();
        if (this.symbol.isEmpty()) {
            return;
        }
        if (this.intType) {
            this.setNumber(this.symbol.getJSCInt().doubleVal());
        } else {
            this.setNumber(this.symbol.getJSCNumber().doubleVal());
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setDataForSymbolName();
    }

    @Override
    protected void focusGained() {
        super.focusGained();
        if (this.symbol != null) {
            this.symbol.removeSymbolListener(this);
        }
        double lowerBound = this.pendingLowerBound;
        if (this.symbolNameLBound != null) {
            lowerBound = this.getDataForSymbol(this.symbolNameLBound, false);
        }
        double upperBound = this.pendingUpperBound;
        if (this.symbolNameUBound != null) {
            upperBound = this.getDataForSymbol(this.symbolNameUBound, true);
        }
        if (this.symbolNameLBound != null || this.symbolNameUBound != null) {
            this.setNumberRange(new NumberRange(lowerBound, upperBound, this.pendingRangeType));
        }
    }

    @Override
    protected void focusLost() {
        super.focusLost();
        if (this.symbol != null) {
            this.symbol.addSymbolListener(this);
        }
        if (this.symbolNameLBound != null || this.symbolNameUBound != null) {
            this.numberRange = this.defaultRange;
        }
    }

    private double getDataForSymbol(String sName, boolean isUpper) {
        if (sName != null) {
            SymbolTable sTable = this.symbolScope.getSymbolTable(this);
            Symbol newSymbol = null;
            if (sTable != null && sName != null) {
                if (this.intType) {
                    newSymbol = sTable.get(new JSCTypeDef(sName, JSCTypes.INT));
                    if (newSymbol.isEmpty()) {
                        if (isUpper) {
                            return 2.147483647E9;
                        }
                        return -2.147483648E9;
                    }
                    return newSymbol.getJSCInt().doubleVal();
                }
                newSymbol = sTable.get(new JSCTypeDef(sName, JSCTypes.NUMBER));
                if (newSymbol.isEmpty()) {
                    if (isUpper) {
                        return Double.MAX_VALUE;
                    }
                    return -1.7976931348623157E308;
                }
                return newSymbol.getJSCNumber().doubleVal();
            }
        }
        if (isUpper) {
            if (this.intType) {
                return 2.147483647E9;
            }
            return Double.MAX_VALUE;
        }
        if (this.intType) {
            return -2.147483648E9;
        }
        return -1.7976931348623157E308;
    }

    private void setDataForSymbolName() {
        SymbolTable sTable = null;
        if (this.symbolName != null) {
            sTable = this.symbolScope.getSymbolTable(this);
        }
        Symbol newSymbol = null;
        if (sTable != null && this.symbolName != null) {
            newSymbol = this.intType ? sTable.get(new JSCTypeDef(this.symbolName, JSCTypes.INT)) : sTable.get(new JSCTypeDef(this.symbolName, JSCTypes.NUMBER));
        }
        if (newSymbol == this.symbol) {
            return;
        }
        if (this.symbol != null) {
            this.symbol.removeSymbolListener(this);
        }
        this.symbol = newSymbol;
        if (this.symbol == null || this.symbol.isEmpty()) {
            this.setNumber(this.currentNumber);
        } else if (this.intType) {
            this.setNumber(this.symbol.getJSCInt().doubleVal());
        } else {
            this.setNumber(this.symbol.getJSCNumber().doubleVal());
        }
    }

    public int getIntNumber() {
        return new Double(this.currentNumber).intValue();
    }

    public double getNumber() {
        return this.currentNumber;
    }

    public NumberFormatTypes getNumberFormatType() {
        return this.numberFormatType;
    }

    public NumberRange getNumberRange() {
        return this.numberRange;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String getRangeExpr() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.numberRange.rangeType.leftBracket);
        if (this.symbolNameLBound != null && this.symbolNameLBound.length() > 0) {
            ret.append("\"" + this.symbolNameLBound + "\"");
        } else {
            ret.append(this.numberRange.lowerBound);
        }
        ret.append(", ");
        if (this.symbolNameUBound != null && this.symbolNameUBound.length() > 0) {
            ret.append("\"" + this.symbolNameUBound + "\"");
        } else {
            ret.append(this.numberRange.upperBound);
        }
        ret.append(this.numberRange.rangeType.rightBracket);
        return ret.toString();
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    @Override
    public void handleError(String msg) {
        super.handleError(msg + "\nThe previous value {" + this.currentNumber + "} is restored.");
        this.setNumber(this.currentNumber);
    }

    public void setNumber(double val) {
        String msg = this.numberRange.encloses(val);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        double oldValue = this.currentNumber;
        this.currentNumber = val;
        this.setTextCarefully(UString.formatNumber(val, this.numberFormat, this.precision));
        if (this.symbol != null) {
            this.symbol.removeSymbolListener(this);
            if (this.intType) {
                this.symbol.getJSCInt().setVal((int)this.currentNumber);
            } else {
                this.symbol.getJSCNumber().setVal(this.currentNumber);
            }
            this.symbol.addSymbolListener(this);
        }
        if (oldValue != this.currentNumber) {
            this.firePropertyChange("number", new Double(oldValue), new Double(this.currentNumber));
        }
    }

    public void setNumberFormatType(NumberFormatTypes newNumberFormatType) {
        this.numberFormatType = newNumberFormatType;
        this.numberFormat = newNumberFormatType.getInstance();
    }

    public void setNumberRange(NumberRange newNumberRange) {
        if (newNumberRange == null) {
            newNumberRange = new NumberRange();
        }
        this.numberRange = newNumberRange;
        if (this.numberRange.encloses(this.currentNumber) == null) {
            this.setNumber(this.currentNumber);
            return;
        }
        this.setNumber(this.numberRange.defaultNumber());
    }

    public void setPrecision(int newPrecision) {
        if (newPrecision < 0) {
            throw new IllegalArgumentException("Negative precision argument.");
        }
        this.precision = newPrecision;
    }

    public void setRangeExpr(String expr) {
        Object[] rangeComponents;
        if (expr == null || expr.length() == 0) {
            throw new IllegalArgumentException("Range expression is empty.");
        }
        try {
            rangeComponents = new NumberRangeParser().parseString(expr);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("NumberRange construction from \"" + expr + "\" failed.\n" + ex);
        }
        double lowerBound = 0.0;
        double upperBound = 0.0;
        String lowerName = null;
        String upperName = null;
        if (rangeComponents[0] instanceof Double) {
            lowerBound = (Double)rangeComponents[0];
            this.symbolNameLBound = null;
        } else {
            lowerName = rangeComponents[0].toString();
        }
        if (rangeComponents[1] instanceof Double) {
            upperBound = (Double)rangeComponents[1];
            this.symbolNameUBound = null;
        } else {
            upperName = rangeComponents[1].toString();
        }
        NumberRangeTypes rangeType = (NumberRangeTypes)rangeComponents[2];
        if (lowerName == null && upperName == null) {
            this.setNumberRange(new NumberRange(lowerBound, upperBound, rangeType));
            return;
        }
        this.setNumberRange(this.defaultRange);
        this.pendingRangeType = rangeType;
        this.symbolNameLBound = lowerName;
        this.symbolNameUBound = upperName;
        if (this.symbolNameLBound == null) {
            this.pendingLowerBound = lowerBound;
        }
        if (this.symbolNameUBound == null) {
            this.pendingUpperBound = upperBound;
        }
    }

    public void setSymbolName(String newSymbolName) {
        JSCConstants.checkNameThrowEx(newSymbolName);
        this.symbolName = newSymbolName;
        this.setDataForSymbolName();
    }

    @Override
    public String validateInput() {
        String inputString = this.getText().trim();
        Double number = UString.parseToNumber(inputString);
        if (number == null) {
            return "Input \"" + inputString + "\" is not a valid number.";
        }
        double doubleVal = number;
        String error = null;
        error = this.numberFormatType == NumberFormatTypes.DEFAULT ? this.numberRange.encloses(doubleVal, this.precision, this.numberFormat) : this.numberRange.encloses(doubleVal);
        if (error != null) {
            return error;
        }
        if (this.numberFormatType == NumberFormatTypes.DEFAULT) {
            doubleVal = UMath.round(doubleVal, this.precision);
        }
        this.setNumber(doubleVal);
        return null;
    }

    public Scope getSymbolScope() {
        return this.symbolScope;
    }

    public void setSymbolScope(Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.symbolScope = scope;
        this.setDataForSymbolName();
    }

    public boolean isIntType() {
        return this.intType;
    }

    public void setIntType(boolean b) {
        this.intType = b;
    }
}

