/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.component.IValTextField;
import com.jstatcom.component.MatrixBorder;
import com.jstatcom.component.NumberFormatTypes;
import com.jstatcom.model.NumberRange;
import com.jstatcom.model.NumberRangeTypes;
import com.jstatcom.util.UMath;
import com.jstatcom.util.UString;
import java.text.NumberFormat;

public final class NumRangeSelector
extends IValTextField {
    private int precision = 0;
    private NumberFormat numberFormat = NumberFormatTypes.DEFAULT.getInstance();
    private NumberFormatTypes numberFormatType = NumberFormatTypes.DEFAULT;
    private NumberRange currentNumberRange = NumberRange.valueOf("[1,100]");
    private NumberRange overallNumberRange = null;
    private final NumberRange defaultOverallRange = new NumberRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, NumberRangeTypes.OPEN);

    public NumRangeSelector() {
        this.setOverallNumberRange(this.defaultOverallRange);
        this.setBorder(MatrixBorder.getInstanceSmall());
        this.setSize(100, 20);
    }

    public NumberFormatTypes getNumberFormatType() {
        return this.numberFormatType;
    }

    public NumberRange getNumberRange() {
        return this.currentNumberRange;
    }

    public NumberRange getOverallNumberRange() {
        return this.overallNumberRange;
    }

    public String getOverallRangeExpr() {
        return this.overallNumberRange.toString();
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public void handleError(String msg) {
        super.handleError(msg + "\nThe previous value " + this.currentNumberRange + " is restored.");
        this.setNumberRange(this.currentNumberRange);
    }

    public void setNumberFormatType(NumberFormatTypes newNumberFormatType) {
        this.numberFormatType = newNumberFormatType;
        this.numberFormat = newNumberFormatType.getInstance();
    }

    public void setNumberRange(NumberRange newRange) {
        String msg = this.overallNumberRange.encloses(newRange);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        NumberRange oldRange = this.currentNumberRange;
        this.currentNumberRange = newRange.rangeType == NumberRangeTypes.CLOSED ? newRange : new NumberRange(newRange.lowerBound, newRange.upperBound, NumberRangeTypes.CLOSED);
        this.setTextCarefully(UString.formatNumber(this.currentNumberRange.lowerBound, this.numberFormat, this.precision) + ", " + UString.formatNumber(this.currentNumberRange.upperBound, this.numberFormat, this.precision));
        if (!oldRange.equals(newRange)) {
            this.firePropertyChange("numberRange", oldRange, newRange);
        }
    }

    public void setOverallNumberRange(NumberRange newNumberRange) {
        if (newNumberRange == null) {
            newNumberRange = new NumberRange();
        }
        this.overallNumberRange = newNumberRange;
        if (this.overallNumberRange.encloses(this.currentNumberRange) == null) {
            this.setNumberRange(this.currentNumberRange);
            return;
        }
        this.setNumberRange(this.overallNumberRange.defaultNumberRange());
    }

    public void setOverallRangeExpr(String expr) {
        if (expr == null || expr.length() == 0) {
            throw new IllegalArgumentException("Range expression is empty.");
        }
        this.setOverallNumberRange(NumberRange.valueOf(expr));
    }

    public void setPrecision(int newPrecision) {
        if (newPrecision < 0) {
            throw new IllegalArgumentException("Negative precision argument.");
        }
        this.precision = newPrecision;
    }

    public void setRangeBounds(String expr) {
        if (expr == null || expr.length() == 0) {
            throw new IllegalArgumentException("Range expression is empty.");
        }
        expr = NumberRangeTypes.CLOSED.leftBracket + expr + NumberRangeTypes.CLOSED.rightBracket;
        this.setNumberRange(NumberRange.valueOf(expr));
    }

    @Override
    public String validateInput() {
        NumberRange newRange;
        String exp = this.getText().trim();
        String error = "Input \"" + exp + "\" is not a valid number range.";
        int kommaIndex = exp.indexOf(",");
        if (kommaIndex < 1 || kommaIndex > exp.length() - 2) {
            throw new IllegalArgumentException(error);
        }
        String lString = exp.substring(0, kommaIndex);
        String uString = exp.substring(kommaIndex + 1, exp.length());
        Double lBound = UString.parseToNumber(lString);
        Double uBound = UString.parseToNumber(uString);
        if (lBound == null || uBound == null) {
            return "Input \"" + exp + "\" is not a valid number range.";
        }
        double lower = lBound;
        double upper = uBound;
        if (this.numberFormatType == NumberFormatTypes.DEFAULT) {
            lower = UMath.round(lower, this.precision);
        }
        if ((error = this.overallNumberRange.encloses(newRange = new NumberRange(lower, upper = UMath.round(upper, this.precision), NumberRangeTypes.CLOSED))) == null) {
            this.setNumberRange(newRange);
            return null;
        }
        return newRange.formattedString(this.numberFormat) + " is not contained in " + this.overallNumberRange.formattedString(this.numberFormat) + ".";
    }
}

