/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import EDU.oswego.cs.dl.util.concurrent.misc.SwingWorker;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.List;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class JHelpAction
extends AbstractAction {
    private static final Logger log = Logger.getLogger(JHelpAction.class);
    private static String helpSetName = null;
    private static final ActionEvent cshAction = new ActionEvent(new JLabel(), 1001, null);
    private static HelpBroker helpBroker = null;
    private static WorkerHelpset worker = null;

    private JHelpAction() {
    }

    protected JHelpAction(String name) {
        super(name);
    }

    protected JHelpAction(String name, Icon icon) {
        super(name, icon);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JHelpAction.showHelp();
    }

    public static JHelpAction getFocusInstance(String name) {
        return new JHelpAction(name){

            @Override
            public void actionPerformed(ActionEvent evt) {
                1.showHelpFromFocus();
            }
        };
    }

    public static JHelpAction getFocusInstance(String name, Icon icon) {
        return new JHelpAction(name, icon){

            @Override
            public void actionPerformed(ActionEvent evt) {
                2.showHelpFromFocus();
            }
        };
    }

    private static HelpBroker getHelpBroker() {
        Object o;
        if (helpSetName == null) {
            throw new IllegalStateException("Name of helpset has not yet been set.");
        }
        if (helpBroker == null && (o = worker.get()) instanceof HelpBroker) {
            helpBroker = (HelpBroker)o;
        }
        if (helpBroker == null) {
            throw new IllegalStateException("HelpBroker has not been created.");
        }
        return helpBroker;
    }

    public static JHelpAction getShowHelpInstance(String name) {
        JHelpAction action = new JHelpAction(name);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F1"));
        return action;
    }

    public static JHelpAction getShowHelpInstance(String name, Icon icon) {
        JHelpAction action = new JHelpAction(name, icon);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F1"));
        return action;
    }

    public static JHelpAction getShowIDInstance(String name, final String helpID) {
        return new JHelpAction(name){

            @Override
            public void actionPerformed(ActionEvent evt) {
                3.showHelp(helpID);
            }
        };
    }

    public static JHelpAction getShowIDInstance(String name, Icon icon, final String helpID) {
        return new JHelpAction(name, icon){

            @Override
            public void actionPerformed(ActionEvent evt) {
                4.showHelp(helpID);
            }
        };
    }

    public static JHelpAction getTrackInstance(String name) {
        JHelpAction action = new JHelpAction(name){

            @Override
            public void actionPerformed(ActionEvent evt) {
                5.trackFieldHelp();
            }
        };
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control F1"));
        return action;
    }

    public static JHelpAction getTrackInstance(String name, Icon icon) {
        JHelpAction action = new JHelpAction(name, icon){

            @Override
            public void actionPerformed(ActionEvent evt) {
                6.trackFieldHelp();
            }
        };
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control F1"));
        return action;
    }

    public static void showHelp() {
        if (helpBroker == null) {
            if (JHelpAction.getHelpBroker() != null) {
                new CSH.DisplayHelpFromSource(helpBroker).actionPerformed(cshAction);
            }
        } else {
            helpBroker.setDisplayed(true);
        }
    }

    public static void showHelp(String target) {
        JHelpAction.showHelp();
        if (target != null) {
            try {
                if (JHelpAction.getHelpBroker() != null) {
                    JHelpAction.getHelpBroker().setCurrentID(Map.ID.create((String)target, (HelpSet)helpBroker.getHelpSet()));
                }
            }
            catch (InvalidHelpSetContextException ee) {
                log.error((Object)("Invalid helpset for target \"" + target + "\""), (Throwable)ee);
            }
        }
    }

    public static void showHelpFromFocus() {
        if (JHelpAction.getHelpBroker() != null) {
            new CSH.DisplayHelpFromFocus(helpBroker).actionPerformed(cshAction);
        }
    }

    public static void startHelpWorker(String hSetName) {
        if (hSetName == null) {
            throw new IllegalArgumentException("Helpset name was null.");
        }
        helpSetName = hSetName;
        worker = new WorkerHelpset(helpSetName, null);
        worker.start();
    }

    public static void startHelpWorker(List helpSetList) {
        if (helpSetList == null) {
            throw new IllegalArgumentException("Helpset list was null.");
        }
        if (helpSetList.size() == 0) {
            return;
        }
        for (int i = 0; i < helpSetList.size(); ++i) {
            if (helpSetList.get(i) != null) continue;
            throw new IllegalArgumentException("Helpset list contains null elements.");
        }
        helpSetName = helpSetList.get(0).toString();
        if (helpSetList.size() == 1) {
            JHelpAction.startHelpWorker(helpSetList.get(0).toString());
            return;
        }
        String[] hSetArray = new String[helpSetList.size() - 1];
        for (int i = 1; i < helpSetList.size(); ++i) {
            hSetArray[i - 1] = helpSetList.get(i).toString();
        }
        worker = new WorkerHelpset(helpSetName, hSetArray);
        worker.start();
    }

    public static void trackFieldHelp() {
        if (JHelpAction.getHelpBroker() != null) {
            new CSH.DisplayHelpAfterTracking(helpBroker).actionPerformed(cshAction);
        }
    }

    private static final class WorkerHelpset
    extends SwingWorker {
        private static Point loc = new Point(220, 0);
        private static Dimension dimension = new Dimension(700, 600);
        private final String helpSetName;
        private HelpBroker mainHelpBroker = null;
        private String[] mergeSets = null;

        public WorkerHelpset(String helpSetName, String[] mergeSets) {
            this.helpSetName = helpSetName;
            this.mergeSets = mergeSets;
        }

        public synchronized Object construct() {
            if (this.mainHelpBroker == null) {
                try {
                    URL hsURL = HelpSet.findHelpSet((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)this.helpSetName);
                    HelpSet mainHelpSet = new HelpSet(null, hsURL);
                    if (this.mergeSets != null) {
                        for (int i = 0; i < this.mergeSets.length; ++i) {
                            try {
                                URL hsMergeURL = HelpSet.findHelpSet((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)this.mergeSets[i]);
                                HelpSet mergeHelpSet = new HelpSet(null, hsMergeURL);
                                mainHelpSet.add(mergeHelpSet);
                                continue;
                            }
                            catch (Throwable ex) {
                                log.error((Object)("Helpset \"" + this.mergeSets[i] + "\" could not be created.\n" + ex.getMessage()));
                            }
                        }
                    }
                    this.mainHelpBroker = mainHelpSet.createHelpBroker();
                }
                catch (Throwable ee) {
                    log.error((Object)("\nHelpSet " + this.helpSetName + " not created.\n" + ee.getMessage()));
                    return null;
                }
                this.mainHelpBroker.setLocation(loc);
                this.mainHelpBroker.setSize(dimension);
            }
            return this.mainHelpBroker;
        }

        public Object get() {
            return this.construct();
        }
    }
}

