/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.Scope;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.SymbolEvent;
import com.jstatcom.model.SymbolListener;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.util.UMatrix;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.FontUIResource;
import org.apache.log4j.Logger;

public final class CheckBoxList
extends JList
implements SymbolListener {
    private static final Logger log = Logger.getLogger(CheckBoxList.class);
    private JSCTypeDef symbolDef = null;
    private Symbol symbol = null;
    private String symbolNameSelected = null;
    private CheckBoxListItem[] currentData = new CheckBoxListItem[0];
    private Scope symbolScope = Scope.GLOBAL;
    private String fieldBorderTitle = "";
    private final HashMap<Object, CheckBoxListItem> map = new HashMap();
    private final MouseEventHandler mouseEventHandler = new MouseEventHandler();
    private final KeyEventHandler keyEventHandler = new KeyEventHandler();
    private static final CheckBoxListCellRenderer renderer = new CheckBoxListCellRenderer();

    @Override
    public void valueChanged(SymbolEvent evt) {
        this.symbol = evt.getSource();
        this.setJSCSArray(this.symbol.getJSCSArray());
    }

    public CheckBoxList() {
        this.initialize();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateSymbol();
    }

    private void checkBoxList_MouseClicked(MouseEvent mouseEvent) {
        CheckBoxListItem item;
        int sel = this.locationToIndex(mouseEvent.getPoint());
        if (sel < 0) {
            return;
        }
        item.setSelected(!(item = (CheckBoxListItem)this.getModel().getElementAt(sel)).isSelected());
        this.storeStatusToSelSymbol();
        this.setSelectionChanged();
        this.repaint();
    }

    public void clear() {
        this.map.clear();
        this.removeAll();
        this.storeStatusToSelSymbol();
    }

    public void clearSelectionStatus() {
        int[] oldStatus = this.getIntSelectionStatus();
        if (UMatrix.getNonzeroIntCount(oldStatus) == 0) {
            return;
        }
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            ((CheckBoxListItem)this.getModel().getElementAt(i)).setSelected(false);
        }
        this.storeStatusToSelSymbol();
        this.setSelectionChanged();
        this.repaint();
    }

    public void setSelectionStatus(int[] selIndizes) {
        int i;
        if (selIndizes == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (selIndizes.length != this.getModel().getSize()) {
            throw new IllegalArgumentException("Argument selection array has length " + selIndizes.length + " but model size is " + this.getModel().getSize() + ".");
        }
        int[] oldStatus = this.getIntSelectionStatus();
        boolean isEqual = true;
        for (i = 0; i < oldStatus.length; ++i) {
            int check;
            int n = check = selIndizes[i] == 0 ? 0 : 1;
            if (oldStatus[i] == check) continue;
            isEqual = false;
            break;
        }
        if (isEqual) {
            return;
        }
        for (i = 0; i < this.getModel().getSize(); ++i) {
            ((CheckBoxListItem)this.getModel().getElementAt(i)).setSelected(selIndizes[i] != 0);
        }
        this.storeStatusToSelSymbol();
        this.setSelectionChanged();
        this.repaint();
    }

    public boolean[] getBoolSelectionStatus() {
        boolean[] selIndices = new boolean[this.getModel().getSize()];
        for (int i = 0; i < selIndices.length; ++i) {
            selIndices[i] = ((CheckBoxListItem)this.getModel().getElementAt(i)).isSelected();
        }
        return selIndices;
    }

    public String getBorderTitle() {
        return this.fieldBorderTitle;
    }

    public int[] getIntSelectionStatus() {
        int[] selIndices = new int[this.getModel().getSize()];
        for (int i = 0; i < selIndices.length; ++i) {
            selIndices[i] = ((CheckBoxListItem)this.getModel().getElementAt(i)).isSelected() ? 1 : 0;
        }
        return selIndices;
    }

    public Object[] getSelectedObjects() {
        ArrayList<Object> sel = new ArrayList<Object>();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            CheckBoxListItem item = (CheckBoxListItem)this.getModel().getElementAt(i);
            if (!item.isSelected()) continue;
            sel.add(item.getValue());
        }
        return sel.toArray();
    }

    public String getSymbolName() {
        return this.symbolDef == null ? null : this.symbolDef.name;
    }

    public String getSymbolNameSelected() {
        return this.symbolNameSelected;
    }

    private void handleException(Throwable exception) {
        log.error((Object)"Unhandled Exception", exception);
    }

    private void initConnections() throws Exception {
        this.addMouseListener(this.mouseEventHandler);
        this.addKeyListener(this.keyEventHandler);
    }

    private void initialize() {
        try {
            this.setName("CheckBoxList");
            this.setSize(160, 120);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setCellRenderer(renderer);
        this.setListData(this.currentData);
    }

    public void setBorderTitle(String borderTitle) {
        String oldValue = this.fieldBorderTitle;
        this.fieldBorderTitle = borderTitle;
        TitledBorder title = new TitledBorder(new EtchedBorder(), borderTitle, 3, 2);
        title.setTitleFont(new FontUIResource("dialog", 0, 10));
        this.setBorder(title);
        this.firePropertyChange("borderTitle", oldValue, borderTitle);
    }

    public void setObjArray(Object[] values) {
        int i;
        if (values == null) {
            throw new IllegalArgumentException("Object array is null");
        }
        CheckBoxListItem[] listData = new CheckBoxListItem[values.length];
        ArrayList<Object> alreadyEncountered = new ArrayList<Object>();
        for (i = 0; i < listData.length; ++i) {
            if (values[i] == null) {
                values[i] = "null";
            }
            if (!this.map.containsKey(values[i])) {
                listData[i] = new CheckBoxListItem(values[i].toString(), values[i]);
                this.map.put(values[i], listData[i]);
            } else {
                listData[i] = alreadyEncountered.contains(values[i]) ? new CheckBoxListItem(values[i].toString(), values[i]) : this.map.get(values[i]);
            }
            alreadyEncountered.add(values[i]);
        }
        this.map.clear();
        for (i = 0; i < listData.length; ++i) {
            this.map.put(values[i], listData[i]);
        }
        this.currentData = listData;
        this.setListData(listData);
        this.storeStatusToSelSymbol();
    }

    public void setJSCSArray(JSCSArray dataKeys) {
        if (dataKeys == null) {
            throw new IllegalArgumentException("Data object is null");
        }
        Object[] obj = new Object[dataKeys.rows()];
        for (int i = 0; i < obj.length; ++i) {
            obj[i] = dataKeys.stringAt(i, 0);
        }
        this.setObjArray(obj);
    }

    public void setSelectionChanged() {
        this.firePropertyChange("selectionChanged", true, false);
    }

    public void setSymbolName(String newSymbolName) {
        this.symbolDef = newSymbolName == null ? null : new JSCTypeDef(newSymbolName, JSCTypes.SARRAY);
        this.updateSymbol();
    }

    public void setSymbolNameSelected(String newSymbolNameSelected) {
        if (newSymbolNameSelected != null) {
            JSCConstants.checkNameThrowEx(newSymbolNameSelected);
        }
        this.symbolNameSelected = newSymbolNameSelected;
        this.storeStatusToSelSymbol();
    }

    private void storeStatusToSelSymbol() {
        if (this.symbolNameSelected == null) {
            return;
        }
        SymbolTable sTable = this.symbolScope.getSymbolTable(this);
        if (sTable != null) {
            sTable.set(new JSCNArray(this.symbolNameSelected, this.getIntSelectionStatus()));
        }
    }

    public Scope getSymbolScope() {
        return this.symbolScope;
    }

    private void updateSymbol() {
        SymbolTable sTable;
        if (this.symbol != null) {
            this.symbol.removeSymbolListener(this);
        }
        if (this.symbolDef != null && (sTable = this.symbolScope.getSymbolTable(this)) != null) {
            this.symbol = sTable.get(this.symbolDef);
            this.setJSCSArray(this.symbol.getJSCSArray());
            this.symbol.addSymbolListener(this);
            return;
        }
    }

    public void setSymbolScope(Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument was null");
        }
        this.symbolScope = scope;
        this.updateSymbol();
    }

    class KeyEventHandler
    extends KeyAdapter {
        KeyEventHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() != CheckBoxList.this) {
                return;
            }
            if (keyEvent.getKeyCode() == 65 && keyEvent.getModifiers() == 2) {
                for (int i = 0; i < CheckBoxList.this.currentData.length; ++i) {
                    CheckBoxList.this.currentData[i].setSelected(true);
                }
                CheckBoxList.this.repaint();
                CheckBoxList.this.storeStatusToSelSymbol();
            } else if (keyEvent.getKeyCode() == 88 && keyEvent.getModifiers() == 2) {
                for (int i = 0; i < CheckBoxList.this.currentData.length; ++i) {
                    CheckBoxList.this.currentData[i].setSelected(false);
                }
                CheckBoxList.this.repaint();
                CheckBoxList.this.storeStatusToSelSymbol();
            }
        }
    }

    class MouseEventHandler
    extends MouseAdapter {
        MouseEventHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == CheckBoxList.this) {
                CheckBoxList.this.checkBoxList_MouseClicked(e);
            }
        }
    }

    private static class CheckBoxListCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = ((CheckBoxListItem)value).getName();
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setText(s);
            this.setSelected(((CheckBoxListItem)value).isSelected());
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }

    private static final class CheckBoxListItem {
        private final String name;
        private final Object value;
        private boolean selected = false;

        public CheckBoxListItem(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean newSelected) {
            this.selected = newSelected;
        }
    }
}

