/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.component.AppSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public final class AppSettingsDialog
extends JDialog {
    private static TableCellEditor myEditor = new DefaultCellEditor(new JTextField()){
        private JComboBox currentCombo = new JComboBox();
        private Object currentValue = null;

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentValue = value;
            if (value instanceof Boolean) {
                this.currentCombo.removeAllItems();
                this.currentCombo.addItem(true);
                this.currentCombo.addItem(false);
                this.currentCombo.setSelectedItem(value);
                return this.currentCombo;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            if (this.currentValue instanceof Boolean) {
                return this.currentCombo.getSelectedItem();
            }
            return super.getCellEditorValue();
        }
    };
    private AppSettings appSettings = new AppSettings();
    private JPanel jPanel = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private JPanel jPanel1 = null;
    private JButton okButton = null;
    private JButton cancelButton = null;

    public AppSettingsDialog(Frame frame) {
        super(frame, true);
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJPanel());
        this.setTitle("Preferences");
        this.setSize(473, 243);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJPanel1(), "South");
            this.jPanel.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.setRowHeight(25);
            this.jTable.setRowSelectionAllowed(false);
            this.jTable.setColumnSelectionAllowed(false);
            int gapWidth = 4;
            int gapHeight = 4;
            this.jTable.setIntercellSpacing(new Dimension(gapWidth, gapHeight));
            this.jTable.setDefaultEditor(Object.class, myEditor);
            this.jTable.setShowGrid(false);
            this.jTable.setCellSelectionEnabled(false);
        }
        return this.jTable;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(flowLayout1);
            this.jPanel1.setPreferredSize(new Dimension(10, 50));
            this.jPanel1.setBorder(BorderFactory.createBevelBorder(1));
            flowLayout1.setHgap(100);
            flowLayout1.setVgap(10);
            this.jPanel1.add((Component)this.getOkButton(), null);
            this.jPanel1.add((Component)this.getCancelButton(), null);
        }
        return this.jPanel1;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.setPreferredSize(new Dimension(100, 26));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableCellEditor ed = AppSettingsDialog.this.getJTable().getCellEditor();
                    if (ed != null) {
                        ed.stopCellEditing();
                    }
                    AppSettingsDialog.this.setVisible(false);
                    AppSettingsDialog.this.appSettings = (AppSettings)AppSettingsDialog.this.getJTable().getModel();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setPreferredSize(new Dimension(100, 26));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AppSettingsDialog.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    public void setAppSettings(AppSettings appSettings) {
        if (appSettings == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.appSettings = appSettings;
        this.getJTable().setModel(new AppSettings(appSettings));
    }

    public AppSettings getAppSettings() {
        return this.appSettings;
    }
}

