/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.component.TopFrame;
import com.jstatcom.model.JSCInt;
import com.jstatcom.project.ProjectManager;
import com.jstatcom.project.SettingsElement;
import javax.swing.table.AbstractTableModel;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public final class AppSettings
extends AbstractTableModel
implements SettingsElement {
    private JSCInt saveLastState = new JSCInt("lastState", 1);
    private JSCInt sControlEdit = new JSCInt("sControlEdit", 0);
    private JSCInt exitDialog = new JSCInt("exitDialog", 1);
    private JSCInt showExplorer = new JSCInt("showExplorer", 1);
    private static final int defaultMax = 10000;
    private JSCInt maxArrayDisplaySize = new JSCInt("maxArrayDisplaySize", 10000);
    public static final XmlFormat<AppSettings> AppSettings_XML = new XmlFormat<AppSettings>(AppSettings.class){

        @Override
        public void format(AppSettings data, XmlElement xml) {
            xml.add(data.saveLastState);
            xml.add(data.sControlEdit);
            xml.add(data.exitDialog);
            xml.add(data.showExplorer);
            xml.add(data.maxArrayDisplaySize);
        }

        @Override
        public AppSettings parse(XmlElement xml) {
            JSCInt val;
            AppSettings settings = new AppSettings();
            if (xml.hasNext()) {
                val = (JSCInt)xml.getNext();
                settings.saveLastState = val;
            }
            if (xml.hasNext()) {
                val = (JSCInt)xml.getNext();
                settings.sControlEdit = val;
            }
            if (xml.hasNext()) {
                val = (JSCInt)xml.getNext();
                settings.exitDialog = val;
            }
            if (xml.hasNext()) {
                val = (JSCInt)xml.getNext();
                settings.showExplorer = val;
            }
            if (xml.hasNext()) {
                val = (JSCInt)xml.getNext();
                if (val.intVal() < 0) {
                    val.setInt(10000);
                }
                settings.maxArrayDisplaySize = val;
            }
            return settings;
        }
    };

    public AppSettings() {
    }

    public AppSettings(AppSettings appSettings) {
        this.saveLastState = appSettings.saveLastState.copy();
        this.sControlEdit = appSettings.sControlEdit.copy();
        this.exitDialog = appSettings.exitDialog.copy();
        this.showExplorer = appSettings.showExplorer.copy();
        this.maxArrayDisplaySize = appSettings.maxArrayDisplaySize.copy();
    }

    @Override
    public void setElement() {
        TopFrame topFrame = ProjectManager.getInstance().getTopFrame();
        if (topFrame != null) {
            topFrame.setAppSettings(this);
        }
    }

    public JSCInt getSaveLastState() {
        return this.saveLastState;
    }

    public JSCInt getSControlEdit() {
        return this.sControlEdit;
    }

    public JSCInt getExitDialog() {
        return this.exitDialog;
    }

    public JSCInt getShowExplorer() {
        return this.showExplorer;
    }

    public JSCInt getMaxArrayDisplaySize() {
        return this.maxArrayDisplaySize;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return 5;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "Property";
        }
        if (col == 1) {
            return "Value";
        }
        throw new RuntimeException("Invalid column index " + col + ".");
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount() || col >= this.getColumnCount()) {
            throw new IndexOutOfBoundsException("Index " + row + ":" + col + " is out of range.");
        }
        if (col == 0) {
            if (row == 0) {
                return "save/restore last project state";
            }
            if (row == 1) {
                return "matrices in symbol table editable (expert)";
            }
            if (row == 2) {
                return "show exit dialog";
            }
            if (row == 3) {
                return "show explorer panel";
            }
            if (row == 4) {
                return "maximum number of array elements to display in symbol control";
            }
        }
        if (col == 1) {
            if (row == 0) {
                return this.saveLastState.intVal() != 0;
            }
            if (row == 1) {
                return this.sControlEdit.intVal() != 0;
            }
            if (row == 2) {
                return this.exitDialog.intVal() != 0;
            }
            if (row == 3) {
                return this.showExplorer.intVal() != 0;
            }
            if (row == 4) {
                return this.maxArrayDisplaySize.intVal();
            }
        }
        throw new RuntimeException("Should never be reached.");
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            if (row == 0) {
                this.saveLastState.setVal((Boolean)value != false ? 1 : 0);
            }
            if (row == 1) {
                this.sControlEdit.setVal((Boolean)value != false ? 1 : 0);
            }
            if (row == 2) {
                this.exitDialog.setVal((Boolean)value != false ? 1 : 0);
            }
            if (row == 3) {
                this.showExplorer.setVal((Boolean)value != false ? 1 : 0);
            }
            if (row == 4) {
                Integer val = null;
                try {
                    val = Integer.parseInt(value + "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (val != null && val >= 0) {
                    this.maxArrayDisplaySize.setVal(val);
                }
            }
        }
    }
}

