/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.utilities;

import com.yahoo.egads.utilities.StatsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoSensitivity {
    static Logger logger = LogManager.getLogger((String)AutoSensitivity.class.getName());

    public static Float getLowDensitySensitivity(Float[] data, float sDAutoSensitivy, float amntAutoSensitivity) {
        Float toReturn = Float.valueOf(Float.POSITIVE_INFINITY);
        Arrays.sort(data, Collections.reverseOrder());
        if (data.length > 0) {
            ArrayList<Float> fData = new ArrayList<Float>();
            fData.add(data[0]);
            data = (Float[])ArrayUtils.remove((Object[])data, (int)0);
            Float centroid = Float.valueOf(((Float)fData.get(0)).floatValue());
            Float maxDelta = Float.valueOf(sDAutoSensitivy * StatsUtils.getSD(data, StatsUtils.getMean(data)).floatValue());
            logger.debug("AutoSensitivity: Adding: " + fData.get(0) + " SD: " + maxDelta);
            Object localDebug = null;
            while (data.length > 0 && centroid.floatValue() - data[0].floatValue() <= maxDelta.floatValue()) {
                float maxDeltaInit = maxDelta.floatValue();
                fData.add(data[0]);
                data = (Float[])ArrayUtils.remove((Object[])data, (int)0);
                Float[] tmp = new Float[fData.size()];
                tmp = fData.toArray(tmp);
                centroid = StatsUtils.getMean(tmp);
                if (data.length <= 0) continue;
                Float sdOtherCluster = Float.valueOf(StatsUtils.getSD(data, StatsUtils.getMean(data)).floatValue());
                maxDelta = Float.valueOf(sDAutoSensitivy * sdOtherCluster.floatValue());
                logger.debug("AutoSensitivity: Adding: " + data[0] + " SD: " + maxDeltaInit + " SD': " + maxDelta);
            }
            if (data.length > 0) {
                logger.debug("AutoSensitivity: Next Point I would have added is " + data[0]);
            }
            if ((double)fData.size() / (double)data.length > (double)amntAutoSensitivity) {
                logger.debug("AutoSensitivity: Returning " + toReturn + " data size: " + data.length + " fData.size: " + fData.size());
                return toReturn;
            }
            toReturn = (Float)fData.get(fData.size() - 1);
            logger.debug("AutoSensitivity: Updating toReturn:  " + toReturn + " SD: " + maxDelta);
            return toReturn;
        }
        return toReturn;
    }

    public static Float getKSigmaSensitivity(Float[] data, float sDAutoSensitivity) {
        Float mean = StatsUtils.getMean(data);
        Float sd = StatsUtils.getSD(data, mean);
        return Float.valueOf(mean.floatValue() + sd.floatValue() * sDAutoSensitivity);
    }

    public static Float[] getAdaptiveKSigmaSensitivity(Float[] data, float amntAutoSens) {
        Float mean = StatsUtils.getMean(data);
        Float sd = StatsUtils.getSD(data, mean);
        if (sd.floatValue() == 0.0f) {
            sd = Float.valueOf(1.0f);
        }
        Float[] ret = null;
        float k = 1.0f;
        float incr = 1.0f;
        Float max = null;
        Float min = null;
        float thresh = mean.floatValue() + Math.abs(sd.floatValue() * k);
        int howMany = AutoSensitivity.howManyGreater(data, Float.valueOf(thresh));
        while ((float)howMany / (float)data.length > amntAutoSens) {
            thresh = mean.floatValue() + Math.abs(sd.floatValue() * (k += incr));
            howMany = AutoSensitivity.howManyGreater(data, Float.valueOf(thresh));
        }
        if ((float)howMany / (float)data.length <= amntAutoSens) {
            max = Float.valueOf(thresh);
        }
        k = 1.0f;
        thresh = mean.floatValue() - Math.abs(sd.floatValue() * k);
        howMany = AutoSensitivity.howManyLess(data, Float.valueOf(thresh));
        while ((float)howMany / (float)data.length > amntAutoSens) {
            thresh = mean.floatValue() - Math.abs(sd.floatValue() * (k += incr));
            howMany = AutoSensitivity.howManyLess(data, Float.valueOf(thresh));
        }
        if ((float)howMany / (float)data.length <= amntAutoSens) {
            min = Float.valueOf(thresh);
        }
        ret = new Float[]{max, min};
        return ret;
    }

    public static Float[] getAdaptiveMaxMinSigmaSensitivity(Float[] data, float amntAutoSens, float k) {
        Arrays.sort((Object[])data);
        Float mean = StatsUtils.getMean(data);
        Float sd = StatsUtils.getSD(data, mean);
        if (sd.floatValue() == 0.0f) {
            sd = Float.valueOf(1.0f);
        }
        Float[] ret = null;
        Float max = null;
        Float min = null;
        int i = 0;
        float thresh = data[i].floatValue() + Math.abs(sd.floatValue() * k);
        int howMany = AutoSensitivity.howManyLess(data, Float.valueOf(thresh));
        while ((float)howMany / (float)data.length <= amntAutoSens) {
            min = Float.valueOf(thresh);
            thresh = data[++i].floatValue() + Math.abs(sd.floatValue() * k);
            howMany = AutoSensitivity.howManyLess(data, Float.valueOf(thresh));
        }
        i = data.length - 1;
        thresh = data[i].floatValue() - Math.abs(sd.floatValue() * k);
        howMany = AutoSensitivity.howManyGreater(data, Float.valueOf(thresh));
        while ((float)howMany / (float)data.length <= amntAutoSens) {
            max = Float.valueOf(thresh);
            thresh = data[--i].floatValue() - Math.abs(sd.floatValue() * k);
            howMany = AutoSensitivity.howManyGreater(data, Float.valueOf(thresh));
        }
        ret = new Float[]{max, min};
        return ret;
    }

    private static int howManyGreater(Float[] data, Float value) {
        int numgreater = 0;
        for (Float f : data) {
            if (!(value.floatValue() <= f.floatValue())) continue;
            ++numgreater;
        }
        return numgreater;
    }

    private static int howManyLess(Float[] data, Float value) {
        int numless = 0;
        for (Float f : data) {
            if (!(value.floatValue() >= f.floatValue())) continue;
            ++numless;
        }
        return numless;
    }
}

