/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.models.adm;

import com.yahoo.egads.data.Anomaly;
import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.models.adm.AnomalyDetectionAbstractModel;
import com.yahoo.egads.utilities.AutoSensitivity;
import java.util.Map;
import java.util.Properties;
import org.json.JSONObject;
import org.json.JSONStringer;

public class SimpleThresholdModel
extends AnomalyDetectionAbstractModel {
    private Map<String, Float> threshold;
    private int maxHrsAgo;
    private long windowStart;
    private String modelName = "SimpleThresholdModel";
    private String simpleThrType = "AdaptiveKSigmaSensitivity";

    public SimpleThresholdModel(Properties config) {
        super(config);
        this.threshold = this.parseMap(config.getProperty("THRESHOLD"));
        this.maxHrsAgo = new Integer(config.getProperty("MAX_ANOMALY_TIME_AGO"));
        this.windowStart = new Long(config.getProperty("DETECTION_WINDOW_START_TIME"));
        if (config.getProperty("THRESHOLD") != null && this.threshold.isEmpty()) {
            throw new IllegalArgumentException("THRESHOLD PARSE ERROR");
        }
        if (config.getProperty("SIMPLE_THRESHOLD_TYPE") != null) {
            this.simpleThrType = config.getProperty("SIMPLE_THRESHOLD_TYPE");
        }
    }

    @Override
    public void toJson(JSONStringer json_out) {
    }

    @Override
    public void fromJson(JSONObject json_obj) {
    }

    @Override
    public String getType() {
        return "point_outlier";
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public void reset() {
    }

    @Override
    public void tune(TimeSeries.DataSequence observedSeries, TimeSeries.DataSequence expectedSeries, Anomaly.IntervalSequence anomalySequence) throws Exception {
        Float[] thr = null;
        thr = this.simpleThrType.equals("AdaptiveKSigmaSensitivity") ? AutoSensitivity.getAdaptiveKSigmaSensitivity(observedSeries.getValues(), this.amntAutoSensitivity) : AutoSensitivity.getAdaptiveMaxMinSigmaSensitivity(observedSeries.getValues(), this.amntAutoSensitivity, this.sDAutoSensitivity);
        if (!this.threshold.containsKey("max")) {
            this.threshold.put("max", thr[0]);
        }
        if (!this.threshold.containsKey("min")) {
            this.threshold.put("min", thr[1]);
        }
    }

    @Override
    public Anomaly.IntervalSequence detect(TimeSeries.DataSequence observedSeries, TimeSeries.DataSequence expectedSeries) throws Exception {
        Anomaly.IntervalSequence output = new Anomaly.IntervalSequence();
        Float[] thr = new Float[]{this.threshold.get("max"), this.threshold.get("min")};
        int n = observedSeries.size();
        for (int i = 0; i < n; ++i) {
            TimeSeries.Entry entry = (TimeSeries.Entry)observedSeries.get(i);
            if (!(thr[0] != null && entry.value >= thr[0].floatValue()) && (thr[1] == null || !(entry.value <= thr[1].floatValue())) || !this.isDetectionWindowPoint(this.maxHrsAgo, this.windowStart, entry.time, ((TimeSeries.Entry)observedSeries.get((int)0)).time) && (this.maxHrsAgo != 0 || i != n - 1)) continue;
            if (thr[0] != null && entry.value >= thr[0].floatValue()) {
                output.add(new Anomaly.Interval(entry.time, i, null, thr, entry.value, thr[0].floatValue()));
                continue;
            }
            output.add(new Anomaly.Interval(entry.time, i, null, thr, entry.value, thr[1].floatValue()));
        }
        return output;
    }
}

