/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.models.adm;

import com.yahoo.egads.data.JsonEncoder;
import com.yahoo.egads.models.adm.AnomalyDetectionModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.json.JSONStringer;

public abstract class AnomalyDetectionAbstractModel
implements AnomalyDetectionModel {
    protected Logger logger = LogManager.getLogger((String)this.getClass().getName());
    protected float sDAutoSensitivity = 3.0f;
    protected float amntAutoSensitivity = 0.05f;
    protected String outputDest = "";
    protected String modelName;

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public String getModelType() {
        return "Anomaly";
    }

    @Override
    public void toJson(JSONStringer json_out) throws Exception {
        JsonEncoder.toJson(this, json_out);
    }

    @Override
    public void fromJson(JSONObject json_obj) throws Exception {
        JsonEncoder.fromJson((Object)this, json_obj);
    }

    protected String arrayF2S(Float[] input) {
        String ret = new String();
        if (input.length == 0) {
            return "";
        }
        ret = input[0] == null ? "Inf" : input[0].toString();
        for (int ix = 1; ix < input.length; ++ix) {
            ret = input[ix] == null ? ret + ":Inf" : ret + ":" + input[ix].toString();
        }
        return ret;
    }

    protected Map<String, Float> parseMap(String s) {
        if (s == null) {
            return new HashMap<String, Float>();
        }
        String[] pairs = s.split(",");
        HashMap<String, Float> myMap = new HashMap<String, Float>();
        for (int i = 0; i < pairs.length; ++i) {
            String pair = pairs[i];
            String[] keyValue = pair.split("#");
            myMap.put(keyValue[0], Float.valueOf(keyValue[1]));
        }
        return myMap;
    }

    public AnomalyDetectionAbstractModel(Properties config) {
        if (config.getProperty("AUTO_SENSITIVITY_ANOMALY_PCNT") != null) {
            this.amntAutoSensitivity = new Float(config.getProperty("AUTO_SENSITIVITY_ANOMALY_PCNT")).floatValue();
        }
        if (config.getProperty("AUTO_SENSITIVITY_SD") != null) {
            this.sDAutoSensitivity = new Float(config.getProperty("AUTO_SENSITIVITY_SD")).floatValue();
        }
        this.outputDest = config.getProperty("OUTPUT");
    }

    @Override
    public boolean isDetectionWindowPoint(int maxHrsAgo, long windowStart, long anomalyTime, long startTime) {
        long unixTime = System.currentTimeMillis() / 1000L;
        if (windowStart >= startTime) {
            return anomalyTime - windowStart > 0L;
        }
        return (unixTime - anomalyTime) / 3600L < (long)maxHrsAgo;
    }
}

