/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.models.adm;

import com.yahoo.egads.data.Anomaly;
import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.models.adm.AnomalyDetectionAbstractModel;
import com.yahoo.egads.utilities.ListUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.json.JSONObject;
import org.json.JSONStringer;

public class AdaptiveKernelDensityChangePointDetector
extends AnomalyDetectionAbstractModel {
    private LinkedList<Float> buffer = new LinkedList();
    private LinkedList<Float> sdBuffer = new LinkedList();
    private LinkedList<Float> preKernelSum = new LinkedList();
    private LinkedList<Float> postKernelSum = new LinkedList();
    private float sumBuffer = 0.0f;
    private float sqrSumBuffer = 0.0f;
    private int maxHrsAgo;
    private long windowStart;
    private float[] score = null;
    private float[] level = null;
    protected int preWindowSize = 24;
    protected int postWindowSize = 48;
    protected float confidence = 0.8f;
    private String modelName = "AdaptiveKernelDensityChangePointDetector";

    public AdaptiveKernelDensityChangePointDetector(Properties config) {
        super(config);
        this.maxHrsAgo = new Integer(config.getProperty("MAX_ANOMALY_TIME_AGO"));
        this.windowStart = new Long(config.getProperty("DETECTION_WINDOW_START_TIME"));
        if (config.getProperty("PRE_WINDOW_SIZE") == null) {
            throw new IllegalArgumentException("PRE_WINDOW_SIZE is NULL");
        }
        if (config.getProperty("POST_WINDOW_SIZE") == null) {
            throw new IllegalArgumentException("POST_WINDOW_SIZE is NULL");
        }
        this.preWindowSize = new Integer(config.getProperty("PRE_WINDOW_SIZE"));
        this.postWindowSize = new Integer(config.getProperty("POST_WINDOW_SIZE"));
        this.confidence = config.getProperty("CONFIDENCE") == null ? 0.8f : new Float(config.getProperty("CONFIDENCE")).floatValue();
    }

    @Override
    public void toJson(JSONStringer json_out) throws Exception {
    }

    @Override
    public void fromJson(JSONObject json_obj) throws Exception {
    }

    @Override
    public String getType() {
        return "change_point";
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public void reset() {
        this.buffer.clear();
        this.sdBuffer.clear();
        this.preKernelSum.clear();
        this.postKernelSum.clear();
        this.sumBuffer = 0.0f;
        this.sqrSumBuffer = 0.0f;
        this.score = null;
        this.level = null;
    }

    @Override
    public void tune(TimeSeries.DataSequence observedSeries, TimeSeries.DataSequence expectedSeries, Anomaly.IntervalSequence anomalySequence) throws Exception {
    }

    @Override
    public Anomaly.IntervalSequence detect(TimeSeries.DataSequence observedSeries, TimeSeries.DataSequence expectedSeries) throws Exception {
        if (observedSeries.size() != expectedSeries.size()) {
            throw new Exception("The observed time-series must have the same length as the expected time-series.");
        }
        long unixTime = System.currentTimeMillis() / 1000L;
        Anomaly.IntervalSequence result = new Anomaly.IntervalSequence();
        int n = observedSeries.size();
        float[] residuals = new float[n];
        for (int i = 0; i < n; ++i) {
            residuals[i] = ((TimeSeries.Entry)observedSeries.get((int)i)).value - ((TimeSeries.Entry)expectedSeries.get((int)i)).value;
        }
        ArrayList<Integer> changePoints = this.detectChangePoints(residuals, this.preWindowSize, this.postWindowSize, this.confidence);
        if (this.outputDest.equals("STD_OUT_ALL")) {
            int j = 0;
            for (int i = 0; i < n; ++i) {
                boolean isCP = false;
                if (!changePoints.isEmpty()) {
                    boolean bl = isCP = changePoints.get(j) == i;
                }
                if (isCP && j < changePoints.size() - 1) {
                    ++j;
                }
                this.logger.debug("TS:" + ((TimeSeries.Entry)observedSeries.get((int)i)).time + ",SC:" + String.join((CharSequence)":", this.arrayF2S(new Float[]{Float.valueOf(this.score[i])})) + ",LV:" + this.arrayF2S(new Float[]{Float.valueOf(this.level[i])}) + ",OV:" + ((TimeSeries.Entry)observedSeries.get((int)i)).value + ",EV:" + ((TimeSeries.Entry)expectedSeries.get((int)i)).value);
                result.add(new Anomaly.Interval(((TimeSeries.Entry)observedSeries.get((int)i)).time, i, new Float[]{Float.valueOf(this.score[i])}, new Float[]{Float.valueOf(this.level[i])}, ((TimeSeries.Entry)observedSeries.get((int)i)).value, ((TimeSeries.Entry)expectedSeries.get((int)i)).value, isCP));
            }
        } else {
            for (int index : changePoints) {
                if (!this.isDetectionWindowPoint(this.maxHrsAgo, this.windowStart, ((TimeSeries.Entry)observedSeries.get((int)index)).time, ((TimeSeries.Entry)observedSeries.get((int)0)).time)) continue;
                result.add(new Anomaly.Interval(((TimeSeries.Entry)observedSeries.get((int)index)).time, index, new Float[]{Float.valueOf(this.score[index])}, new Float[]{Float.valueOf(this.level[index])}, ((TimeSeries.Entry)observedSeries.get((int)index)).value, ((TimeSeries.Entry)expectedSeries.get((int)index)).value));
            }
        }
        return result;
    }

    public ArrayList<Integer> detectChangePoints(float[] residuals, int preWindowSize, int postWindowSize, float confidence) {
        int n = residuals.length;
        this.score = new float[n];
        this.level = new float[n];
        ArrayList<Integer> changePoints = new ArrayList<Integer>();
        float maxScore = Float.NEGATIVE_INFINITY;
        int maxIndex = -1;
        float delta = 1.0E-8f;
        int counter = 0;
        int i = 0;
        while (i < n) {
            float[] temp = this.computeKLScore(residuals[i], preWindowSize, postWindowSize, confidence);
            this.score[i] = temp[0];
            this.level[i] = temp[1];
            if (this.score[i] > delta) {
                if (this.score[i] > maxScore) {
                    maxScore = this.score[i];
                    maxIndex = i;
                }
            } else if (this.score[i] < -delta && maxIndex >= 0) {
                if (counter - i + maxIndex > postWindowSize) {
                    changePoints.add(maxIndex - postWindowSize + 1);
                    counter = i - maxIndex;
                }
                maxScore = Float.NEGATIVE_INFINITY;
                maxIndex = -1;
            }
            ++i;
            ++counter;
        }
        if (maxIndex >= 0) {
            changePoints.add(maxIndex - postWindowSize + 1);
        }
        return changePoints;
    }

    protected float[] computeKLScore(float residual, int preWindowSize, int postWindowSize, float confidence) {
        float dKL = 0.0f;
        float levelThreshold = 0.0f;
        int len = this.buffer.size();
        if (len < preWindowSize) {
            this.buffer.addLast(Float.valueOf(residual));
            this.postKernelSum.addLast(Float.valueOf(0.0f));
            if (len == preWindowSize - 1) {
                int n = preWindowSize;
                this.sumBuffer = ListUtils.sumQ(this.buffer);
                this.sqrSumBuffer = ListUtils.sum2Q(this.buffer);
                float temp = (float)Math.max(1.0E-5, Math.sqrt(2.0f * ((float)n * this.sqrSumBuffer - this.sumBuffer * this.sumBuffer) / (float)(n * (n - 1))));
                ListUtils.repQ(this.sdBuffer, temp, n);
                Iterator iterator = this.buffer.iterator();
                while (iterator.hasNext()) {
                    float x = ((Float)iterator.next()).floatValue();
                    this.preKernelSum.addLast(Float.valueOf(ListUtils.kernelSum(x, this.buffer, this.sdBuffer)));
                }
            }
        } else if (len < preWindowSize + postWindowSize) {
            this.sumBuffer += residual;
            this.sqrSumBuffer += residual * residual;
            int n = len + 1;
            float temp = (float)Math.max(1.0E-5, Math.sqrt(2.0f * ((float)n * this.sqrSumBuffer - this.sumBuffer * this.sumBuffer) / (float)(n * (n - 1))));
            this.sdBuffer.addLast(Float.valueOf(temp));
            LinkedList<Float> tempQ1 = new LinkedList<Float>();
            tempQ1.add(Float.valueOf(residual));
            LinkedList<Float> tempQ2 = new LinkedList<Float>();
            tempQ2.add(Float.valueOf(temp));
            ListUtils.addQ(this.postKernelSum, ListUtils.kernelQ(this.buffer, tempQ1, tempQ2));
            this.buffer.addLast(Float.valueOf(residual));
            this.preKernelSum.addLast(Float.valueOf(ListUtils.kernelSubSum(residual, this.buffer, this.sdBuffer, 0, preWindowSize - 1)));
            this.postKernelSum.addLast(Float.valueOf(ListUtils.kernelSubSum(residual, this.buffer, this.sdBuffer, preWindowSize, this.buffer.size() - 1)));
        } else {
            LinkedList<Float> preRemovedValues = ListUtils.kernelQ(this.buffer, this.buffer.subList(0, 1), this.sdBuffer.subList(0, 1));
            ListUtils.subtractQ(this.preKernelSum, preRemovedValues);
            LinkedList<Float> midExchangedValues = ListUtils.kernelQ(this.buffer, this.buffer.subList(preWindowSize, preWindowSize + 1), this.sdBuffer.subList(preWindowSize, preWindowSize + 1));
            ListUtils.addQ(this.preKernelSum, midExchangedValues);
            int n = len;
            this.sumBuffer += residual - this.buffer.getFirst().floatValue();
            this.sqrSumBuffer = (float)((double)this.sqrSumBuffer + ((double)(residual * residual) - Math.pow(this.buffer.getFirst().floatValue(), 2.0)));
            float temp = (float)Math.max(1.0E-5, Math.sqrt(2.0f * ((float)n * this.sqrSumBuffer - this.sumBuffer * this.sumBuffer) / (float)(n * (n - 1))));
            LinkedList<Float> tempQ1 = new LinkedList<Float>();
            tempQ1.add(Float.valueOf(residual));
            LinkedList<Float> tempQ2 = new LinkedList<Float>();
            tempQ2.add(Float.valueOf(temp));
            ListUtils.subtractQ(this.postKernelSum, midExchangedValues);
            LinkedList<Float> postAddedValues = ListUtils.kernelQ(this.buffer, tempQ1, tempQ2);
            ListUtils.addQ(this.postKernelSum, postAddedValues);
            this.buffer.addLast(Float.valueOf(residual));
            this.buffer.removeFirst();
            this.sdBuffer.addLast(Float.valueOf(temp));
            this.sdBuffer.removeFirst();
            this.preKernelSum.addLast(Float.valueOf(ListUtils.kernelSubSum(residual, this.buffer, this.sdBuffer, 0, preWindowSize - 1)));
            this.postKernelSum.addLast(Float.valueOf(ListUtils.kernelSubSum(residual, this.buffer, this.sdBuffer, preWindowSize, preWindowSize + postWindowSize - 1)));
            this.preKernelSum.removeFirst();
            this.postKernelSum.removeFirst();
            float eps = 1.0E-10f;
            LinkedList<Float> preDensity = ListUtils.maxQ(this.preKernelSum.subList(preWindowSize, preWindowSize + postWindowSize), eps);
            LinkedList<Float> postDensity = ListUtils.maxQ(this.postKernelSum.subList(preWindowSize, preWindowSize + postWindowSize), eps);
            tempQ1.clear();
            tempQ1.addAll(this.preKernelSum.subList(0, preWindowSize));
            tempQ2.clear();
            tempQ2.add(Float.valueOf(1.0f / (float)preWindowSize));
            ListUtils.multiplyQ(tempQ1, tempQ2);
            float levelSet = ListUtils.quantile(tempQ1, 1.0f - confidence);
            levelThreshold = (float)(-Math.log(levelSet) - Math.log(Math.PI * 2) / 2.0 - (double)(ListUtils.sumLog(this.sdBuffer.subList(preWindowSize, preWindowSize + postWindowSize)) / (float)postWindowSize));
            dKL = (float)(((double)(ListUtils.sumLog(postDensity) - ListUtils.sumLog(preDensity)) + Math.log(preWindowSize / postWindowSize)) / (double)postWindowSize + Math.log((double)levelSet * Math.sqrt(Math.PI * 2)) + (double)(ListUtils.sumLog(this.sdBuffer.subList(preWindowSize, preWindowSize + postWindowSize)) / (float)postWindowSize));
        }
        return new float[]{dKL, levelThreshold};
    }
}

