/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.data;

import com.yahoo.egads.data.JsonAble;
import com.yahoo.egads.data.JsonEncoder;
import com.yahoo.egads.data.MetricMeta;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONObject;
import org.json.JSONStringer;

public class Anomaly
implements JsonAble {
    public String id;
    public String type = "";
    public String modelName = "";
    public MetricMeta metricMetaData;
    public IntervalSequence intervals = new IntervalSequence();

    public Anomaly() {
        this.id = null;
        this.metricMetaData = new MetricMeta(null);
    }

    public Anomaly(String id_arg, MetricMeta meta) {
        this.id = id_arg;
        this.metricMetaData = meta;
    }

    public void addInterval(long start_time, float value) {
        Interval interval = new Interval();
        interval.startTime = start_time;
        interval.value = value;
        this.intervals.add(interval);
    }

    public void addInterval(long start_time, long end_time, float value) {
        Interval interval = new Interval();
        interval.startTime = start_time;
        interval.endTime = new Long(end_time);
        interval.value = value;
        this.intervals.add(interval);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("id=" + this.id);
        String metricId = this.metricMetaData == null ? "null" : this.metricMetaData.id;
        str.append("  metric id=" + metricId);
        for (Interval i : this.intervals) {
            str.append("[id=" + this.id + " " + i.toString() + " metricId=" + metricId + "]\n");
        }
        return str.toString();
    }

    public String toPerlString() {
        StringBuffer str = new StringBuffer();
        for (Interval i : this.intervals) {
            str.append(i.utime + "," + this.metricMetaData.name + "," + this.metricMetaData.fileName + "," + this.modelName + "," + i.expectedVal + "," + i.actualVal + "," + Anomaly.printArray(i.anomalyScore) + "," + Anomaly.printArray(i.thresholdScore) + Anomaly.printDebugIsAnomaly(i.isAnomaly) + "\n");
        }
        return str.toString();
    }

    public String toPlotString() {
        StringBuffer str = new StringBuffer();
        for (Interval i : this.intervals) {
            str.append(i.utime + "," + i.actualVal + "," + i.expectedVal + Anomaly.printDebugIsAnomaly(i.isAnomaly) + "\n");
        }
        return str.toString();
    }

    public static String printDebugIsAnomaly(Boolean isAnom) {
        if (isAnom == null) {
            return "";
        }
        return "," + (isAnom == true ? "1" : "0");
    }

    public static String printArray(Float[] arr) {
        StringBuffer str = new StringBuffer();
        if (arr == null) {
            return "NA";
        }
        if (arr.length >= 1) {
            str.append(arr[0]);
        }
        for (int i = 1; i < arr.length; ++i) {
            str.append("," + arr[i]);
        }
        return str.toString();
    }

    @Override
    public void toJson(JSONStringer json_out) throws Exception {
        JsonEncoder.toJson(this, json_out);
    }

    @Override
    public void fromJson(JSONObject json_obj) throws Exception {
        JsonEncoder.fromJson((Object)this, json_obj);
    }

    public boolean equals(Object other_obj) {
        if (!(other_obj instanceof Anomaly)) {
            return false;
        }
        Anomaly other = (Anomaly)other_obj;
        if (!MetricMeta.equals(this.id, other.id)) {
            return false;
        }
        if (!MetricMeta.equals(this.type, other.type)) {
            return false;
        }
        if (!MetricMeta.equals(this.metricMetaData, other.metricMetaData)) {
            return false;
        }
        return MetricMeta.equals(this.intervals, other.intervals);
    }

    public static class IntervalSequence
    extends ArrayList<Interval> {
        private static final long serialVersionUID = 1L;

        public void setLogicalIndices(long firstTimeStamp, long period) {
            for (Interval interval : this) {
                interval.logicalStartIndex = (interval.startTime - firstTimeStamp) / period;
                interval.logicalEndIndex = ((interval.endTime == null ? interval.startTime : interval.endTime) - firstTimeStamp) / period;
            }
        }

        public void setTimeStamps(long firstTimeStamp, long period) {
            for (Interval interval : this) {
                interval.startTime = interval.logicalStartIndex * period + firstTimeStamp;
                interval.endTime = interval.logicalEndIndex * period + firstTimeStamp;
            }
        }

        @Override
        public boolean equals(Object other_obj) {
            if (!(other_obj instanceof IntervalSequence)) {
                return false;
            }
            IntervalSequence other = (IntervalSequence)other_obj;
            return super.equals(other);
        }
    }

    public static class Interval
    implements JsonAble {
        public long startTime = 0L;
        public Long endTime = null;
        public long logicalStartIndex = -1L;
        public long logicalEndIndex = -1L;
        public float value = 0.0f;
        public Integer index = -1;
        public Float[] anomalyScore;
        public Float[] thresholdScore;
        public Float actualVal;
        public Float expectedVal;
        public Long utime;
        public Boolean isAnomaly;

        public Interval() {
            this.actualVal = null;
            this.anomalyScore = null;
            this.thresholdScore = null;
            this.expectedVal = null;
            this.utime = null;
            this.isAnomaly = null;
            this.index = null;
        }

        public Interval(long utime, int index, Float[] score, Float[] thresholds, float actual, float expected) {
            this.utime = utime;
            this.anomalyScore = score;
            this.thresholdScore = thresholds;
            this.actualVal = Float.valueOf(actual);
            this.expectedVal = Float.valueOf(expected);
            this.isAnomaly = null;
            this.startTime = utime;
            this.index = index;
        }

        public Interval(long utime, int index, Float[] score, Float[] thresholds, float actual, float expected, boolean isAnomaly) {
            this.utime = utime;
            this.anomalyScore = score;
            this.thresholdScore = thresholds;
            this.actualVal = Float.valueOf(actual);
            this.expectedVal = Float.valueOf(expected);
            this.isAnomaly = isAnomaly;
            this.startTime = utime;
            this.index = index;
        }

        public Interval(long logicalStartIndex, long logicalEndIndex, float value) {
            this.logicalStartIndex = logicalStartIndex;
            this.logicalEndIndex = logicalEndIndex;
            this.value = value;
            this.actualVal = null;
            this.anomalyScore = null;
            this.thresholdScore = null;
            this.expectedVal = null;
            this.utime = null;
            this.isAnomaly = null;
            this.index = null;
        }

        @Override
        public void toJson(JSONStringer json_out) throws Exception {
            JsonEncoder.toJson(this, json_out);
        }

        @Override
        public void fromJson(JSONObject json_obj) throws Exception {
            JsonEncoder.fromJson((Object)this, json_obj);
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            Date startDate = new Date(this.startTime * 1000L);
            Date endDate = this.endTime == null ? null : new Date(this.endTime * 1000L);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_hh:mm");
            String startStr = dateFormat.format(startDate);
            String endStr = endDate == null ? "" : " to " + dateFormat.format(endDate);
            str.append(startStr + endStr);
            return str.toString();
        }

        public boolean equals(Object other_obj) {
            if (!(other_obj instanceof Interval)) {
                return false;
            }
            Interval other = (Interval)other_obj;
            if (this.startTime != other.startTime) {
                return false;
            }
            if (!MetricMeta.equals(this.endTime, other.endTime)) {
                return false;
            }
            if (this.logicalStartIndex != other.logicalStartIndex) {
                return false;
            }
            if (this.logicalEndIndex != other.logicalEndIndex) {
                return false;
            }
            return this.value == other.value;
        }
    }
}

