/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.control;

import com.yahoo.egads.control.ModelAdapter;
import com.yahoo.egads.control.ProcessableObject;
import com.yahoo.egads.data.TimeSeries;
import java.util.List;
import java.util.Properties;

public class TransformInputProcessable
implements ProcessableObject {
    private ModelAdapter ma;
    private Properties config;
    private List<TimeSeries.DataSequence> forecastDatapointList;

    public List<TimeSeries.DataSequence> getForecastDatapointList() {
        return this.forecastDatapointList;
    }

    TransformInputProcessable(ModelAdapter ma, Properties config) {
        this.ma = ma;
        this.config = config;
    }

    @Override
    public void process() throws Exception {
        this.ma.reset();
        this.ma.train();
        this.forecastDatapointList = this.ma.forecast(this.ma.metric.startTime(), this.ma.metric.lastTime());
        String[] modelNames = this.ma.getModelNames();
        int i = 0;
        for (TimeSeries.DataSequence ds : this.forecastDatapointList) {
            int j = 0;
            for (TimeSeries.Entry e : ds) {
                System.out.println(e.time + "," + this.ma.metric.meta.name + "," + this.ma.metric.meta.fileName + "," + modelNames[i] + "," + e.value + "," + ((TimeSeries.Entry)this.ma.metric.data.get((int)j)).value + ",0");
                ++j;
            }
            ++i;
        }
    }

    @Override
    public Object result() throws Exception {
        return this.getForecastDatapointList();
    }
}

