/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.control;

import com.yahoo.egads.data.Anomaly;
import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.models.adm.AnomalyDetectionModel;
import java.util.ArrayList;

public class AnomalyDetector {
    protected TimeSeries metric = null;
    protected ArrayList<AnomalyDetectionModel> models = new ArrayList();
    protected ArrayList<Boolean> isTuned = new ArrayList();
    protected long firstTimeStamp = 0L;
    protected long period;

    public AnomalyDetector(TimeSeries theMetric, long period, long firstTimeStamp) throws Exception {
        if (theMetric == null) {
            throw new Exception("The input metric is null.");
        }
        this.metric = theMetric;
        this.period = period;
        this.firstTimeStamp = firstTimeStamp;
    }

    public AnomalyDetector(TimeSeries theMetric, long period) throws Exception {
        if (theMetric == null) {
            throw new Exception("The input metric is null.");
        }
        this.metric = theMetric;
        this.period = period;
        if (this.metric.data.size() > 0) {
            this.firstTimeStamp = this.metric.time(0);
        }
    }

    public AnomalyDetector(String theMetric, long period) throws Exception {
        this.period = period;
        int modelNum = this.models.size();
        for (int i = 0; i < modelNum; ++i) {
            this.isTuned.set(i, true);
        }
    }

    public void setMetric(TimeSeries theMetric, long period) {
        this.metric = theMetric;
        this.period = period;
        if (this.metric.data.size() > 0) {
            this.firstTimeStamp = this.metric.time(0);
        }
        this.reset();
    }

    public void setMetric(TimeSeries theMetric, long period, long firstTimeStamp) {
        this.metric = theMetric;
        this.period = period;
        this.firstTimeStamp = firstTimeStamp;
        this.reset();
    }

    public void setMetric(String theMetric, long period) {
        this.period = period;
        this.firstTimeStamp = 0L;
        this.models.clear();
        this.isTuned.clear();
        int modelNum = this.models.size();
        for (int i = 0; i < modelNum; ++i) {
            this.isTuned.set(i, true);
        }
    }

    public void addModel(AnomalyDetectionModel model) {
        model.reset();
        this.models.add(model);
        this.isTuned.add(false);
    }

    public void reset() {
        int i = 0;
        for (AnomalyDetectionModel model : this.models) {
            model.reset();
            this.isTuned.set(i, false);
            ++i;
        }
    }

    public void tune(TimeSeries.DataSequence expectedValues, Anomaly.IntervalSequence anomalySequence) throws Exception {
        int i = 0;
        this.metric.data.setLogicalIndices(this.firstTimeStamp, this.period);
        for (AnomalyDetectionModel model : this.models) {
            if (!this.isTuned.get(i).booleanValue()) {
                model.tune(this.metric.data, expectedValues, anomalySequence);
                this.isTuned.set(i, true);
            }
            ++i;
        }
    }

    public ArrayList<Anomaly> detect(TimeSeries observedSeries, TimeSeries.DataSequence expectedSeries) throws Exception {
        for (Boolean b : this.isTuned) {
            if (b.booleanValue()) continue;
            throw new Exception("All the models need to be tuned before detection.");
        }
        ArrayList<Anomaly> result = new ArrayList<Anomaly>();
        observedSeries.data.setLogicalIndices(this.firstTimeStamp, this.period);
        expectedSeries.setLogicalIndices(this.firstTimeStamp, this.period);
        for (AnomalyDetectionModel model : this.models) {
            Anomaly anomaly = new Anomaly(observedSeries.meta.name, observedSeries.meta);
            anomaly.modelName = model.getModelName();
            anomaly.type = model.getType();
            anomaly.intervals = model.detect(observedSeries.data, expectedSeries);
            anomaly.intervals.setLogicalIndices(this.firstTimeStamp, this.period);
            anomaly.intervals.setTimeStamps(this.firstTimeStamp, this.period);
            result.add(anomaly);
        }
        return result;
    }
}

