/*
 * Decompiled with CFR 0.152.
 */
package com.github.servicenow.ds.stats.stl;

import com.github.servicenow.ds.stats.stl.SeasonalTrendLoess;

public class StlFitStats {
    private final int fSampleSize;
    private final double fDataMean;
    private final double fDataVariance;
    private final double fTrendMean;
    private final double fTrendRange;
    private final double fSeasonalMean;
    private final double fSeasonalVariance;
    private final double fResidualMean;
    private final double fResidualVariance;
    private final double fResidualLogLikelihood;
    private final double fDeSeasonalMean;
    private final double fDeSeasonalVariance;
    private final double fDeTrendMean;
    private final double fDeTrendVariance;
    private final double fSeasonalRange;
    private final double fResidualVarMLE;

    public StlFitStats(SeasonalTrendLoess.Decomposition stl) {
        int length = stl.getData().length;
        double[] data = stl.getData();
        double[] trend = stl.getTrend();
        double[] seasonal = stl.getSeasonal();
        double[] residuals = stl.getResidual();
        double dataSum = 0.0;
        double dataSqSum = 0.0;
        double trendSum = 0.0;
        double trendMax = -1.0E100;
        double trendMin = 1.0E100;
        double seasonalSum = 0.0;
        double seasonalSqSum = 0.0;
        double seasonalMax = -1.0E100;
        double seasonalMin = 1.0E100;
        double residualSum = 0.0;
        double residualSqSum = 0.0;
        double deSeasonalSum = 0.0;
        double deSeasonalSqSum = 0.0;
        double deTrendSum = 0.0;
        double deTrendSqSum = 0.0;
        for (int i = 0; i < length; ++i) {
            double d = data[i];
            double t = trend[i];
            double s = seasonal[i];
            double r = residuals[i];
            double f = d - s;
            double dt = d - t;
            dataSum += d;
            dataSqSum += d * d;
            trendSum += t;
            if (t > trendMax) {
                trendMax = t;
            }
            if (t < trendMin) {
                trendMin = t;
            }
            seasonalSum += s;
            seasonalSqSum += s * s;
            if (s > seasonalMax) {
                seasonalMax = s;
            }
            if (s < seasonalMin) {
                seasonalMin = s;
            }
            residualSum += r;
            residualSqSum += r * r;
            deSeasonalSum += f;
            deSeasonalSqSum += f * f;
            deTrendSum += dt;
            deTrendSqSum += dt * dt;
        }
        double denom = 1.0 / (double)length;
        this.fDataMean = dataSum * denom;
        this.fTrendMean = trendSum * denom;
        this.fSeasonalMean = seasonalSum * denom;
        this.fResidualMean = residualSum * denom;
        this.fDeSeasonalMean = deSeasonalSum * denom;
        this.fDeTrendMean = deTrendSum * denom;
        double corrBC = (double)length / ((double)length - 1.0);
        double denomBC = 1.0 / ((double)length - 1.0);
        this.fDataVariance = dataSqSum * denomBC - this.fDataMean * this.fDataMean * corrBC;
        this.fTrendRange = trendMax - trendMin;
        this.fSeasonalVariance = seasonalSqSum * denomBC - this.fSeasonalMean * this.fSeasonalMean * corrBC;
        this.fSeasonalRange = seasonalMax - seasonalMin;
        this.fResidualVariance = residualSqSum * denomBC - this.fResidualMean * this.fResidualMean * corrBC;
        this.fDeSeasonalVariance = deSeasonalSqSum * denomBC - this.fDeSeasonalMean * this.fDeSeasonalMean * corrBC;
        this.fDeTrendVariance = deTrendSqSum * denomBC - this.fDeTrendMean * this.fDeTrendMean * corrBC;
        this.fResidualVarMLE = denom * residualSqSum;
        this.fResidualLogLikelihood = -0.5 * (double)length * (1.0 + Math.log(Math.PI * 2 * this.fResidualVarMLE));
        this.fSampleSize = length;
    }

    public double getTrendMean() {
        return this.fTrendMean;
    }

    public double getTrendRange() {
        return this.fTrendRange;
    }

    public double getDataMean() {
        return this.fDataMean;
    }

    public double getDataVariance() {
        return this.fDataVariance;
    }

    public double getDataStdDev() {
        return Math.sqrt(this.fDataVariance);
    }

    public double getSeasonalMean() {
        return this.fSeasonalMean;
    }

    public double getSeasonalVariance() {
        return this.fSeasonalVariance;
    }

    public double getSeasonalStdDev() {
        return Math.sqrt(this.fSeasonalVariance);
    }

    public double getSeasonalRange() {
        return this.fSeasonalRange;
    }

    public double getResidualMean() {
        return this.fResidualMean;
    }

    public double getResidualVariance() {
        return this.fResidualVariance;
    }

    public double getResidualStdDev() {
        return Math.sqrt(this.fResidualVariance);
    }

    public double getDeSeasonalMean() {
        return this.fDeSeasonalMean;
    }

    public double getDeSeasonalVariance() {
        return this.fDeSeasonalVariance;
    }

    public double getDeTrendMean() {
        return this.fDeTrendMean;
    }

    public double getDeTrendVariance() {
        return this.fDeTrendVariance;
    }

    public double getEstimatedVarianceOfResidualSampleVariance() {
        double v = this.getResidualVariance();
        return 2.0 * v * v / (double)(this.fSampleSize - 1);
    }

    public double getTrendinessZScore() {
        double resVarVar = this.getEstimatedVarianceOfResidualSampleVariance();
        return (this.fDeSeasonalVariance - this.fResidualVariance) / Math.sqrt(Math.max(1.0E-12, resVarVar));
    }

    public double getSeasonalZScore() {
        double resVarVar = this.getEstimatedVarianceOfResidualSampleVariance();
        return (this.fDeTrendVariance - this.fResidualVariance) / Math.sqrt(Math.max(1.0E-12, resVarVar));
    }

    public double getResidualLogLikelihood() {
        return this.fResidualLogLikelihood;
    }

    public double getResidualLogLikelihood(double sigma) {
        double var = sigma * sigma;
        return -0.5 * (double)this.fSampleSize * (this.fResidualVarMLE / var + Math.log(Math.PI * 2 * var));
    }

    public String toString() {
        return String.format("Data Mean            = %10f\nData Variance        = %10f\nTrend Mean           = %10f\nTrend Range          = %10f\nSeasonal Mean        = %10f\nSeasonal Variance    = %10f\nSeasonal Range       = %10f\nDe-Seasonal Mean     = %10f\nDe-Seasonal Variance = %10f\nDe-Trend Mean        = %10f\nDe-Trend Variance    = %10f\nResidual Mean        = %10f\nResidual Variance    = %10f\nVar(ResSampleVar)    = %10f\nTrend Test ZScore    = %10f\nSeasonal Test ZScore = %10f\nSeasonalVar/ResidVar = %10f", this.getDataMean(), this.getDataVariance(), this.getTrendMean(), this.getTrendRange(), this.getSeasonalMean(), this.getSeasonalVariance(), this.getSeasonalRange(), this.getDeSeasonalMean(), this.getDeSeasonalVariance(), this.getDeTrendMean(), this.getDeTrendVariance(), this.getResidualMean(), this.getResidualVariance(), this.getEstimatedVarianceOfResidualSampleVariance(), this.getTrendinessZScore(), this.getSeasonalZScore(), this.getSeasonalVariance() / this.getResidualVariance());
    }
}

