/*
 * Decompiled with CFR 0.152.
 */
package com.github.servicenow.ds.stats.stl;

public class LoessSettings {
    private final int fWidth;
    private final int fDegree;
    private final int fJump;

    public LoessSettings(int width, int degree, int jump) {
        width = Math.max(3, width);
        if (width % 2 == 0) {
            ++width;
        }
        this.fWidth = width;
        this.fJump = Math.max(1, jump);
        this.fDegree = degree = Math.max(0, Math.min(2, degree));
    }

    public LoessSettings(int width, int degree) {
        width = Math.max(3, width);
        if (width % 2 == 0) {
            ++width;
        }
        this.fWidth = width;
        this.fJump = Math.max(1, (int)(0.1 * (double)width + 0.9));
        this.fDegree = degree = Math.max(0, Math.min(2, degree));
    }

    public LoessSettings(int width) {
        width = Math.max(3, width);
        if (width % 2 == 0) {
            ++width;
        }
        this.fWidth = width;
        this.fJump = Math.max(1, (int)(0.1 * (double)width + 0.9));
        this.fDegree = 1;
    }

    public final int getWidth() {
        return this.fWidth;
    }

    public final int getDegree() {
        return this.fDegree;
    }

    public final int getJump() {
        return this.fJump;
    }

    public String toString() {
        return String.format("[width = %d, degree = %d, jump = %d]", this.fWidth, this.fDegree, this.fJump);
    }
}

