/*
 * Decompiled with CFR 0.152.
 */
package medusa.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import medusa.graph.BasicGraph;
import medusa.graph.Node;

public class Stats {
    private static Comparator nodeComparator = new NodeConnectionComparator();

    public static String nodeRanking(BasicGraph g, int k) {
        ArrayList<Node> nodes = new ArrayList<Node>(g.getNodes().values());
        Collections.sort(nodes, nodeComparator);
        StringBuffer sb = new StringBuffer();
        int l = nodes.size();
        for (int i = l - k; i < l; ++i) {
            Node node = (Node)nodes.get(i);
            sb.append(node.getLabel()).append("\t");
            sb.append(node.getAnnotation()).append("\t");
            sb.append(node.getConnections()).append("\n");
        }
        return sb.toString();
    }

    static class NodeConnectionComparator
    implements Comparator {
        NodeConnectionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int c2;
            Node a = (Node)o1;
            Node b = (Node)o2;
            int c1 = a.getConnections();
            if (c1 < (c2 = b.getConnections())) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            return 0;
        }
    }
}

