/*
 * Decompiled with CFR 0.152.
 */
package medusa.spectral;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import medusa.graph.Edge;
import medusa.graph.Graph;
import medusa.spectral.KMeans;
import medusa.spectral.KMeansPoint;
import medusa.spectral.SparseMatrixOps;
import medusa.spectral.SparseSimilarityCollection;
import medusa.spectral.SparseSimilarityLoader;

public class SparseSpectralCluster {
    private SparseSimilarityCollection sc;
    private IndexedValue[] ivs;
    private DoubleMatrix2D Y;
    private DoubleMatrix2D S;
    private double secondEig = 0.0;
    private boolean debug = false;

    public double getSecondEig() {
        return this.secondEig;
    }

    private IndexedValue[] sortDesc(double[] arr) {
        IndexedValue[] ivs = new IndexedValue[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            ivs[i] = new IndexedValue(arr[i], i);
        }
        Arrays.sort(ivs, Collections.reverseOrder());
        return ivs;
    }

    private IndexedValue[] sortAsc(double[] arr) {
        Object[] ivs = new IndexedValue[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            ivs[i] = new IndexedValue(arr[i], i);
        }
        Arrays.sort(ivs);
        return ivs;
    }

    private DoubleMatrix2D reorder(DoubleMatrix2D a, IndexedValue[] ivs, int k) {
        int rows = a.rows();
        double[][] data = new double[rows][k];
        for (int i = 0; i < k; ++i) {
            int index = ivs[i].getIndex();
            for (int j = 0; j < rows; ++j) {
                data[j][i] = a.get(j, index);
            }
        }
        return new SparseDoubleMatrix2D(data);
    }

    private DoubleMatrix2D reorder(DoubleMatrix2D a, IndexedValue[] ivs) {
        int rows = a.rows();
        int cols = a.columns();
        double[][] data = new double[rows][cols];
        for (int i = 0; i < cols; ++i) {
            int index = ivs[i].getIndex();
            for (int j = 0; j < rows; ++j) {
                data[j][i] = a.get(j, index);
            }
        }
        return new SparseDoubleMatrix2D(data);
    }

    private DoubleMatrix2D normalizeToUnitLength(DoubleMatrix2D in) {
        int j;
        int i;
        DoubleMatrix2D a = in.copy();
        double[] denominators = new double[a.rows()];
        for (i = 0; i < a.rows(); ++i) {
            denominators[i] = 0.0;
            for (j = 0; j < a.columns(); ++j) {
                int n = i;
                denominators[n] = denominators[n] + a.get(i, j) * a.get(i, j);
            }
            denominators[i] = Math.sqrt(denominators[i]);
        }
        for (i = 0; i < a.rows(); ++i) {
            for (j = 0; j < a.columns(); ++j) {
                a.set(i, j, a.get(i, j) / denominators[i]);
            }
        }
        return a;
    }

    public void report(double[] s) {
        DecimalFormat df = new DecimalFormat("0.000");
        for (int i = 0; i < s.length; ++i) {
            System.out.print(df.format(s[i]) + " ");
        }
        System.out.println();
    }

    public void report(IndexedValue[] s) {
        DecimalFormat df = new DecimalFormat("0.000");
        for (int i = 0; i < s.length; ++i) {
            System.out.print("[" + s[i].getIndex() + "]" + df.format(s[i].getValue()) + " ");
        }
        System.out.println();
    }

    public int decideK(IndexedValue[] ivs) {
        return 0;
    }

    private int nPositiveEvals(IndexedValue[] ivs) {
        int pos = 0;
        for (int k = 0; k < ivs.length; ++k) {
            if (ivs[k].getValue() < 0.0) {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    private double[] absolute(double[] d) {
        double[] e = new double[d.length];
        for (int i = 0; i < d.length; ++i) {
            e[i] = Math.abs(d[i]);
        }
        return e;
    }

    public boolean prepare(Graph g) throws IOException {
        this.sc = SparseSimilarityLoader.GraphToCollection(g);
        this.S = this.sc.getS();
        if (this.getSize() < 3) {
            return false;
        }
        this.getMarkovTransition(this.S);
        return true;
    }

    public int getSize() {
        if (this.S == null) {
            return 0;
        }
        return this.S.columns();
    }

    private void getMarkovTransition(DoubleMatrix2D S) {
        this.getMarkovTransition(S, this.debug);
    }

    private void getMarkovTransition(DoubleMatrix2D S, boolean debug) {
        DoubleMatrix2D bestEvecs;
        double[] degrees = SparseMatrixOps.rowSum(S);
        DoubleMatrix2D I = SparseMatrixOps.identity(S);
        DoubleMatrix2D D = SparseMatrixOps.timesElement(I, degrees);
        Algebra a = new Algebra();
        DoubleMatrix2D Dsqrt = a.inverse(SparseMatrixOps.sqrtElement(D));
        DoubleMatrix2D L = a.mult(Dsqrt, S);
        L = a.mult(L, Dsqrt);
        EigenvalueDecomposition ed = new EigenvalueDecomposition(L);
        L = null;
        double[] evals = ed.getRealEigenvalues().toArray();
        double[] cevals = ed.getImagEigenvalues().toArray();
        DoubleMatrix2D evecs = ed.getV();
        this.ivs = this.sortDesc(evals);
        this.secondEig = this.ivs[1].getValue();
        this.Y = bestEvecs = this.reorder(evecs, this.ivs);
        if (debug) {
            System.out.println("Similarity matrix");
            System.out.println(S.toString());
            System.out.println("Identity matrix");
            System.out.println(I.toString());
            System.out.println("Degree matrix D");
            System.out.println(D.toString());
            System.out.println("Eigenvalues");
            this.report(evals);
            System.out.println("Eigenvectors");
            System.out.println(evecs.toString());
            System.out.println("Sorted evals");
            this.report(this.ivs);
            System.out.println("Sorted evecs");
            System.out.println(evecs.toString());
            System.out.println("Normalized best evecs");
            System.out.println(this.Y.toString());
        }
    }

    public Vector<KMeansPoint> getVector(int k) {
        Vector<KMeansPoint> v = new Vector<KMeansPoint>();
        DoubleMatrix2D subY = this.Y.viewPart(0, 0, this.Y.rows(), k);
        this.Y = null;
        this.normalizeToUnitLength(subY);
        double[][] data = subY.toArray();
        for (int i = 0; i < data.length; ++i) {
            String label = new Integer(i).toString();
            KMeansPoint dmd = new KMeansPoint(label, data[i]);
            v.add(dmd);
        }
        return v;
    }

    public void cluster(int k) {
        int nClusters = k;
        if (k == 0) {
            nClusters = this.nPositiveEvals(this.ivs);
        }
        Vector<KMeansPoint> dataPoints = this.getVector(nClusters);
        KMeans km = new KMeans(nClusters, dataPoints);
        km.runKMeans();
        this.niceReport(km.getClusters(), this.sc);
    }

    public String niceReport(Vector[] v, SparseSimilarityCollection sc) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < v.length; ++i) {
            Vector tempV = v[i];
            System.out.println("-----------Cluster" + i + "---------");
            for (KMeansPoint dpTemp : tempV) {
                int index = Integer.parseInt(dpTemp.getLabel());
                System.out.println(sc.getName(index));
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        SparseSpectralCluster sc = new SparseSpectralCluster();
        Graph g = new Graph();
        Edge e1 = new Edge("n1", "n2", 0.8f);
        Edge e2 = new Edge("n2", "n3", 0.5f);
        Edge e3 = new Edge("n3", "n4", 0.1f);
        Edge e4 = new Edge("n4", "n1", 0.1f);
        g.addEdge(e3);
        g.addEdge(e1);
        g.addEdge(e2);
        g.addEdge(e4);
        int clusters = 3;
        try {
            sc.setDebug(false);
            sc.prepare(g);
            sc.cluster(clusters);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void HELP() {
        System.out.println("");
        System.out.println("You must give a file name for your conservation scores");
        System.out.println("Usage: java -jar JCluster.jar <file name> <clusters>");
        System.out.println("If clusters are omitted, all positive eigenvalues will ");
        System.out.println("be considered");
        System.out.println("HINT: For memory-intense use, set the heap sizes");
        System.out.println("with -Xmx800m (max size) and -Xms250m (initial size).");
        System.out.println("Change these parameters according to your system.");
        System.out.println("");
        System.out.println("Sean Hooper 2007");
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private class IndexedValue
    implements Comparable {
        double value;
        int index;

        public IndexedValue(double value, int index) {
            this.value = value;
            this.index = index;
        }

        public double getValue() {
            return this.value;
        }

        public double getAbsoluteValue() {
            return Math.abs(this.value);
        }

        public int getIndex() {
            return this.index;
        }

        public int compareTo(Object o2) {
            IndexedValue i2 = (IndexedValue)o2;
            if (this.getValue() < i2.getValue()) {
                return -1;
            }
            if (this.getValue() == i2.getValue()) {
                return 0;
            }
            return 1;
        }

        public String toString() {
            return this.index + ": " + this.value;
        }
    }
}

