/*
 * Decompiled with CFR 0.152.
 */
package medusa.spectral;

public class KMeansPoint {
    private String label;
    private int clusterNumber;
    private double[] coords;

    public int getDimensions() {
        return this.coords.length;
    }

    public KMeansPoint(String label, double _x, double _y) {
        this.label = label;
        this.coords = new double[2];
        this.coords[0] = _x;
        this.coords[1] = _y;
        this.clusterNumber = 0;
    }

    public KMeansPoint(String label, double[] coords) {
        this.label = label;
        this.coords = coords;
        this.clusterNumber = 0;
    }

    public void assignToCluster(int _clusterNumber) {
        this.clusterNumber = _clusterNumber;
    }

    public int getClusterNumber() {
        return this.clusterNumber;
    }

    public double[] getCoords() {
        return this.coords;
    }

    public static double distance(KMeansPoint dp1, KMeansPoint dp2) {
        double[] coords1 = dp1.getCoords();
        double[] coords2 = dp2.getCoords();
        double result = 0.0;
        for (int i = 0; i < coords1.length; ++i) {
            double temp = coords1[i] - coords2[i];
            result += temp * temp;
        }
        result = Math.sqrt(result);
        return result;
    }

    public String toString() {
        return this.getLabel() + "\t" + Integer.toString(this.clusterNumber);
    }

    public String toDataString() {
        StringBuffer sb = new StringBuffer("(");
        for (int i = 0; i < this.coords.length; ++i) {
            sb.append(this.coords[i]);
            sb.append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static void main(String[] args) {
        KMeansPoint dp1 = new KMeansPoint("weng", -0.3, -0.4);
        KMeansPoint dp2 = new KMeansPoint("foo", 0.2, 0.4);
        System.out.println(KMeansPoint.distance(dp1, dp2));
        System.out.println(dp1.toDataString());
        System.out.println(dp2.toDataString());
        dp1.assignToCluster(7);
        System.out.println(dp1.getClusterNumber());
        dp1.assignToCluster(17);
        System.out.println(dp1.getClusterNumber());
        System.out.println(dp2.getClusterNumber());
        System.out.println(dp1);
    }

    public String getLabel() {
        return this.label;
    }
}

