/*
 * Decompiled with CFR 0.152.
 */
package medusa.graph;

import java.awt.Color;
import java.io.Serializable;

public class Node
implements Serializable {
    private double x;
    private double y;
    private Color color = Color.red;
    private Color color2 = null;
    private Color color3 = null;
    private Color clustering_color = null;
    private double dx;
    private double dy;
    private int connections;
    private String lbl;
    String annotation = "no annotation";
    String node_url = "";
    int node_cluster = -1;
    private boolean fixed = false;
    private int shape = 1;
    private int dataSpace1;

    public String toString() {
        return this.lbl + " " + this.x + " " + this.y + " " + this.color;
    }

    public String report() {
        String result = this.lbl + "\t" + this.x + "\t" + this.y + "\t" + this.getColorEntry();
        result = result + "\t" + this.getColor2Entry();
        result = result + "\t" + this.getColor3Entry();
        result = result + "\t" + this.getColor4Entry();
        result = result + "\ts " + this.shape + "\ta \"" + this.getAnnotation() + "\"";
        result = result + "\ts " + this.shape + "\turl \"" + this.getURL() + "\"";
        result = result + "\ts " + this.shape + "\tcluster \"" + this.getCLuster() + "\"";
        return result;
    }

    public Node() {
        this.lbl = "unlabeled";
        this.x = Math.random();
        this.y = Math.random();
        this.connections = 0;
    }

    public Node(String name) {
        this.lbl = name;
        this.x = Math.random();
        this.y = Math.random();
        this.connections = 0;
    }

    public Node(String name, double x, double y) {
        this.lbl = name;
        this.x = x;
        this.y = y;
        this.connections = 0;
    }

    public Node(String name, double x, double y, int shape) {
        this.lbl = name;
        this.x = x;
        this.y = y;
        this.shape = shape;
        this.connections = 0;
    }

    public Node(String name, Double x, Double y, Integer shape, Color color) {
        this.lbl = name;
        this.x = x;
        this.y = y;
        this.shape = shape;
        this.color = color;
    }

    public double getX() {
        return this.x;
    }

    public void rescale(int scale) {
        this.x *= (double)scale;
        this.y *= (double)scale;
    }

    public void rescale(int xScale, int yScale) {
        this.x *= (double)xScale;
        this.y *= (double)yScale;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getDX() {
        return this.dx;
    }

    public void setDX(double dx) {
        this.dx = dx;
    }

    public double getDY() {
        return this.dy;
    }

    public void setDY(double dy) {
        this.dy = dy;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColor(int i) {
        if (i == 2) {
            return this.color2;
        }
        if (i == 3) {
            return this.color3;
        }
        if (i == 4) {
            return this.clustering_color;
        }
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(int i, Color color) {
        switch (i) {
            case 1: {
                this.color = color;
                break;
            }
            case 2: {
                this.color2 = color;
                break;
            }
            case 3: {
                this.color3 = color;
                break;
            }
            case 4: {
                this.clustering_color = color;
            }
        }
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color) {
        this.color2 = color;
    }

    public Color getClusteringColor() {
        return this.clustering_color;
    }

    public void setClusteringColor(Color color) {
        this.clustering_color = color;
    }

    public Color getColor3() {
        return this.color3;
    }

    public void setColor3(Color color) {
        this.color3 = color;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int shape) {
        this.shape = shape;
    }

    protected boolean removeConnection() {
        --this.connections;
        return this.connections > 0;
    }

    protected void addConnection() {
        ++this.connections;
    }

    public void manipulateColorElement(int a, int b, boolean doSwitch) {
        int[] elements = new int[]{this.color.getRed(), this.color.getGreen(), this.color.getBlue()};
        if (doSwitch) {
            int temp = elements[a];
            elements[a] = elements[b];
            elements[b] = temp;
        } else {
            elements[a] = elements[b];
        }
        this.color = new Color(elements[0], elements[1], elements[2]);
    }

    public void manipulateChannel(int channel, int value) {
        int[] elements = new int[]{this.color.getRed(), this.color.getGreen(), this.color.getBlue()};
        elements[channel] = value;
        this.color = new Color(elements[0], elements[1], elements[2]);
    }

    public boolean equals(Object o) {
        if (o.getClass() == this.getClass()) {
            Node n = (Node)o;
            return this.lbl.compareTo(n.lbl) == 0;
        }
        return false;
    }

    public String getLabel() {
        return this.lbl;
    }

    public void setLabel(String lbl) {
        this.lbl = lbl;
    }

    public void setXY(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public int getConnections() {
        return this.connections;
    }

    public int hashCode() {
        int code = this.lbl.hashCode();
        return code;
    }

    public void copyPosition(Node n) {
        this.x = n.x;
        this.y = n.y;
    }

    public String getColorEntry() {
        String code = "c " + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue();
        return code;
    }

    public String getAppletColorEntry() {
        String code = this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue();
        return code;
    }

    public String getColor2Entry() {
        if (this.color2 == null) {
            return "";
        }
        String code = "c2 " + this.color2.getRed() + "," + this.color2.getGreen() + "," + this.color2.getBlue();
        return code;
    }

    public String getColor3Entry() {
        if (this.color3 == null) {
            return "";
        }
        String code = "c3 " + this.color3.getRed() + "," + this.color3.getGreen() + "," + this.color3.getBlue();
        return code;
    }

    public String getColor4Entry() {
        if (this.clustering_color == null) {
            return "";
        }
        String code = "c4 " + this.clustering_color.getRed() + "," + this.clustering_color.getGreen() + "," + this.clustering_color.getBlue();
        return code;
    }

    public void setDataSpace1(int space) {
        this.dataSpace1 = space;
    }

    public int getDataSpace1() {
        return this.dataSpace1;
    }

    public void setAnnotation(String ann) {
        this.annotation = ann;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setURL(String ann) {
        if (ann.startsWith("http://")) {
            this.node_url = ann;
        }
    }

    public String getURL() {
        return this.node_url;
    }

    public void setCluster(String ann) {
        this.node_cluster = Integer.parseInt(ann);
    }

    public int getCLuster() {
        return this.node_cluster;
    }
}

