/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.ClusteringAlgorithms;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import medusa.georgios.ClusteringAlgorithms.MatrixClustering;

public class Kmeans {
    public static final float MAXVAL = Float.MAX_VALUE;
    public static final float R = 0.999f;
    private int distance_mode = 2;
    StringBuffer result;
    public Hashtable<String, Integer> GiveNodeName_Get_Cluster = new Hashtable();
    float Threshold = 1.0E-4f;
    public int k = 2;
    int rows;
    int columns;
    float[][] distance;
    ArrayList<String> labels;

    public Kmeans(int k, float[][] distance, int rows, int columns) {
        this.k = k;
        this.distance = distance;
        this.rows = rows;
        this.columns = columns;
    }

    public Kmeans(int k, float[][] distance, ArrayList<String> labels_tmp) {
        this.k = k;
        this.labels = labels_tmp;
        this.distance = distance;
        this.rows = distance.length;
        this.columns = distance.length;
        this.distance_mode = 1;
    }

    public void setDistanceMode(int mode) {
        this.distance_mode = mode;
    }

    public String perform_and_get_results() {
        int i;
        this.result = new StringBuffer("----------------- Cluster: 1 -----------------\n");
        this.GiveNodeName_Get_Cluster.clear();
        int[] cluster_result = this.performKmeans();
        int[] id = new int[cluster_result.length];
        for (i = 0; i < cluster_result.length; ++i) {
            id[i] = i;
        }
        for (i = 0; i < cluster_result.length - 1; ++i) {
            for (int j = i + 1; j < cluster_result.length; ++j) {
                if (cluster_result[i] <= cluster_result[j]) continue;
                int temp = cluster_result[i];
                cluster_result[i] = cluster_result[j];
                cluster_result[j] = temp;
                int temp2 = id[i];
                id[i] = id[j];
                id[j] = temp2;
            }
        }
        for (i = 0; i < cluster_result.length; ++i) {
            if (i > 0 && cluster_result[i] != cluster_result[i - 1]) {
                this.result.append("\n----------------- Cluster: " + cluster_result[i] + " -----------------\n");
            }
            this.result.append(this.labels.get(id[i]) + "\n");
        }
        for (i = 0; i < cluster_result.length; ++i) {
            this.GiveNodeName_Get_Cluster.put(this.labels.get(id[i]), cluster_result[i] - 1);
        }
        String str = this.result.toString();
        return str;
    }

    public String getReport() {
        return this.result.toString();
    }

    public void Save_To_File(String filename, String information) {
        try {
            BufferedWriter outp = new BufferedWriter(new FileWriter(filename));
            outp.append(information);
            outp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int[] performKmeans() {
        int i;
        int n = this.rows;
        int m = this.columns;
        int[] assignment = new int[n];
        float[] temp1 = new float[this.columns];
        float[] temp2 = new float[this.columns];
        MatrixClustering centers = new MatrixClustering(this.k, this.columns, 0.0f);
        for (int i2 = 0; i2 < this.k; ++i2) {
            for (int j = 0; j < this.columns; ++j) {
                centers.set(i2, j, this.distance[i2][j]);
            }
        }
        MatrixClustering I = new MatrixClustering(this.k, this.k, 0.0f);
        for (int i3 = 0; i3 < this.k; ++i3) {
            I.set(i3, i3, 1.0f);
        }
        int niters = 500;
        MatrixClustering tempDistance = new MatrixClustering(this.rows, this.k, 0.0f);
        float[] ss_ = new float[this.columns];
        float[] min_ = new float[this.rows];
        int[] index_ = new int[this.rows];
        MatrixClustering post = new MatrixClustering(this.rows, this.k, 0.0f);
        int[] num_of_points = new int[this.k];
        for (int count_ = 0; count_ < niters; ++count_) {
            int ii;
            int jj;
            int ii2;
            System.out.println("iteration " + count_);
            MatrixClustering old_centers = centers.copy();
            for (ii2 = 0; ii2 < this.rows; ++ii2) {
                for (jj = 0; jj < this.k; ++jj) {
                    for (int kk = 0; kk < this.columns; ++kk) {
                        temp1[kk] = this.distance[ii2][kk];
                        temp2[kk] = centers.get(jj, kk);
                    }
                    tempDistance.set(ii2, jj, this.eDistance(temp1, temp2));
                }
            }
            for (ii2 = 0; ii2 < this.rows; ++ii2) {
                min_[ii2] = tempDistance.get(ii2, 0);
                index_[ii2] = 0;
                for (jj = 1; jj < this.k; ++jj) {
                    float temp_ = tempDistance.get(ii2, jj);
                    if (!(temp_ < min_[ii2])) continue;
                    min_[ii2] = temp_;
                    index_[ii2] = jj;
                }
            }
            for (i = 0; i < this.rows; ++i) {
                for (ii2 = 0; ii2 < this.k; ++ii2) {
                    post.set(i, ii2, I.get(index_[i], ii2));
                }
            }
            for (i = 0; i < this.k; ++i) {
                int sum_ = 0;
                for (ii = 0; ii < this.rows; ++ii) {
                    sum_ = (int)((float)sum_ + post.get(ii, i));
                }
                num_of_points[i] = sum_;
            }
            for (i = 0; i < this.k; ++i) {
                if (num_of_points[i] <= 0) continue;
                for (int vv = 0; vv < this.columns; ++vv) {
                    ss_[vv] = 0.0f;
                }
                for (int kk = 0; kk < this.rows; ++kk) {
                    if (post.get(kk, i) != 1.0f) continue;
                    for (int mm = 0; mm < this.columns; ++mm) {
                        int n2 = mm;
                        ss_[n2] = ss_[n2] + this.distance[kk][mm];
                    }
                }
                for (int mm = 0; mm < this.columns; ++mm) {
                    centers.set(i, mm, ss_[mm] / (float)num_of_points[i]);
                }
            }
            float maxDistance = 0.0f;
            for (ii = 0; ii < this.k; ++ii) {
                for (int kk = 0; kk < this.columns; ++kk) {
                    temp1[kk] = old_centers.get(ii, kk);
                    temp2[kk] = centers.get(ii, kk);
                }
                float temp = this.eDistance(temp1, temp2);
                if (!(maxDistance < temp)) continue;
                maxDistance = temp;
            }
            if (!(maxDistance < this.Threshold)) continue;
            count_ = niters + 1;
        }
        int[] cluster_result = new int[this.rows];
        for (i = 0; i < this.rows; ++i) {
            for (int ii = 0; ii < this.k; ++ii) {
                if ((double)post.get(i, ii) != 1.0) continue;
                cluster_result[i] = ii + 1;
            }
        }
        return cluster_result;
    }

    protected float eDistance(float[] vector1, float[] vector2) {
        float d = 0.0f;
        if (this.distance_mode == 1) {
            for (int i = 0; i < this.columns; ++i) {
                d += 0.5f * (vector1[i] - vector2[i]) * (vector1[i] - vector2[i]);
            }
        }
        if (this.distance_mode == 2) {
            float acc1 = 0.0f;
            float acc2 = 0.0f;
            float acc0 = 0.0f;
            for (int i = 0; i < this.columns; ++i) {
                acc0 += vector1[i] * vector2[i];
                acc1 += vector1[i] * vector1[i];
                acc2 += vector2[i] * vector2[i];
            }
            d = acc0 / (float)Math.sqrt(acc1 * acc2);
            d = 1.0f / (d + 1.0f);
        }
        return d;
    }
}

