/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.ClusteringAlgorithms;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import medusa.georgios.ClusteringAlgorithms.List2Graph;
import medusa.georgios.ClusteringAlgorithms.NJ;
import medusa.georgios.ClusteringAlgorithms.UPGMA;

public class Clustering_NJ_UPGMA {
    NJ njclu;
    UPGMA upgmaclu;
    boolean NJ_selected = false;
    boolean UPGMA_selected = false;
    public static ArrayList<String> labels;
    float[][] Distance_Matrix;

    public String get_NewickFormat_UPGMA() {
        String str = "";
        if (this.UPGMA_selected && this.upgmaclu != null) {
            labels = List2Graph.labels;
            str = this.upgmaclu.NewickFormat(this.upgmaclu.getRoot());
            int end = this.upgmaclu.NHX.length() - 1;
            this.upgmaclu.NHX.delete(0, end);
        }
        return str;
    }

    public String get_NewickFormat_UPGMA(String layer) {
        String str = "";
        if (this.UPGMA_selected && this.upgmaclu != null) {
            labels = List2Graph.labels;
            str = this.upgmaclu.NewickFormat(this.upgmaclu.getRoot());
            int end = this.upgmaclu.NHX.length() - 1;
            this.upgmaclu.NHX.delete(0, end);
        }
        return str;
    }

    public String get_NewickFormat_NeighborJoining(String layer) {
        String str = "";
        if (this.NJ_selected && this.njclu != null) {
            labels = List2Graph.labels;
            str = this.njclu.NewickFormat(this.njclu.getRoot());
            int end = this.njclu.NHX.length() - 1;
            this.njclu.NHX.delete(0, end);
        }
        return str;
    }

    public String get_NewickFormat_NeighborJoining() {
        String str = "";
        if (this.NJ_selected && this.njclu != null) {
            labels = List2Graph.labels;
            str = this.njclu.NewickFormat(this.njclu.getRoot());
            int end = this.njclu.NHX.length() - 1;
            this.njclu.NHX.delete(0, end);
        }
        return str;
    }

    public void Save_To_File(String filename, String information) {
        try {
            BufferedWriter outp = new BufferedWriter(new FileWriter(filename));
            outp.append(information);
            outp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Clustering_NJ_UPGMA(float[][] distance_Matrix, ArrayList<String> Leaf_Labels, int choose_clustering) {
        this.Distance_Matrix = distance_Matrix;
        labels = new ArrayList();
        if (choose_clustering == 1) {
            this.NJ_selected = false;
            this.UPGMA_selected = true;
            this.upgmaclu = new UPGMA(this.Distance_Matrix);
        }
        if (choose_clustering == 2) {
            this.NJ_selected = true;
            this.UPGMA_selected = false;
            this.njclu = new NJ(this.Distance_Matrix);
        }
        for (int i = 0; i < Leaf_Labels.size(); ++i) {
            labels.add(Leaf_Labels.get(i));
        }
    }

    void read_file_and_create_matrix(String filename) {
        List2Graph g = new List2Graph(filename);
        this.Distance_Matrix = List2Graph.A;
    }

    public void read_file_and_create_matrix2(String filename) {
        String Val;
        String Y;
        String X;
        StringTokenizer st;
        String thisLine;
        BufferedReader myInput;
        float maximum = -22222.0f;
        float infinite = 9999999.0f;
        StringBuffer x_p = new StringBuffer();
        StringBuffer y_p = new StringBuffer();
        StringBuffer val = new StringBuffer();
        int so_far = 1;
        Hashtable<String, Integer> labels_index = new Hashtable<String, Integer>();
        int counter = 0;
        System.out.println("Loading File " + filename);
        try {
            FileInputStream fin = new FileInputStream(filename);
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                float value;
                st = new StringTokenizer(thisLine, "\t");
                x_p.append(st.nextToken());
                y_p.append(st.nextToken());
                val.append(st.nextToken());
                X = x_p.toString();
                Y = y_p.toString();
                Val = val.toString();
                if (!labels.contains(X)) {
                    labels.add(X);
                    labels_index.put(X, counter);
                    ++counter;
                }
                if (!labels.contains(Y)) {
                    labels.add(Y);
                    labels_index.put(Y, counter);
                    ++counter;
                }
                if ((value = Float.valueOf(val.toString()).floatValue()) >= maximum) {
                    maximum = value;
                }
                if (so_far % 100 == 0) {
                    System.out.println(so_far);
                    ++so_far;
                }
                x_p.delete(0, x_p.length());
                y_p.delete(0, y_p.length());
                val.delete(0, val.length());
            }
            fin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        infinite = maximum + 1.0f;
        this.Distance_Matrix = new float[labels.size()][labels.size()];
        for (int i = 0; i < this.Distance_Matrix.length; ++i) {
            for (int j = 0; j < this.Distance_Matrix.length; ++j) {
                this.Distance_Matrix[i][j] = infinite;
                if (i != j) continue;
                this.Distance_Matrix[i][j] = 0.0f;
            }
        }
        so_far = 1;
        System.out.println("Filling Matrix with values");
        try {
            FileInputStream fin = new FileInputStream(filename);
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                st = new StringTokenizer(thisLine, "\t");
                x_p.append(st.nextToken());
                y_p.append(st.nextToken());
                val.append(st.nextToken());
                X = x_p.toString();
                Y = y_p.toString();
                Val = val.toString();
                try {
                    float weight;
                    int x = (Integer)labels_index.get(X);
                    int y = (Integer)labels_index.get(Y);
                    this.Distance_Matrix[x][y] = weight = Float.valueOf(Val).floatValue();
                    this.Distance_Matrix[y][x] = weight;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                x_p.delete(0, x_p.length());
                y_p.delete(0, y_p.length());
                val.delete(0, val.length());
            }
            fin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        labels_index.clear();
    }

    public Clustering_NJ_UPGMA(String filename, int choose_clustering) {
        System.out.println("Start Clustering");
        labels = new ArrayList();
        if (choose_clustering == 1) {
            this.read_file_and_create_matrix(filename);
            this.NJ_selected = false;
            this.UPGMA_selected = true;
            System.out.println("UPGMA clustering");
            this.upgmaclu = new UPGMA(this.Distance_Matrix);
        }
        if (choose_clustering == 2) {
            this.read_file_and_create_matrix(filename);
            this.NJ_selected = true;
            this.UPGMA_selected = false;
            System.out.println("Neighbor Joining clustering");
            this.njclu = new NJ(this.Distance_Matrix);
        }
        System.out.println("Finished Clustering");
    }

    public Clustering_NJ_UPGMA(ArrayList<String> list, int choose_clustering) {
        List2Graph g;
        System.out.println("Start Clustering");
        if (choose_clustering == 1) {
            g = new List2Graph(list);
            this.Distance_Matrix = List2Graph.A;
            labels = List2Graph.labels;
            this.NJ_selected = false;
            this.UPGMA_selected = true;
            System.out.println("UPGMA clustering");
            this.upgmaclu = new UPGMA(this.Distance_Matrix);
        }
        if (choose_clustering == 2) {
            g = new List2Graph(list);
            this.Distance_Matrix = List2Graph.A;
            labels = List2Graph.labels;
            this.NJ_selected = true;
            this.UPGMA_selected = false;
            System.out.println("Neighbor Joining clustering");
            this.njclu = new NJ(this.Distance_Matrix);
        }
        System.out.println("Finished Clustering");
    }
}

