/*
 * Decompiled with CFR 0.152.
 */
package medusa;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorUIResource;
import medusa.AboutDialog;
import medusa.ColorJDialog;
import medusa.DataFileFilter;
import medusa.DataFormatException;
import medusa.MedusaSettings;
import medusa.ShowEdgePanel;
import medusa.dataio.DataLoader;
import medusa.display.EditableGraphPanel;
import medusa.graph.Graph;
import medusa.graph.Node;
import medusa.graphedit.EditGraphDialog;

public final class MedusaFrameBackup
extends JFrame
implements ItemListener,
ComponentListener,
ChangeListener {
    EditableGraphPanel stringletPanel;
    MedusaSettings stringSettings;
    static final Color darkBackground = new Color(0.33f, 0.0f, 0.0f);
    static final Color foreground = new Color(1.0f, 1.0f, 1.0f);
    public static final Color STRINGCOLOR = new Color(161, 173, 236);
    Color background = STRINGCOLOR;
    Border graphBorder = BorderFactory.createRaisedBevelBorder();
    JScrollPane jScrollPane;
    Frame f = new Frame();
    public static final String version = "1.042";
    JButton frButton = new JButton("Spring");
    JButton stringButton = new JButton("Data");
    JPanel controlPanel;
    JToggleButton relax = new JToggleButton("Relax", false);
    JToggleButton temperatureButton = new JToggleButton("Cooling", true);
    JLabel fileLabel = new JLabel("<html>File: none<b></b></html>");
    JLabel infoLabel = new JLabel("<html><b>nodes: 0<br>edges: 0</b></html>");
    JLabel emptyLabel = new JLabel("  ");
    JButton recalcButton = new JButton("Recalculate");
    private Action toggleRelax = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean relaxOn = MedusaFrameBackup.this.relax.isSelected();
            if (!relaxOn) {
                MedusaFrameBackup.this.stringletPanel.start();
            } else {
                MedusaFrameBackup.this.stringletPanel.stop();
            }
            MedusaFrameBackup.this.relax.setSelected(!relaxOn);
        }
    };
    JPanel scalerPanel = new JPanel();
    JLabel scalerLabel = new JLabel("  Scale");
    JSlider scalerSlider = new JSlider(1, 100, 300, 100);
    JMenu optionMenu = new JMenu("Options");
    JMenu selectMenu = new JMenu("Select");
    JMenu colorMenu = new JMenu("Color");
    JMenu imageMenu = new JMenu("Image");
    JMenu fontMenu = new JMenu("Font");
    JMenuItem selectAllMenuItem = new JMenuItem("All");
    JMenuItem selectNoneMenuItem = new JMenuItem("None");
    JMenuItem searchMenuItem = new JMenuItem("Search");
    JMenuItem selectNodeFromFileMenuItem = new JMenuItem("From file");
    JMenuItem invertFixMenuItem = new JMenuItem("Invert");
    JMenuItem selectGrowMenuItem = new JMenuItem("Grow selection");
    JMenuItem changeColorMenuItem = new JMenuItem("Change node color");
    JMenuItem switchColorMenuItem = new JMenuItem("Switch channels");
    JMenuItem copyColorMenuItem = new JMenuItem("Copy channels");
    JMenuItem xGradientColorMenuItem = new JMenuItem("X gradient");
    JMenuItem changeNodeSizeMenuItem = new JMenuItem("Change node size");
    JMenuItem selectNodeLabelByRegExpMenuItem = new JMenuItem("By label");
    JMenuItem selectNodeAnnotationByRegExpMenuItem = new JMenuItem("By annotation");
    JMenuItem addNodeMenuItem = new JMenuItem("Add nodes");
    JMenuItem setLabelColorMenuItem = new JMenuItem("Label");
    JMenuItem setBasicEdgeColorMenuItem = new JMenuItem("Base color");
    JMenuItem loadImageMenuItem = new JMenuItem("Load");
    JMenuItem setBackgroundColorMenuItem = new JMenuItem("Background");
    JMenuItem changeFontSizeMenuItem = new JMenuItem("Font size");
    JMenuItem clearImageMenuItem = new JMenuItem("Clear");
    JMenuItem setEdgeLenMenuItem = new JMenuItem("Edge Length");
    JMenu manipulateMenu = new JMenu("Manipulate");
    JMenu rotateMenu = new JMenu("Rotate");
    JMenu flipMenu = new JMenu("Flip");
    JMenuItem rotateRightMenuItem = new JMenuItem("90d clockwise");
    JMenuItem rotateLeftMenuItem = new JMenuItem("90d anti-clockwise");
    JMenuItem flipXItem = new JMenuItem("Vertical");
    JMenuItem flipYItem = new JMenuItem("Horizontal");
    JMenuItem deleteNodeMenuItem = new JMenuItem("Delete nodes");
    JMenuItem changeNodeShapeMenuItem = new JMenuItem("Change node shape");
    JMenuItem cropMenuItem = new JMenuItem("Crop graph");
    JMenuItem randomGraphMenuItem = new JMenuItem("Random graph");
    JMenuItem clearGraphMenuItem = new JMenuItem("Clear graph");
    JMenuItem editGraphMenuItem = new JMenuItem("Edit graph");
    JMenu fileMenu = new JMenu("File");
    JMenuBar menuBar = new JMenuBar();
    JMenuItem openMenuItem = new JMenuItem("Open");
    JMenu addSubractMenu = new JMenu("Add/Subtract");
    JMenuItem addMenuItem = new JMenuItem("Add graph");
    JMenuItem subtractMenuItem = new JMenuItem("Subtract graph");
    JMenuItem copyMenuItem = new JMenuItem("Copy settings");
    JMenu importMenu = new JMenu("Import");
    JMenuItem importTabbedMenuItem = new JMenuItem("Simple tabbed");
    JMenuItem saveMenuItem = new JMenuItem("Save");
    JMenuItem saveHTMLParametersMenuItem = new JMenuItem("HTML Parameters");
    JMenu exportMenu = new JMenu("Export");
    JMenu exportImageMenu = new JMenu("Image");
    JMenu exportPostscriptMenu = new JMenu("PostScript");
    JMenuItem exportJPGMenuItem = new JMenuItem("JPG");
    JMenuItem exportPNGMenuItem = new JMenuItem("PNG");
    JMenuItem quitMenuItem = new JMenuItem("Quit");
    JMenuItem exportPSMenuItem = new JMenuItem("PS");
    JMenuItem exportEPSMenuItem = new JMenuItem("EPS");
    JMenuItem exportPajekMenuItem = new JMenuItem("Pajek");
    JMenu interactionMenu = new JMenu("Interaction");
    JMenuItem loadInteractionMenuItem = new JMenuItem("Load");
    JMenu stringDefaultMenu = new JMenu("STRING default");
    JMenuItem stringProteinInteractionMenuItem = new JMenuItem("Protein");
    JMenuItem stringCOGInteractionMenuItem = new JMenuItem("COGS");
    JMenuItem hideShowMenuItem = new JMenuItem("Hide");
    JMenu displayMenu = new JMenu("Display");
    JCheckBoxMenuItem confidenceCBMItem = new JCheckBoxMenuItem("Confidence", true);
    JCheckBoxMenuItem prettyCBMItem = new JCheckBoxMenuItem("Interactions", false);
    JCheckBoxMenuItem namesCBMItem = new JCheckBoxMenuItem("Labels", true);
    JCheckBoxMenuItem showNamesCBMItem = new JCheckBoxMenuItem("Show names", true);
    JCheckBoxMenuItem directedCBMItem = new JCheckBoxMenuItem("Directed", false);
    JCheckBoxMenuItem hideWhenMoveCBMItem = new JCheckBoxMenuItem("Hide when move", false);
    JCheckBoxMenuItem alphaCBMItem = new JCheckBoxMenuItem("Alpha conf", true);
    JMenu nodeColorDisplayMenu = new JMenu("Node color set");
    JRadioButton channel1MenuItem = new JRadioButton("1", true);
    JRadioButton channel2MenuItem = new JRadioButton("2");
    JRadioButton channel3MenuItem = new JRadioButton("3");
    ButtonGroup nodeColorSetGroup = new ButtonGroup();
    JMenu helpMenu = new JMenu("Help");
    JMenuItem aboutMenuItem = new JMenuItem("About Medusa");
    JPanel legendPanel = new JPanel();
    JToggleButton[] toggleButton;
    JLabel legendTitleLabel;
    JPanel legendTitlePanel;
    JLabel logoLabel;
    JScrollPane legendScroller;
    EditGraphDialog egd;
    double oldScale = 1.0;
    double scale = 1.0;
    String lastDir = null;
    String lastFile = null;
    String lastInter = null;
    ProgressMonitor loader;
    Timer timer;
    DataLoader dl;
    private ActionListener runLoad = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            MedusaFrameBackup.this.infoLabel.setText(MedusaFrameBackup.this.dl.getStatus() + " " + MedusaFrameBackup.this.dl.getProgress());
            if (MedusaFrameBackup.this.dl.isDone()) {
                MedusaFrameBackup.this.timer.stop();
                MedusaFrameBackup.this.dl.stop();
                MedusaFrameBackup.this.infoLabel.setText("Cleaning graph");
                MedusaFrameBackup.this.setCursor(null);
                MedusaFrameBackup.this.stringletPanel.setGraph(MedusaFrameBackup.this.dl.getGraph());
                MedusaFrameBackup.this.updateInfo();
                MedusaFrameBackup.this.updateFileInfo();
                MedusaFrameBackup.this.stringletPanel.repaint();
            }
        }
    };
    private boolean hideInteractions = false;

    public MedusaFrameBackup() {
        super("Medusa 1.042");
    }

    private final void init() {
        this.stringSettings = new MedusaSettings();
        this.stringletPanel = new EditableGraphPanel(this.stringSettings);
        this.stringletPanel.setBasicEdgeColor(Color.black);
        this.stringletPanel.setTimeFrameXY(600, 600);
        this.stringletPanel.setBorder(this.graphBorder);
        this.stringletPanel.setShowBorder(false);
        this.stringletPanel.setArrows(false);
        this.stringletPanel.setCool(true);
        this.jScrollPane = new JScrollPane(this.stringletPanel);
        this.egd = new EditGraphDialog((Frame)this, true);
        this.buildGUI();
    }

    protected void buildGUI() {
        this.setDefaultCloseOperation(3);
        this.addComponentListener(this);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        this.menuBar.setBackground(this.background);
        this.populateFileMenu();
        this.menuBar.add(this.fileMenu);
        this.populateSelectMenu();
        this.menuBar.add(this.selectMenu);
        this.populateOptionMenu();
        this.menuBar.add(this.optionMenu);
        this.populateManipulateMenu();
        this.menuBar.add(this.manipulateMenu);
        this.populateInteractionMenu();
        this.menuBar.add(this.interactionMenu);
        this.populateDisplayMenu();
        this.menuBar.add(this.displayMenu);
        this.populateHelpMenu();
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.controlPanel = new JPanel();
        this.populateControlPanel();
        this.controlPanel.setBorder(this.graphBorder);
        content.add("Center", this.jScrollPane);
        content.add("South", this.controlPanel);
        this.populateLegendPanel();
        this.populateScalerPanel();
        content.add("East", this.scalerPanel);
    }

    public void loadData(String data, boolean medusa) throws IOException, DataFormatException {
        System.out.println("Loading " + data + ". Please wait");
        this.dl = new DataLoader();
        Graph g = null;
        g = medusa ? this.dl.load(data) : this.dl.loadSimplest(data);
        this.stringletPanel.setGraph(g);
    }

    private final void loadInteractionSettings(String interactionSettings) throws IOException {
        this.stringSettings.load(interactionSettings);
        this.updateLegend();
        this.stringletPanel.updateStringSettings(this.stringSettings);
    }

    void initData() {
        try {
            boolean weng = this.loadSettings();
            this.defaultNet();
            if (this.stringletPanel == null) {
                System.out.println("stringletPanel is null");
            }
            if (weng) {
                this.waitForLoad(this.lastDir, 0);
            }
        }
        catch (IOException ie) {
            this.defaultNet();
        }
        catch (DataFormatException de) {
            JOptionPane.showMessageDialog(this, de.getMessage(), "Data Error", 0);
            this.defaultNet();
        }
    }

    public void defaultNet() {
    }

    public static void main(String[] args) {
        MedusaFrameBackup.setLnF();
        MedusaFrameBackup stringletFrame = new MedusaFrameBackup();
        stringletFrame.init();
        try {
            stringletFrame.checkArgs(args);
        }
        catch (DataFormatException ex) {
            System.out.println("Data format error! Check your data.");
            ex.printStackTrace();
            System.exit(0);
        }
        catch (IOException ex) {
            System.out.println("File error! Check the integrity of your file.");
            ex.printStackTrace();
            System.exit(0);
        }
        stringletFrame.pack();
        MedusaFrameBackup.centerWindow(stringletFrame);
        stringletFrame.setVisible(true);
    }

    public void checkArgs(String[] args) throws IOException, DataFormatException {
        System.out.println("Checking arguments");
        int ln = args.length;
        if (ln == 0) {
            System.out.println("No arguments. Proceeding normally");
            this.initData();
            return;
        }
        if (ln == 2) {
            this.checkArgPair(args);
            return;
        }
        if (ln == 4) {
            this.checkArgPair(new String[]{args[0], args[1]});
            this.checkArgPair(new String[]{args[2], args[3]});
            return;
        }
    }

    private void checkArgPair(String[] args) throws IOException, DataFormatException {
        if (args[0].compareTo("f") == 0) {
            this.loadData(args[1], true);
        }
        if (args[0].compareTo("i") == 0) {
            this.loadInteractionSettings(args[1]);
        }
        if (args[0].compareTo("t") == 0) {
            this.loadData(args[1], false);
        }
    }

    public static void setLnF() {
        Color silly = new Color(255, 255, 255);
        ColorUIResource weng = new ColorUIResource(silly);
    }

    public static void centerWindow(Window win) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = win.getSize();
        win.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private void populateControlPanel() {
        this.controlPanel.add(this.fileLabel);
        this.controlPanel.add(this.infoLabel);
        this.controlPanel.add(this.emptyLabel);
        this.controlPanel.add(this.relax);
        this.relax.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ex) {
                if (MedusaFrameBackup.this.relax.isSelected()) {
                    MedusaFrameBackup.this.stringletPanel.start();
                } else {
                    MedusaFrameBackup.this.stringletPanel.stop();
                }
            }
        });
        this.controlPanel.add(this.temperatureButton);
        this.temperatureButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MedusaFrameBackup.this.stringletPanel.setCool(MedusaFrameBackup.this.temperatureButton.isSelected());
            }
        });
        this.controlPanel.add(this.stringButton);
        this.stringButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.stringConnection();
            }
        });
        this.controlPanel.add(this.frButton);
        this.frButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.stopRelax();
                MedusaFrameBackup.this.stringletPanel.energy();
            }
        });
        this.controlPanel.add(this.recalcButton);
        this.recalcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.recalcEvent();
            }
        });
    }

    private void updateInfo() {
        String[] result = this.stringletPanel.getGraphData();
        String display = "<html><b>nodes: " + result[0] + "<br>edges: " + result[1] + "</b></html>";
        this.infoLabel.setText(display);
    }

    private void updateFileInfo() {
        this.fileLabel.setText(this.lastFile);
    }

    private void populateScalerPanel() {
        this.scalerPanel.setLayout(new BoxLayout(this.scalerPanel, 1));
        this.scalerPanel.setOpaque(true);
        this.scalerPanel.setBackground(this.background);
        this.scalerSlider.setMajorTickSpacing(50);
        this.scalerSlider.setMinorTickSpacing(10);
        this.scalerSlider.setPaintTicks(true);
        this.scalerSlider.setPaintLabels(true);
        this.scalerSlider.setBackground(this.background);
        this.scalerSlider.setForeground(foreground);
        this.scalerPanel.setBackground(this.background);
        this.scalerPanel.setForeground(foreground);
        this.legendPanel.setAlignmentX(0.0f);
        this.scalerSlider.setAlignmentX(0.0f);
        this.scalerLabel.setAlignmentX(0.0f);
        this.scalerLabel.setForeground(foreground);
        this.scalerPanel.add(this.legendPanel);
        this.scalerPanel.add(this.scalerLabel);
        this.scalerPanel.add(this.scalerSlider);
        this.scalerSlider.addChangeListener(this);
    }

    private void populateOptionMenu() {
        this.optionMenu.setMnemonic(79);
        this.colorMenu.setMnemonic(67);
        this.fontMenu.setMnemonic(70);
        this.changeColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.changeColorEvent();
            }
        });
        this.switchColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.switchColorEvent();
            }
        });
        this.copyColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.copyColorEvent();
            }
        });
        this.xGradientColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.stringletPanel.addGradientX(2);
            }
        });
        this.changeNodeSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.changeNodeSizeEvent();
            }
        });
        this.setBasicEdgeColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.setBasicEdgeColorEvent();
            }
        });
        this.setLabelColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.setLabelColorEvent();
            }
        });
        this.setBackgroundColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.setBackgroundColorEvent();
            }
        });
        this.loadImageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.loadImageEvent();
            }
        });
        this.clearImageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.clearImageEvent();
            }
        });
        this.changeFontSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.changeFontSizeEvent();
            }
        });
        this.setEdgeLenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.setEdgeLenEvent();
            }
        });
        this.colorMenu.add(this.changeColorMenuItem);
        this.colorMenu.add(this.switchColorMenuItem);
        this.colorMenu.add(this.copyColorMenuItem);
        this.optionMenu.setBackground(this.background);
        this.optionMenu.setForeground(foreground);
        this.optionMenu.add(this.changeNodeSizeMenuItem);
        this.optionMenu.add(this.setEdgeLenMenuItem);
        this.colorMenu.addSeparator();
        this.colorMenu.add(this.setBasicEdgeColorMenuItem);
        this.fontMenu.add(this.setLabelColorMenuItem);
        this.colorMenu.add(this.setBackgroundColorMenuItem);
        this.optionMenu.addSeparator();
        this.optionMenu.add(this.colorMenu);
        this.fontMenu.add(this.changeFontSizeMenuItem);
        this.optionMenu.add(this.fontMenu);
        this.optionMenu.addSeparator();
        this.imageMenu.add(this.loadImageMenuItem);
        this.imageMenu.add(this.clearImageMenuItem);
        this.optionMenu.add(this.imageMenu);
    }

    private void populateSelectMenu() {
        this.selectMenu.setBackground(this.background);
        this.selectMenu.setForeground(foreground);
        this.selectMenu.setMnemonic(83);
        this.selectNodeLabelByRegExpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.searchNodeEvent(true);
            }
        });
        this.selectNodeAnnotationByRegExpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.searchNodeEvent(false);
            }
        });
        this.selectNodeFromFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.selectNodeFromFileEvent();
            }
        });
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.stringletPanel.setFix(true);
            }
        });
        this.selectNoneMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.stringletPanel.setFix(false);
            }
        });
        this.invertFixMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.stringletPanel.invertFix();
            }
        });
        this.selectGrowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.stringletPanel.growSelection();
            }
        });
        this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.selectNoneMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        this.selectMenu.add(this.selectAllMenuItem);
        this.selectMenu.add(this.selectNoneMenuItem);
        this.selectMenu.add(this.selectNodeLabelByRegExpMenuItem);
        this.selectMenu.add(this.selectNodeAnnotationByRegExpMenuItem);
        this.selectMenu.add(this.selectNodeFromFileMenuItem);
        this.selectMenu.add(this.invertFixMenuItem);
        this.selectMenu.add(this.selectGrowMenuItem);
    }

    private void populateManipulateMenu() {
        this.manipulateMenu.setMnemonic(77);
        this.changeNodeShapeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.setShapeEvent();
            }
        });
        this.deleteNodeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.stopRelax();
                MedusaFrameBackup.this.stringletPanel.removeFixedNodes();
                MedusaFrameBackup.this.updateInfo();
                MedusaFrameBackup.this.stringletPanel.repaint();
            }
        });
        this.cropMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String confidence = JOptionPane.showInputDialog("Choose minimum confidence level:", (Object)"1.0");
                if (confidence != null) {
                    MedusaFrameBackup.this.stringletPanel.crop(Double.parseDouble(confidence));
                    MedusaFrameBackup.this.updateInfo();
                    MedusaFrameBackup.this.stringletPanel.repaint();
                }
            }
        });
        this.randomGraphMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.getRandomGraphEvent();
            }
        });
        this.clearGraphMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.clearGraphEvent();
            }
        });
        this.rotateRightMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.rotateEvent(1.5707963267948966);
            }
        });
        this.rotateLeftMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.rotateEvent(-1.5707963267948966);
            }
        });
        this.flipXItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.flipX();
            }
        });
        this.flipYItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.flipY();
            }
        });
        this.editGraphMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.editGraph();
            }
        });
        this.manipulateMenu.add(this.clearGraphMenuItem);
        this.manipulateMenu.add(this.changeNodeShapeMenuItem);
        this.manipulateMenu.add(this.deleteNodeMenuItem);
        this.manipulateMenu.add(this.cropMenuItem);
        this.manipulateMenu.add(this.randomGraphMenuItem);
        this.manipulateMenu.setForeground(foreground);
        this.manipulateMenu.setBackground(this.background);
        this.rotateMenu.add(this.rotateRightMenuItem);
        this.rotateMenu.add(this.rotateLeftMenuItem);
        this.flipMenu.add(this.flipXItem);
        this.flipMenu.add(this.flipYItem);
        this.manipulateMenu.add(this.rotateMenu);
        this.manipulateMenu.add(this.flipMenu);
        this.manipulateMenu.addSeparator();
        this.manipulateMenu.add(this.editGraphMenuItem);
    }

    protected void populateFileMenu() {
        this.fileMenu.setMnemonic(70);
        this.quitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.quitApplication();
            }
        });
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.loadEvent(0);
            }
        });
        this.addMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.addGraphEvent();
            }
        });
        this.subtractMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.subtractGraphEvent();
            }
        });
        this.copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.copyGraphEvent();
            }
        });
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.saveEvent();
            }
        });
        this.saveHTMLParametersMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.saveHTMLParametersEvent();
            }
        });
        this.exportJPGMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.exportImageEvent(false);
            }
        });
        this.exportPNGMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.exportImageEvent(true);
            }
        });
        this.exportPSMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.exportPSEvent();
            }
        });
        this.exportEPSMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.exportEPSEvent();
            }
        });
        this.exportPajekMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.exportPajekEvent();
            }
        });
        this.importTabbedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.loadEvent(1);
            }
        });
        this.fileMenu.setBackground(this.background);
        this.fileMenu.setForeground(foreground);
        this.fileMenu.add(this.openMenuItem);
        this.fileMenu.add(this.addSubractMenu);
        this.addSubractMenu.add(this.addMenuItem);
        this.addSubractMenu.add(this.subtractMenuItem);
        this.addSubractMenu.add(this.copyMenuItem);
        this.fileMenu.add(this.importMenu);
        this.fileMenu.add(this.saveMenuItem);
        this.exportImageMenu.add(this.exportJPGMenuItem);
        this.exportImageMenu.add(this.exportPNGMenuItem);
        this.exportPostscriptMenu.add(this.exportPSMenuItem);
        this.exportPostscriptMenu.add(this.exportEPSMenuItem);
        this.exportMenu.add(this.exportImageMenu);
        this.exportMenu.add(this.exportPostscriptMenu);
        this.exportMenu.add(this.exportPajekMenuItem);
        this.exportMenu.add(this.saveHTMLParametersMenuItem);
        this.importMenu.add(this.importTabbedMenuItem);
        this.fileMenu.add(this.exportMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.quitMenuItem);
    }

    protected void populateInteractionMenu() {
        this.interactionMenu.setMnemonic(73);
        this.loadInteractionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.interactionEvent();
            }
        });
        this.stringProteinInteractionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.proteinInteractionEvent();
            }
        });
        this.stringCOGInteractionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.cogInteractionEvent();
            }
        });
        this.hideShowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.hideShowInteractionsEvent();
            }
        });
        this.interactionMenu.add(this.loadInteractionMenuItem);
        this.stringDefaultMenu.add(this.stringProteinInteractionMenuItem);
        this.stringDefaultMenu.add(this.stringCOGInteractionMenuItem);
        this.interactionMenu.add(this.stringDefaultMenu);
        this.interactionMenu.addSeparator();
        this.interactionMenu.add(this.hideShowMenuItem);
        this.interactionMenu.setBackground(this.background);
        this.interactionMenu.setForeground(foreground);
    }

    protected void populateDisplayMenu() {
        this.displayMenu.setMnemonic(68);
        this.prettyCBMItem.setAccelerator(KeyStroke.getKeyStroke(73, 8));
        this.prettyCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MedusaFrameBackup.this.stringletPanel.setPretty(MedusaFrameBackup.this.prettyCBMItem.isSelected());
                MedusaFrameBackup.this.stringletPanel.repaint();
            }
        });
        this.namesCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MedusaFrameBackup.this.stringletPanel.setLabel(MedusaFrameBackup.this.namesCBMItem.isSelected());
                MedusaFrameBackup.this.stringletPanel.repaint();
            }
        });
        this.showNamesCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MedusaFrameBackup.this.stringletPanel.setShowName(MedusaFrameBackup.this.showNamesCBMItem.isSelected());
                MedusaFrameBackup.this.stringletPanel.repaint();
            }
        });
        this.confidenceCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MedusaFrameBackup.this.stringletPanel.setConfidence(MedusaFrameBackup.this.confidenceCBMItem.isSelected());
                MedusaFrameBackup.this.stringletPanel.repaint();
            }
        });
        this.directedCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MedusaFrameBackup.this.stringletPanel.setArrows(MedusaFrameBackup.this.directedCBMItem.isSelected());
                MedusaFrameBackup.this.stringletPanel.repaint();
            }
        });
        this.hideWhenMoveCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MedusaFrameBackup.this.stringletPanel.setHideWhenMove(MedusaFrameBackup.this.hideWhenMoveCBMItem.isSelected());
                MedusaFrameBackup.this.stringletPanel.repaint();
            }
        });
        this.alphaCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MedusaFrameBackup.this.stringletPanel.setAlpha(MedusaFrameBackup.this.alphaCBMItem.isSelected());
                MedusaFrameBackup.this.stringletPanel.repaint();
            }
        });
        this.channel1MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.setNodeColorSet(1);
            }
        });
        this.channel2MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.setNodeColorSet(2);
            }
        });
        this.channel3MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.setNodeColorSet(3);
            }
        });
        this.displayMenu.setBackground(this.background);
        this.displayMenu.setForeground(foreground);
        this.displayMenu.add(this.prettyCBMItem);
        this.displayMenu.add(this.namesCBMItem);
        this.displayMenu.add(this.showNamesCBMItem);
        this.displayMenu.add(this.directedCBMItem);
        this.displayMenu.add(this.confidenceCBMItem);
        this.displayMenu.add(this.alphaCBMItem);
        this.displayMenu.addSeparator();
        this.displayMenu.add(this.hideWhenMoveCBMItem);
        this.displayMenu.addSeparator();
        this.nodeColorDisplayMenu.add(this.channel1MenuItem);
        this.nodeColorDisplayMenu.add(this.channel2MenuItem);
        this.nodeColorDisplayMenu.add(this.channel3MenuItem);
        this.nodeColorSetGroup.add(this.channel1MenuItem);
        this.nodeColorSetGroup.add(this.channel2MenuItem);
        this.nodeColorSetGroup.add(this.channel3MenuItem);
        this.displayMenu.add(this.nodeColorDisplayMenu);
    }

    protected void populateHelpMenu() {
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedusaFrameBackup.this.aboutEvent();
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.helpMenu.setBackground(this.background);
        this.helpMenu.setForeground(foreground);
    }

    protected void populateLegendPanel() {
        this.legendPanel.setLayout(new BoxLayout(this.legendPanel, 1));
        this.legendPanel.setOpaque(true);
        this.legendPanel.setBackground(this.background);
        this.initLegendTitle();
        this.legendPanel.add(this.legendTitlePanel);
        this.initLegendScroller();
        this.legendPanel.add(this.legendScroller);
    }

    public void updateLegend() {
        this.legendPanel.removeAll();
        this.initLegendScroller();
        this.legendPanel.add(this.legendTitlePanel);
        this.legendPanel.add(this.legendScroller);
        this.legendPanel.validate();
        this.scalerPanel.validate();
        this.scalerPanel.repaint();
    }

    private void initLegendTitle() {
        this.legendTitlePanel = new JPanel();
        this.legendTitlePanel.setLayout(new BoxLayout(this.legendTitlePanel, 1));
        this.legendTitlePanel.setOpaque(true);
        this.legendTitlePanel.setBackground(this.background);
        this.logoLabel = new JLabel();
        this.legendTitleLabel = new JLabel("Interactions");
        this.legendTitleLabel.setBackground(this.background);
        this.legendTitleLabel.setForeground(foreground);
        URL imageURL = this.getClass().getResource("/medusa/images/medusa_logo_small.png");
        this.logoLabel.setIcon(new ImageIcon(imageURL));
        this.legendTitlePanel.add(this.logoLabel);
        this.legendTitlePanel.add(this.legendTitleLabel);
    }

    private void initLegendScroller() {
        Dimension legendSize = new Dimension(150, 100);
        this.legendScroller.setPreferredSize(legendSize);
        this.legendScroller.revalidate();
    }

    private int yes_no(String message) {
        int s = JOptionPane.showConfirmDialog(this, message, "Confirm", 0);
        return s;
    }

    private void clearGraphEvent() {
        this.stopAllRelax();
        if (this.yes_no("Your data will be lost. Are you sure?") == 0) {
            this.stringletPanel.clearGraph();
            this.stringletPanel.repaint();
            this.updateInfo();
        }
    }

    private void recalcEvent() {
        this.stopAllRelax();
        if (this.yes_no("This will return edge length \nand orientation to default values\n Are you sure you want to do this?") == 0) {
            this.stringletPanel.autoFixOrientation();
            this.stringletPanel.calculateEdgeLength();
            this.stringletPanel.repaint();
        }
    }

    private void rotateEvent(double degrees) {
        this.stopAllRelax();
        this.stringletPanel.rotate(degrees);
        this.stringletPanel.repaint();
    }

    private void flipEvent(boolean x, boolean y) {
        this.stopAllRelax();
        this.stringletPanel.mirror(x, y);
        this.stringletPanel.repaint();
    }

    private void flipX() {
        this.flipEvent(true, false);
    }

    private void flipY() {
        this.flipEvent(false, true);
    }

    private void editGraph() {
        this.stopAllRelax();
        this.egd = new EditGraphDialog((Frame)this, true);
        this.egd.setGraph(this.stringletPanel.getGraph());
        this.egd.setVisible(true);
        Graph g = this.egd.getGraph();
        if (g != null) {
            this.stringletPanel.setGraph(g);
            this.stringletPanel.repaint();
        }
    }

    private void stringConnection() {
        JOptionPane.showConfirmDialog(this, "STRING requires a license and is not\navailable to open source", "Disabled", -1, 1);
    }

    private void aboutEvent() {
        AboutDialog.showDialog(this, null, version);
    }

    private void setShapeEvent() {
        Object[] shapes = new Object[]{"circle", "rectangle", "triangle", "diamond"};
        int s = JOptionPane.showOptionDialog(this, "Choose a node shape", "Shape", 1, 3, null, shapes, "circle");
        this.stringletPanel.setShape(s);
    }

    public void loadImageEvent() {
        this.stringletPanel.stop();
        this.relax.setSelected(false);
        FileDialog fdLoad = new FileDialog((Frame)this, "Load image", 0);
        fdLoad.setVisible(true);
        String loadFile = fdLoad.getFile();
        String dir = fdLoad.getDirectory();
        if (loadFile != null) {
            try {
                this.stringletPanel.setImage(dir + loadFile);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "The image could not be found or opened", "Load Error", 0);
            }
        }
        this.stringletPanel.repaint();
    }

    private void stopAllRelax() {
        this.stringletPanel.stop();
        this.relax.setSelected(false);
        this.controlPanel.repaint();
    }

    public void clearImageEvent() {
        this.stopAllRelax();
        this.stringletPanel.clearImage();
        this.stringletPanel.repaint();
    }

    public void quitApplication() {
        this.stopAllRelax();
        System.out.println("Closing application");
        try {
            this.saveSettings();
            System.out.println("Current settings saved");
        }
        catch (IOException ie) {
            System.out.println("...settings not saved due to file problems");
        }
        this.remove(this.stringletPanel);
        System.exit(0);
    }

    private void loadEvent(int loadType) {
        this.stopAllRelax();
        this.scaleOut();
        FileDialog fdLoad = new FileDialog((Frame)this, "Load graph", 0);
        if (this.lastDir != null) {
            fdLoad.setDirectory(this.lastDir);
        }
        fdLoad.setFilenameFilter(new DataFileFilter());
        fdLoad.setVisible(true);
        String loadFile = fdLoad.getFile();
        String dir = fdLoad.getDirectory();
        if (loadFile != null) {
            try {
                this.waitForLoad(dir + loadFile, loadType);
                this.lastDir = dir;
                this.lastFile = loadFile;
            }
            catch (IOException ie) {
                ie.printStackTrace();
                JOptionPane.showMessageDialog(this, "The file could not be found or opened", "Load Error", 0);
            }
            catch (DataFormatException dfe) {
                JOptionPane.showMessageDialog(this, dfe.getMessage(), "Data Error", 0);
            }
        }
    }

    private void getRandomGraphEvent() {
        int s = this.yes_no("This will generate a random graph. Are you sure?");
        if (s == 0) {
            this.stopAllRelax();
            this.stringletPanel.randomGraph(30, 60);
            this.updateInfo();
            this.stringletPanel.repaint();
        }
    }

    private void addGraphEvent() {
        this.stopAllRelax();
        this.scaleOut();
        FileDialog fdLoad = new FileDialog((Frame)this, "Add graph", 0);
        if (this.lastDir != null) {
            fdLoad.setFile(this.lastDir + this.lastFile);
        }
        fdLoad.setFilenameFilter(new DataFileFilter());
        fdLoad.setVisible(true);
        String loadFile = fdLoad.getFile();
        String dir = fdLoad.getDirectory();
        if (loadFile != null) {
            try {
                this.stringletPanel.appendGraph(dir + loadFile);
                this.lastDir = dir + loadFile;
                this.lastFile = loadFile;
                this.updateInfo();
                this.stringletPanel.repaint();
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "The file could not be found or opened", "Load Error", 0);
            }
            catch (DataFormatException dfe) {
                JOptionPane.showMessageDialog(this, dfe.getMessage(), "Data Error", 0);
            }
        }
    }

    private void subtractGraphEvent() {
        this.stopAllRelax();
        this.scaleOut();
        FileDialog fdLoad = new FileDialog((Frame)this, "Add graph", 0);
        if (this.lastDir != null) {
            fdLoad.setFile(this.lastDir + this.lastFile);
        }
        fdLoad.setFilenameFilter(new DataFileFilter());
        fdLoad.setVisible(true);
        String loadFile = fdLoad.getFile();
        String dir = fdLoad.getDirectory();
        if (loadFile != null) {
            try {
                this.stringletPanel.subtractGraph(dir + loadFile);
                this.lastDir = dir + loadFile;
                this.lastFile = loadFile;
                this.updateInfo();
                this.stringletPanel.repaint();
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "The file could not be found or opened", "Load Error", 0);
            }
            catch (DataFormatException dfe) {
                JOptionPane.showMessageDialog(this, dfe.getMessage(), "Data Error", 0);
            }
        }
    }

    private void copyGraphEvent() {
        this.stopAllRelax();
        this.scaleOut();
        FileDialog fdLoad = new FileDialog((Frame)this, "Add graph", 0);
        if (this.lastDir != null) {
            fdLoad.setFile(this.lastDir + this.lastFile);
        }
        fdLoad.setFilenameFilter(new DataFileFilter());
        fdLoad.setVisible(true);
        String loadFile = fdLoad.getFile();
        String dir = fdLoad.getDirectory();
        if (loadFile != null) {
            try {
                this.stringletPanel.copyGraphSettings(dir + loadFile);
                this.lastDir = dir + loadFile;
                this.lastFile = loadFile;
                this.updateInfo();
                this.stringletPanel.repaint();
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "The file could not be found or opened", "Load Error", 0);
            }
            catch (DataFormatException dfe) {
                JOptionPane.showMessageDialog(this, dfe.getMessage(), "Data Error", 0);
            }
        }
    }

    private void saveEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save as", 1);
        fdSave.setFilenameFilter(new DataFileFilter());
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        String dir = fdSave.getDirectory();
        if (saveFile != null) {
            this.lastDir = dir;
            this.lastFile = saveFile;
            try {
                this.stringletPanel.saveGraph(dir + saveFile);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    private void saveHTMLParametersEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save applet parameters to", 1);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        this.dl = new DataLoader();
        if (saveFile != null) {
            try {
                this.dl.saveHTMLParameters(this.stringletPanel.getGraph(), saveFile);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    private void exportEPSEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save as EPS", 1);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        String dir = fdSave.getDirectory();
        if (saveFile != null) {
            try {
                this.stringletPanel.writeEPS(dir + saveFile);
                JOptionPane.showMessageDialog(this, "Panel exported to " + saveFile, "EPS saved", 1);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    private void exportPSEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save as PS", 1);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        String dir = fdSave.getDirectory();
        if (saveFile != null) {
            try {
                this.stringletPanel.writePS(dir + saveFile);
                JOptionPane.showMessageDialog(this, "Panel exported to " + saveFile, "PS saved", 1);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    private void exportPajekEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save as pajek", 1);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        String dir = fdSave.getDirectory();
        if (saveFile != null) {
            try {
                this.stringletPanel.writePajek(dir + saveFile);
                JOptionPane.showMessageDialog(this, "Exported to pajek format " + saveFile, "Pajek", 1);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    private void interactionEvent() {
        FileDialog fdInter = new FileDialog((Frame)this, "Load interaction file", 0);
        fdInter.setVisible(true);
        String loadFile = fdInter.getFile();
        String dir = fdInter.getDirectory();
        if (loadFile != null) {
            try {
                this.lastInter = dir + loadFile;
                this.stringSettings.load(dir + loadFile);
                this.updateLegend();
                this.stringletPanel.updateStringSettings(this.stringSettings);
                this.legendPanel.repaint();
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Interaction settings could not be loaded.\nCheck if the file is valid.", "Load error", 0);
            }
        }
    }

    private void exportImageEvent(boolean png) {
        String name = "network." + (png ? "png" : "jpg");
        FileDialog fdSave = new FileDialog((Frame)this, "Save as" + (png ? "png" : "jpg"), 1);
        fdSave.setFile(name);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        String dir = fdSave.getDirectory();
        int type = png ? 1 : 0;
        this.stringletPanel.saveImage(dir + saveFile, type);
        JOptionPane.showMessageDialog(this, "Panel exported to " + saveFile, "Image saved", 1);
    }

    private void switchColorEvent() {
        int[] colors = ColorJDialog.showDialog(this.f, null, "switch with");
        this.stringletPanel.manipulateColor(colors[0], colors[1], true);
        this.stringletPanel.repaint();
    }

    private void copyColorEvent() {
        int[] colors = ColorJDialog.showDialog(this.f, null, "copy to");
        this.stringletPanel.manipulateColor(colors[0], colors[1], false);
        this.stringletPanel.repaint();
    }

    private void changeColorEvent() {
        Color newColor = JColorChooser.showDialog(this.getRootPane(), "Choose node color", Color.red);
        if (newColor != null) {
            this.stringletPanel.changeNodeColor(newColor);
            this.stringletPanel.repaint();
        }
    }

    private void setLabelColorEvent() {
        Color newColor = JColorChooser.showDialog(this.getRootPane(), "Choose label color", Color.black);
        if (newColor != null) {
            this.stringletPanel.setFontColor(newColor);
            this.stringletPanel.repaint();
        }
    }

    private void setBackgroundColorEvent() {
        Color newColor = JColorChooser.showDialog(this.getRootPane(), "Choose label color", Color.white);
        if (newColor != null) {
            this.stringletPanel.setBackgroundColor(newColor);
            this.stringletPanel.repaint();
        }
    }

    private void setBasicEdgeColorEvent() {
        Color newColor = JColorChooser.showDialog(this.getRootPane(), "Choose label color", Color.gray);
        if (newColor != null) {
            this.stringletPanel.setBasicEdgeColor(newColor);
            this.stringletPanel.repaint();
        }
    }

    private void changeNodeSizeEvent() {
        String s = JOptionPane.showInputDialog("Enter node size in pixels:\nDefault value is 10", (Object)"");
        int newSize = -1;
        if (s != null && s.length() > 0) {
            try {
                newSize = Integer.parseInt(s);
                this.stringletPanel.setNodeSize(newSize);
            }
            catch (NumberFormatException ne) {
                JOptionPane.showMessageDialog(this, "Incorrect input", "An integer is required for this action", 0);
            }
        }
        this.stringletPanel.repaint();
    }

    private void changeFontSizeEvent() {
        String s = JOptionPane.showInputDialog("Enter font size:\nDefault value is 10", (Object)"");
        if (s != null && s.length() > 0) {
            try {
                int newSize = Integer.parseInt(s);
                this.stringletPanel.changeFont(newSize);
            }
            catch (NumberFormatException ne) {
                JOptionPane.showMessageDialog(this, "Incorrect input", "An integer is required for this action", 0);
            }
        }
        this.stringletPanel.repaint();
    }

    private void searchNodeEvent(boolean label) {
        String s = JOptionPane.showInputDialog("Mark node matching regular expression:\ne.g. \"mito.*\"", (Object)"");
        if (s != null && this.stringletPanel.selectNodeByRegExp(s, label) == 0) {
            JOptionPane.showMessageDialog(this, "No match found", "No nodes matching your pattern were found", 0);
        }
        this.stringletPanel.repaint();
    }

    private void selectNodeFromFileEvent() {
        FileDialog fdSelect = new FileDialog((Frame)this, "Load node list", 0);
        if (this.lastDir != null) {
            fdSelect.setDirectory(this.lastDir);
        }
        fdSelect.setVisible(true);
        String loadFile = fdSelect.getFile();
        String dir = fdSelect.getDirectory();
        try {
            int c = this.stringletPanel.selectNodeFromFile(dir + loadFile);
            this.stringletPanel.repaint();
        }
        catch (IOException sNFFe) {
            JOptionPane.showMessageDialog(this, sNFFe.getMessage(), "Load Error", 0);
        }
    }

    public void stopRelax() {
        this.stringletPanel.stop();
        if (this.relax.isSelected()) {
            this.relax.setSelected(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    public void handleClassStateChange(ItemEvent e) {
        Object src = e.getSource();
        this.handleToggle(src);
    }

    public void handleToggle(Object src) {
        System.out.println("debug line 1522 event handled");
        ShowEdgePanel se = (ShowEdgePanel)src;
        System.out.println(se.getNumber());
    }

    public void handleEdgeEvent(int number, boolean selected) {
        this.stringletPanel.setShowEdge(number - 1, selected);
        this.stringletPanel.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider src = (JSlider)e.getSource();
        if (!src.getValueIsAdjusting()) {
            Dimension d = this.stringletPanel.getSize();
            double scale = (double)src.getValue() / 100.0;
            this.stringletPanel.setScale(scale / this.oldScale);
            this.stringletPanel.setTimeFrameXY(d);
            this.oldScale = scale;
            this.stringletPanel.repaint();
            this.stringletPanel.revalidate();
            this.jScrollPane.revalidate();
        }
    }

    public void scaleOut() {
        this.scalerSlider.setValue(100);
        double scale = 1.0;
        this.stringletPanel.setScale(scale / this.oldScale);
        Dimension d = this.stringletPanel.getSize();
        this.stringletPanel.setTimeFrameXY(d);
        this.oldScale = scale;
        this.stringletPanel.repaint();
        this.stringletPanel.revalidate();
        this.jScrollPane.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void saveSettings() throws IOException {
        if (this.lastDir != null) {
            File saveFile = new File("NetViewSettings.ini");
            FileWriter out = new FileWriter(saveFile);
            out.write("LASTDIR=");
            out.write(this.lastDir + "\n");
            if (this.lastInter != null) {
                out.write("INTERACT=");
                out.write(this.lastInter + "\n");
            }
            out.close();
        }
    }

    private boolean loadSettings() throws IOException {
        Pattern interPattern;
        File loadFile = new File("NetViewSettings.ini");
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(loadFile)));
        String inLine = in.readLine();
        if (inLine == null) {
            System.out.println("Error in NetViewSettings.ini");
            return false;
        }
        Pattern dirPattern = Pattern.compile("LASTDIR=(.+)");
        Matcher matcher = dirPattern.matcher(inLine);
        if (!matcher.find()) {
            return false;
        }
        this.lastDir = matcher.group(1);
        inLine = in.readLine();
        if (inLine != null && (matcher = (interPattern = Pattern.compile("INTERACT=(\\w+)")).matcher(inLine)).find()) {
            this.lastInter = matcher.group(1);
        }
        in.close();
        return true;
    }

    private String getFixedNodesAsString() {
        StringBuffer sb = new StringBuffer();
        sb.append("");
        ArrayList nodeArray = this.stringletPanel.getFixed();
        for (Node n : nodeArray) {
            sb.append(n.getLabel());
            sb.append("\n");
        }
        return sb.toString();
    }

    private void proteinInteractionEvent() {
        this.stringSettings.clear();
        this.stringSettings.init();
        this.updateLegend();
        this.stringletPanel.updateStringSettings(this.stringSettings);
        this.legendPanel.repaint();
    }

    private void cogInteractionEvent() {
        this.stringSettings.clear();
        this.stringSettings.initCOGS();
        this.updateLegend();
        this.stringletPanel.updateStringSettings(this.stringSettings);
        this.legendPanel.repaint();
    }

    private void setEdgeLenEvent() {
        int len = (int)this.stringletPanel.getEdgeLen();
        String s = JOptionPane.showInputDialog("Enter desired edge length in pixels:\nSet to 0 for default length", (Object)String.valueOf(len));
        if (s != null && s.length() > 0) {
            try {
                int newSize = Integer.parseInt(s);
                this.stringletPanel.setEdgeLen(newSize);
            }
            catch (NumberFormatException ne) {
                JOptionPane.showMessageDialog(this, "Incorrect input", "An integer is required for this action", 0);
            }
        }
    }

    public void waitForLoad(String fileName, int loadType) throws IOException, DataFormatException {
        this.dl = new DataLoader(600, 600, fileName);
        this.dl.setLoadType(loadType);
        this.timer = new Timer(500, this.runLoad);
        this.dl.start();
        this.timer.start();
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void hideShowInteractionsEvent() {
        Container content = this.getContentPane();
        if (!this.hideInteractions) {
            content.remove(this.scalerPanel);
            this.hideShowMenuItem.setText("Show");
            this.hideInteractions = true;
        } else {
            content.add("East", this.scalerPanel);
            this.hideShowMenuItem.setText("Hide");
            this.hideInteractions = false;
        }
        this.validate();
    }

    private void setNodeColorSet(int i) {
        this.stringletPanel.setNodeColorSet(i);
    }
}

