/*
 * Decompiled with CFR 0.152.
 */
package recunn.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import recunn.autodiff.Graph;
import recunn.matrix.Matrix;
import recunn.model.Model;
import recunn.model.Nonlinearity;

public class FeedForwardLayer
implements Model {
    private static final long serialVersionUID = 1L;
    Matrix W;
    Matrix b;
    Nonlinearity f;

    public FeedForwardLayer(int inputDimension, int outputDimension, Nonlinearity f, double initParamsStdDev, Random rng) {
        this.W = Matrix.rand(outputDimension, inputDimension, initParamsStdDev, rng);
        this.b = new Matrix(outputDimension);
        this.f = f;
    }

    @Override
    public Matrix forward(Matrix input, Graph g) throws Exception {
        Matrix sum = g.add(g.mul(this.W, input), this.b);
        Matrix out = g.nonlin(this.f, sum);
        return out;
    }

    @Override
    public void resetState() {
    }

    @Override
    public List<Matrix> getParameters() {
        ArrayList<Matrix> result = new ArrayList<Matrix>();
        result.add(this.W);
        result.add(this.b);
        return result;
    }
}

