/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.io;

import java.util.ArrayList;
import java.util.List;
import org.jlab.hipo.io.HipoByteUtils;
import org.jlab.hipo.io.HipoHeader;

public class HipoRecordIndex {
    long recordPosition = 0L;
    int recordLength = 0;
    boolean recordCompression = false;
    int numberofevents = 0;
    List<Integer> eventOffsets = new ArrayList<Integer>();

    public HipoRecordIndex(long offset) {
        this.recordPosition = offset;
    }

    public List<Integer> getEventIdex() {
        return this.eventOffsets;
    }

    public boolean parseHeader(int hL, int hM, int hH) {
        if (hL != HipoHeader.RECORD_ID_STRING) {
            return false;
        }
        this.recordLength = HipoByteUtils.read(hH, HipoHeader.LOWBYTE_RECORD_SIZE, HipoHeader.HIGHBYTE_RECORD_SIZE);
        this.numberofevents = HipoByteUtils.read(hM, HipoHeader.LOWBYTE_RECORD_EVENTCOUNT, HipoHeader.HIGHBYTE_RECORD_EVENTCOUNT);
        return true;
    }

    public int getNumberOfEvents() {
        return this.numberofevents;
    }

    public long getEventPosition(int index) {
        return this.recordPosition + (long)this.eventOffsets.get(index).intValue() + (long)HipoHeader.RECORD_HEADER_SIZE;
    }

    public long getPosition() {
        return this.recordPosition;
    }

    public void setCompression(boolean isc) {
        this.recordCompression = isc;
    }

    public boolean getCompression() {
        return this.recordCompression;
    }

    public void setLength(int len) {
        this.recordLength = len;
    }

    public int getLength() {
        return this.recordLength;
    }

    public String toString() {
        Boolean compression = this.getCompression();
        StringBuilder str = new StringBuilder();
        str.append(String.format("[BREC] [ %6s ]  OFFSET = %16d :  LENGTH = %14d : NEVENTS = %14d ", compression.toString(), this.getPosition(), this.getLength(), this.getNumberOfEvents()));
        return str.toString();
    }
}

