/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.jlab.hipo.io.HipoByteUtils;
import org.jlab.hipo.io.HipoRecordHeader;

public class HipoRecord {
    int headerL = 0;
    int headerM = 0;
    int headerH = 0;
    int headerC = 0;
    boolean isEditable = true;
    private List<Integer> recordIndex = new ArrayList<Integer>();
    private List<byte[]> recordEvents = new ArrayList<byte[]>();
    private int compressionType = 0;
    private HipoRecordHeader recordHeader = new HipoRecordHeader();
    private Integer recordBytesWritten = 0;

    public HipoRecord() {
        this.reset();
        this.recordHeader.reset();
    }

    public HipoRecord(byte[] array) {
        this.initFromBinary(array);
    }

    public final void reset() {
        this.recordIndex.clear();
        this.recordEvents.clear();
        this.recordHeader.reset();
        this.recordBytesWritten = 0;
    }

    public void addEvent(byte[] array) {
        int eventLength = array.length;
        this.recordEvents.add(array);
        this.recordHeader.setNumberOfEvents(this.recordEvents.size());
        this.recordBytesWritten = this.recordBytesWritten + eventLength;
    }

    public int getBytesWritten() {
        return this.recordBytesWritten;
    }

    public ByteBuffer build() {
        int totalSize = this.recordHeader.getRecordHeaderLength();
        int eventsSize = this.getDataBytesSize();
        this.recordHeader.setDataSize(eventsSize);
        byte[] eventBytes = this.buildDataBytes();
        byte[] indexBytes = this.buildIndexBytes();
        totalSize += indexBytes.length;
        this.recordHeader.setRecordSize(totalSize += eventBytes.length);
        this.recordHeader.setDataSizeCompressed(eventBytes.length);
        this.recordHeader.setCompressionType(this.compressionType);
        this.recordHeader.setIndexArraySize(indexBytes.length);
        byte[] buffer = new byte[totalSize];
        System.arraycopy(this.recordHeader.getRecordHeaderData(), 0, buffer, 0, this.recordHeader.getRecordHeaderLength());
        System.arraycopy(indexBytes, 0, buffer, this.recordHeader.getRecordHeaderLength() + this.recordHeader.getHeaderSize(), indexBytes.length);
        int position = this.recordHeader.getRecordHeaderLength() + this.recordHeader.getHeaderSize() + indexBytes.length;
        System.arraycopy(eventBytes, 0, buffer, position, eventBytes.length);
        ByteBuffer nioBuffer = ByteBuffer.wrap(buffer);
        nioBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return nioBuffer;
    }

    public void setCompressionType(int type) {
        this.compressionType = type;
        if (this.compressionType == 0) {
            this.recordHeader.setCompressionType(0);
            return;
        }
        if (this.compressionType > 0 && this.compressionType < 4) {
            this.recordHeader.setCompressionType(type);
        } else {
            System.out.println("[HipoRecord::compression] -----> unknown  compression type " + type + " use 1 - for GZIP and 2 - for LZ4.");
            this.compressionType = 0;
            this.recordHeader.setCompressionType(0);
        }
    }

    private void initFromBinary(byte[] binary) {
        int type;
        this.reset();
        byte[] header = new byte[40];
        System.arraycopy(binary, 0, header, 0, 40);
        this.recordHeader.initBinary(header);
        if (!this.recordHeader.isValid()) {
            System.out.println("[HipoRecord::initBinary] ---> error : something went wrong with a record.");
            System.out.println(this.recordHeader.toString());
            return;
        }
        int indexPosition = this.recordHeader.getRecordHeaderLength() + this.recordHeader.getHeaderSize();
        int indexSize = this.recordHeader.getIndexArraySize();
        byte[] indexBytes = new byte[indexSize];
        System.arraycopy(binary, indexPosition, indexBytes, 0, indexBytes.length);
        ByteBuffer indexBuffer = ByteBuffer.wrap(indexBytes);
        indexBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < indexSize; i += 4) {
            Integer index = indexBuffer.getInt(i);
            indexList.add(index);
        }
        int dataPosition = indexPosition + indexSize;
        int compressedSize = this.recordHeader.getDataSizeCompressed();
        this.compressionType = type = this.recordHeader.getCompressionType();
        byte[] dataBytesCompressed = new byte[compressedSize];
        System.arraycopy(binary, dataPosition, dataBytesCompressed, 0, dataBytesCompressed.length);
        byte[] dataBytes = null;
        if (type == 0) {
            dataBytes = dataBytesCompressed;
        } else if (type == 1) {
            dataBytes = HipoByteUtils.ungzip(dataBytesCompressed);
        } else if (type == 2 || type == 3) {
            int uncompressedSize = this.recordHeader.getDataSize();
            dataBytes = new byte[uncompressedSize];
            HipoByteUtils.uncompressLZ4(dataBytesCompressed, dataBytes);
        }
        int eventPosition = 0;
        for (int i = 0; i < indexList.size(); ++i) {
            byte[] event = new byte[((Integer)indexList.get(i)).intValue()];
            System.arraycopy(dataBytes, eventPosition, event, 0, event.length);
            this.addEvent(event);
            eventPosition += ((Integer)indexList.get(i)).intValue();
        }
    }

    public int getDataBytesSize() {
        int size = 0;
        for (byte[] array : this.recordEvents) {
            size += array.length;
        }
        return size;
    }

    public byte[] buildIndexBytes() {
        int indexSize = 4 * this.recordEvents.size();
        byte[] indexBytes = new byte[indexSize];
        ByteBuffer buffer = ByteBuffer.wrap(indexBytes);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < this.recordEvents.size(); ++i) {
            buffer.putInt(i * 4, this.recordEvents.get(i).length);
        }
        return buffer.array();
    }

    public byte[] buildDataBytes() {
        int size = this.getDataBytesSize();
        byte[] dataBytes = new byte[size];
        int position = 0;
        for (int i = 0; i < this.recordEvents.size(); ++i) {
            int len = this.recordEvents.get(i).length;
            System.arraycopy(this.recordEvents.get(i), 0, dataBytes, position, len);
            position += len;
        }
        if (this.compressionType > 0) {
            if (this.compressionType == 1) {
                byte[] dataBytesCompressed = HipoByteUtils.gzip(dataBytes);
                return dataBytesCompressed;
            }
            if (this.compressionType == 2) {
                byte[] dataBytesCompressed = HipoByteUtils.compressLZ4(dataBytes);
                return dataBytesCompressed;
            }
            if (this.compressionType == 3) {
                byte[] dataBytesCompressed = HipoByteUtils.compressLZ4max(dataBytes);
                return dataBytesCompressed;
            }
        }
        return dataBytes;
    }

    public int getEventCount() {
        return this.recordEvents.size();
    }

    public byte[] getEvent(int index) {
        return this.recordEvents.get(index);
    }

    public void show() {
        System.out.println(this.recordHeader.toString());
        for (int i = 0; i < this.recordEvents.size(); ++i) {
            System.out.println(String.format("\t %3d : SIZE = %8d", i, this.recordEvents.get(i).length));
        }
    }

    public boolean compressed() {
        return this.recordHeader.getCompressionType() > 0;
    }

    public static void main(String[] args) {
        HipoRecord record = new HipoRecord();
        record.addEvent(HipoByteUtils.generateByteArray(2250));
        record.addEvent(HipoByteUtils.generateByteArray(5580));
        record.addEvent(HipoByteUtils.generateByteArray(4580));
        record.addEvent(HipoByteUtils.generateByteArray(7962));
        record.setCompressionType(2);
        ByteBuffer buffer = record.build();
        record.show();
        HipoRecord restored = new HipoRecord(buffer.array());
        restored.show();
    }
}

