/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jlab.hipo.data.HipoEvent;
import org.jlab.hipo.io.HipoFileHeader;
import org.jlab.hipo.io.HipoFileInfo;
import org.jlab.hipo.io.HipoRecord;
import org.jlab.hipo.io.HipoRecordHeader;
import org.jlab.hipo.io.HipoRecordIndex;
import org.jlab.hipo.schema.SchemaFactory;

public class HipoReader {
    FileInputStream inputStream = null;
    List<Long> recordList = new ArrayList<Long>();
    List<Long> recordLength = new ArrayList<Long>();
    List<HipoRecordIndex> corruptedRecords = new ArrayList<HipoRecordIndex>();
    int debugMode = 0;
    List<HipoRecordHeader> readerRecords = new ArrayList<HipoRecordHeader>();
    private final SchemaFactory schemaFactory = new SchemaFactory();
    long timeSpendOnIndexing = 0L;
    long timeSpendOnReading = 0L;
    long timeSpendOnInflating = 0L;
    private HipoFileInfo fileInfo = new HipoFileInfo();
    private int readerCurrentRecord = -1;
    private int readerCurrentRecordLength = 0;
    private int readerCurrentEvent = 0;
    private int numberOfEventsInFile = 0;
    private HipoRecord headerRecord = null;
    private HipoRecord readerRecord = null;

    public void open(InputStream inStream) {
    }

    private List<HipoRecordHeader> readRecordIndex(InputStream stream) {
        try {
            byte[] fileHeader = new byte[72];
            stream.read(fileHeader);
            HipoFileHeader header = new HipoFileHeader(fileHeader);
            System.out.println(header.toString());
        }
        catch (IOException ex) {
            Logger.getLogger(HipoReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public void open(String name) {
        if (this.debugMode > 0) {
            System.out.println("[bio-reader] ---> openning file : " + name);
        }
        try {
            this.inputStream = new FileInputStream(new File(name));
            this.fileInfo.clear();
            this.readRecordIndex(this.readerRecords);
            this.initSchemaFactory();
            this.fileInfo.reset();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(HipoReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.debugMode > 0) {
            System.out.println();
            System.out.println("[hipo-reader] ---> recovered records : " + this.readerRecords.size() + " # events = " + this.numberOfEventsInFile);
            System.out.println();
        }
    }

    private void initSchemaFactory() {
        if (this.headerRecord != null) {
            for (int i = 0; i < this.headerRecord.getEventCount(); ++i) {
                byte[] buffer = this.headerRecord.getEvent(i);
                HipoEvent event = new HipoEvent(buffer);
                this.schemaFactory.setFromEvent(event);
            }
        }
    }

    public SchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    public void readRecordIndex(List<HipoRecordHeader> index) {
        byte[] fileHeader = new byte[72];
        long firstRecordOffset = 0L;
        int headerLength = 0;
        try {
            this.inputStream.read(fileHeader);
            HipoFileHeader header = new HipoFileHeader(fileHeader);
            int identifier = header.getIdentifier();
            int sizeWord = header.getHeaderSize();
            if (identifier == 1330661704) {
                firstRecordOffset = header.getRecordStart();
                headerLength = header.getHeaderSize();
                if (sizeWord > 40) {
                    byte[] fh = new byte[sizeWord];
                    this.inputStream.getChannel().position(72L);
                    this.inputStream.read(fh);
                    this.headerRecord = new HipoRecord(fh);
                }
            } else {
                System.out.println("[bio-reader] ---> errors. the provided file is not HIPO format.");
                return;
            }
            System.out.println("[hipo-reader] ---> header record is read successfully : # events = " + this.headerRecord.getEventCount());
        }
        catch (IOException ex) {
            Logger.getLogger(HipoReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.debugMode > 4) {
            System.out.println("[debug][read-index] ---->  first record index = " + firstRecordOffset);
            System.out.println("[debug][read-index] ---->  file header length = " + headerLength);
        }
        long stime_indexing = System.currentTimeMillis();
        index.clear();
        try {
            this.inputStream.getChannel().position(firstRecordOffset);
            int nread = 1;
            Object ib = null;
            while (nread > 0) {
                byte[] recordHeader = new byte[40];
                nread = this.inputStream.read(recordHeader);
                if (nread <= 0) continue;
                HipoRecordHeader record = new HipoRecordHeader(recordHeader);
                if (record.isValid()) {
                    record.setPositionInFile(firstRecordOffset);
                    this.readerRecords.add(record);
                    this.fileInfo.addRecord(record);
                    firstRecordOffset += (long)record.getRecordSize();
                    long skip = record.getRecordSize() - 40;
                    this.inputStream.skip(skip);
                    continue;
                }
                System.out.println(" invalid record at : " + firstRecordOffset);
                return;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(HipoReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        long etime_indexing = System.currentTimeMillis();
        this.timeSpendOnIndexing = etime_indexing - stime_indexing;
        this.numberOfEventsInFile = 0;
        System.out.println("Number of records recovered = " + this.readerRecords.size());
        for (HipoRecordHeader ri : this.readerRecords) {
            if (this.debugMode > 0) {
                System.out.println(ri.toString());
            }
            this.numberOfEventsInFile += ri.getNumberOfEvents();
        }
    }

    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException ex) {
            Logger.getLogger(HipoReader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private int getRecordByEvent(int event) {
        int nevents = 0;
        int icount = 0;
        for (HipoRecordHeader ri : this.readerRecords) {
            if ((nevents += ri.getNumberOfEvents()) > event) {
                return icount;
            }
            ++icount;
        }
        return -1;
    }

    private int getEventOffsetInRecord(int event) {
        int nevents = 0;
        int icount = 0;
        for (HipoRecordHeader ri : this.readerRecords) {
            if (nevents + ri.getNumberOfEvents() > event) {
                return event - nevents;
            }
            nevents += ri.getNumberOfEvents();
            ++icount;
        }
        return -1;
    }

    public HipoEvent readHipoEvent(int pos) {
        byte[] buffer = this.readEvent(pos);
        if (buffer == null) {
            return new HipoEvent(this.schemaFactory);
        }
        HipoEvent event = new HipoEvent(buffer, this.schemaFactory);
        return event;
    }

    public HipoFileInfo getFileInfo() {
        return this.fileInfo;
    }

    public byte[] readEvent(int pos) {
        byte[] eventBytes = null;
        int eventRecord = 0;
        int eventOffset = 0;
        try {
            this.fileInfo.setEvent(pos);
            eventRecord = this.fileInfo.getRecord();
            eventOffset = this.fileInfo.getEventOffset();
            if (eventRecord != this.readerCurrentRecord) {
                this.readerRecord = this.readRecord(eventRecord);
                this.readerCurrentRecord = eventRecord;
            }
            eventBytes = this.readerRecord.getEvent(eventOffset);
        }
        catch (Exception e) {
            System.out.println(" ERROR READING ENTRY :  " + eventOffset + " FROM RECORD : " + eventRecord);
            return null;
        }
        return eventBytes;
    }

    public int getEventCount() {
        return this.numberOfEventsInFile;
    }

    public int getPosition() {
        return this.readerCurrentEvent;
    }

    public void show() {
        for (int i = 0; i < this.readerRecords.size(); ++i) {
            System.out.println(String.format(" %5d : %s", i, this.readerRecords.get(i).toString()));
        }
    }

    public void showHeader() {
        HipoRecord header = this.readRecord(0);
        int nevents = header.getEventCount();
        for (int ev = 0; ev < nevents; ++ev) {
            byte[] buffer = header.getEvent(ev);
            String descriptor = new String(buffer);
            System.out.println(String.format("%5d : %s", ev, descriptor));
        }
    }

    public String getStatusString() {
        StringBuilder str = new StringBuilder();
        double time = (double)this.timeSpendOnIndexing / 1000.0;
        double timer = (double)this.timeSpendOnReading / 1000.0;
        double timei = (double)this.timeSpendOnInflating / 1000.0;
        str.append(String.format("[BIO-READER]  NRECORDS = %8d, ", this.readerRecords.size()));
        str.append(String.format(" INDEXING = %7.3f sec", time));
        str.append(String.format(" READING = %7.3f sec", timer));
        str.append(String.format(" INFLATING = %7.3f sec", timei));
        return str.toString();
    }

    public int getRecordCount() {
        return this.readerRecords.size();
    }

    public HipoRecord getHeaderRecord() {
        return this.headerRecord;
    }

    public HipoRecord readRecord(int record) {
        try {
            long record_offset = this.readerRecords.get(record).getPositionInFile();
            long record_length = this.readerRecords.get(record).getRecordSize();
            long record_nindex = this.readerRecords.get(record).getNumberOfEvents();
            this.inputStream.getChannel().position(record_offset);
            byte[] buffer = new byte[(int)record_length];
            long stime_reading = System.currentTimeMillis();
            int bytes_read = this.inputStream.read(buffer);
            long etime_reading = System.currentTimeMillis();
            this.timeSpendOnReading += etime_reading - stime_reading;
            stime_reading = System.currentTimeMillis();
            HipoRecord newRecord = new HipoRecord(buffer);
            etime_reading = System.currentTimeMillis();
            this.timeSpendOnInflating += etime_reading - stime_reading;
            return newRecord;
        }
        catch (IOException ex) {
            Logger.getLogger(HipoReader.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static void main(String[] args) {
        HipoReader reader = new HipoReader();
        reader.open("testfile.hipo");
        reader.show();
        int nrecs = reader.getRecordCount();
        for (int i = 0; i < nrecs; ++i) {
            HipoRecord rec = reader.readRecord(i);
            for (int k = 0; k < rec.getEventCount(); ++k) {
                byte[] byArray = rec.getEvent(k);
            }
        }
    }
}

