/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class HipoFileHeader {
    public static final int FILE_HEADER_LENGTH = 72;
    public static final int FILE_IDENTIFIER = 1330661704;
    public static final int FILE_VERSION = 825110614;
    public static final int OFFSET_FILE_SIZE = 8;
    public static final int OFFSET_FILE_HEADER_SIZE = 12;
    public static final byte[] HIPO_FILE_SIGNATURE_BYTES = new byte[]{72, 73, 80, 79, 86, 48, 46, 50};
    private ByteBuffer fileHeader = null;
    private Boolean isHeaderValid = false;

    public HipoFileHeader() {
        byte[] header = new byte[72];
        this.fileHeader = ByteBuffer.wrap(header);
        this.fileHeader.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < 8; ++i) {
            this.fileHeader.put(i, HIPO_FILE_SIGNATURE_BYTES[i]);
        }
        this.setHeaderSize(0);
        this.isHeaderValid = true;
    }

    public HipoFileHeader(byte[] header) {
        this.fileHeader = ByteBuffer.wrap(header);
        this.fileHeader.order(ByteOrder.LITTLE_ENDIAN);
        this.isHeaderValid = true;
        if (this.fileHeader.getInt(0) != 1330661704) {
            System.out.println("[Hipo-File] ---> error : this is not a HIPO File.");
            this.isHeaderValid = false;
        }
    }

    public int getRecordStart() {
        return 72 + this.getHeaderSize();
    }

    public boolean isValid() {
        return this.isHeaderValid;
    }

    public int getHeaderSize() {
        int headerSize = this.fileHeader.getInt(12);
        return headerSize;
    }

    public int getIdentifier() {
        return this.fileHeader.getInt(0);
    }

    public int getVersion() {
        return this.fileHeader.getInt(4);
    }

    public int getHeaderStart() {
        return 72;
    }

    public final void setHeaderSize(int size) {
        this.fileHeader.putInt(12, size);
    }

    public ByteBuffer build() {
        return this.fileHeader;
    }
}

