/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jlab.groot.tree.Tree;
import org.jlab.groot.tree.TreeTextFile;

public class TreeEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    Tree tree;
    JTable table;
    int maxNColumns = 15;
    int maxNRows = 1000;

    public TreeEditor(Tree tree) {
        this.tree = tree;
        this.init();
    }

    public void setMaxColumns(int cols) {
        this.maxNColumns = cols;
        this.init();
    }

    public void setMaxRows(int rows) {
        this.maxNRows = rows;
        this.init();
    }

    private void init() {
        this.table = new JTable();
        this.table.setFillsViewportHeight(true);
        DefaultTableModel dataModel = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;
            List<String> branches;
            {
                this.branches = TreeEditor.this.tree.getListOfBranches();
            }

            @Override
            public int getColumnCount() {
                if (TreeEditor.this.tree.getListOfBranches().size() < TreeEditor.this.maxNColumns) {
                    return TreeEditor.this.tree.getListOfBranches().size();
                }
                return TreeEditor.this.maxNColumns;
            }

            @Override
            public int getRowCount() {
                if (TreeEditor.this.tree.getEntries() < TreeEditor.this.maxNRows) {
                    return TreeEditor.this.tree.getEntries();
                }
                return TreeEditor.this.maxNRows;
            }

            @Override
            public Object getValueAt(int row, int col) {
                TreeEditor.this.tree.readEntry(row);
                return TreeEditor.this.tree.getBranch(this.branches.get(col)).getValue().toString();
            }

            @Override
            public String getColumnName(int index) {
                return this.branches.get(index);
            }
        };
        this.table.setModel(dataModel);
        JScrollPane scrollPane = new JScrollPane(this.table);
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)scrollPane, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)tablePanel, "Center");
    }

    public static void main(String[] args) {
        TreeTextFile tree = new TreeTextFile("T");
        tree.readFile("/Users/wphelps/Desktop/GROOTTree/pp_10k.txt");
        System.out.println(" entries = " + tree.getEntries());
        for (int i = 0; i < 10; ++i) {
            tree.readEntry(i);
            tree.print();
        }
        JFrame frame = new JFrame("Test");
        TreeEditor editor = new TreeEditor(tree);
        frame.add(editor);
        frame.pack();
        frame.setVisible(true);
    }
}

