/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.tree;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jlab.groot.tree.DynamicTree;
import org.jlab.groot.tree.Tree;
import org.jlab.groot.tree.TreeCut;

public class TreeSelector {
    Map<String, TreeCut> treeCuts = new LinkedHashMap<String, TreeCut>();
    DynamicTree tree = new DynamicTree("Cuts");

    public DynamicTree getTree() {
        return this.tree;
    }

    public void setTree(DynamicTree tree) {
        this.tree = tree;
    }

    public void addCut(String name, String expression, List<String> branches) {
        this.treeCuts.put(name, new TreeCut(name, expression, branches));
        this.tree.addObject(name);
    }

    public void addCut(TreeCut cut) {
        this.treeCuts.put(cut.getName(), cut);
        this.tree.addObject(cut.getName());
    }

    public TreeCut getCut(String cut) {
        return this.treeCuts.get(cut);
    }

    public double isValid(Tree tree) {
        double weight = 1.0;
        for (Map.Entry<String, TreeCut> entry : this.treeCuts.entrySet()) {
            if (!entry.getValue().isActive()) continue;
            weight *= entry.getValue().isValid(tree);
        }
        return weight;
    }

    public Map<String, Double> getCuts(Tree tree) {
        LinkedHashMap<String, Double> cuts = new LinkedHashMap<String, Double>();
        for (Map.Entry<String, TreeCut> entry : this.treeCuts.entrySet()) {
            if (entry.getValue().isActive()) {
                cuts.put(entry.getKey(), entry.getValue().isValid(tree));
                continue;
            }
            cuts.put(entry.getKey(), 1.0);
        }
        return cuts;
    }

    public Map<String, TreeCut> getSelectorCuts() {
        return this.treeCuts;
    }

    public void reset() {
        this.treeCuts.clear();
    }
}

