/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.tree;

import java.util.ArrayList;
import java.util.List;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.operator.Operator;
import org.jlab.groot.tree.ITree;

public class TreeCut {
    String cutName = "";
    String cutExpression = "";
    List<String> cutVariables = new ArrayList<String>();
    Expression expr = null;
    private boolean isCutActive = true;
    static Operator operatorGT = new Operator(">", 2, true, 1000){

        @Override
        public double apply(double ... args) {
            if (args[0] > args[1]) {
                return 1.0;
            }
            return 0.0;
        }
    };
    static Operator operatorLT = new Operator("<", 2, true, 1000){

        @Override
        public double apply(double ... args) {
            if (args[0] < args[1]) {
                return 1.0;
            }
            return 0.0;
        }
    };
    static Operator operatorEQ = new Operator("==", 2, true, 1000){

        @Override
        public double apply(double ... args) {
            if (args[0] == args[1]) {
                return 1.0;
            }
            return 0.0;
        }
    };
    static Operator operatorAND = new Operator("&&", 2, true, 500){

        @Override
        public double apply(double ... args) {
            if (args[0] > 0.0 && args[1] > 0.0) {
                return 1.0;
            }
            return 0.0;
        }
    };
    static Operator operatorOR = new Operator("||", 2, true, 500){

        @Override
        public double apply(double ... args) {
            if (args[0] > 0.0 || args[1] > 0.0) {
                return 1.0;
            }
            return 0.0;
        }
    };

    public ArrayList<String> getBranches() {
        return (ArrayList)this.cutVariables;
    }

    public static boolean validateExpression(String expression, List<String> branches) {
        if (expression.isEmpty()) {
            return false;
        }
        String[] variables = new String[branches.size()];
        for (int i = 0; i < branches.size(); ++i) {
            variables[i] = branches.get(i);
        }
        ExpressionBuilder builder = new ExpressionBuilder(expression).operator(operatorAND).operator(operatorOR).operator(operatorGT).operator(operatorLT).operator(operatorEQ);
        builder.variables(variables);
        try {
            Expression expression2 = builder.build();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public TreeCut(String name, String exp, List<String> branches) {
        this.cutName = name;
        this.cutExpression = exp;
        this.cutVariables.clear();
        for (String br : branches) {
            this.cutVariables.add(br);
        }
        this.init();
    }

    public boolean isActive() {
        return this.isCutActive;
    }

    public void setActive(boolean activeFlag) {
        this.isCutActive = activeFlag;
    }

    public String getName() {
        return this.cutName;
    }

    public String getExpression() {
        return this.cutExpression;
    }

    public void setExpression(String expression) {
        this.cutExpression = expression;
        this.init();
    }

    public void setName(String name) {
        this.cutName = name;
    }

    final void init() {
        String[] variables = new String[this.cutVariables.size()];
        for (int i = 0; i < variables.length; ++i) {
            variables[i] = this.cutVariables.get(i);
        }
        if (this.cutExpression.length() > 0) {
            ExpressionBuilder builder = new ExpressionBuilder(this.cutExpression).operator(operatorAND).operator(operatorOR).operator(operatorGT).operator(operatorLT).operator(operatorEQ);
            builder.variables(variables);
            this.expr = builder.build();
        }
    }

    public double isValid(ITree tree) {
        if (this.expr != null) {
            for (int i = 0; i < this.cutVariables.size(); ++i) {
                this.expr.setVariable(this.cutVariables.get(i), tree.getBranch(this.cutVariables.get(i)).getValue().doubleValue());
            }
            double result = this.expr.evaluate();
            return result;
        }
        if (this.getExpression() == "") {
            return 1.0;
        }
        return 0.0;
    }
}

