/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.tree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import org.jlab.groot.data.GraphErrors;
import org.jlab.groot.data.H1F;
import org.jlab.groot.data.H2F;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.tree.AbstractDescriptor;
import org.jlab.groot.tree.ITree;
import org.jlab.groot.tree.Tree;
import org.jlab.groot.tree.TreeCut;
import org.jlab.groot.tree.TreeExpression;

public class DatasetDescriptor
extends AbstractDescriptor {
    public static int DESCRIPTOR_H1 = 1;
    public static int DESCRIPTOR_H2 = 2;
    public static int DESCRIPTOR_GRXY_XY = 3;
    public static int DESCRIPTOR_GRXY_XY_EY = 4;
    public static int DESCRIPTOR_GRXY_XY_EX_EY = 5;
    String descName = "Dataset Name";
    List<IDataSet> descDataset = new ArrayList<IDataSet>();
    List<TreeCut> treeCuts = new ArrayList<TreeCut>();
    List<TreeExpression> treeExpressions = new ArrayList<TreeExpression>();
    private int descriptorType = 0;
    String expressionX = "";
    String expressionY = "";
    String expressionXerr = "";
    String expressionYerr = "";
    int nbinsX = 100;
    double minX = 0.0;
    double maxX = 1.0;
    int nbinsY = 100;
    double minY = 0.0;
    double maxY = 1.0;

    public DatasetDescriptor(String name, int type) {
        this.descName = name;
        this.descriptorType = type;
        GraphErrors graph = new GraphErrors(name);
        this.descDataset.add(graph);
    }

    public DatasetDescriptor(String name, int nbins, double min, double max, String exp, ITree tree) {
        this.descName = name;
        this.setExpression(exp, tree);
        this.nbinsX = nbins;
        this.minX = min;
        this.maxX = max;
        this.expressionX = exp;
        this.initDatasets();
    }

    public DatasetDescriptor(String name, int nbinsX, double minX, double maxX, int nbinsY, double minY, double maxY, String exp, ITree tree) {
        this.descName = name;
        this.setExpression(exp, tree);
        this.nbinsX = nbinsX;
        this.minX = minX;
        this.maxX = maxX;
        this.nbinsY = nbinsY;
        this.minY = minY;
        this.maxY = maxY;
        if (this.treeExpressions.size() == 2) {
            this.expressionX = this.treeExpressions.get((int)0).treeExpression;
            this.expressionY = this.treeExpressions.get((int)1).treeExpression;
        } else {
            this.expressionX = exp;
        }
        this.initDatasets();
    }

    public DatasetDescriptor(String name, String exp, ITree tree) {
        this.descName = name;
        this.setExpression(exp, tree);
        if (this.treeExpressions.size() == 2) {
            this.descriptorType = DESCRIPTOR_GRXY_XY;
            this.expressionX = this.treeExpressions.get((int)0).treeExpression;
            this.expressionY = this.treeExpressions.get((int)1).treeExpression;
        }
        if (this.treeExpressions.size() == 3) {
            this.descriptorType = DESCRIPTOR_GRXY_XY_EY;
            this.expressionX = this.treeExpressions.get((int)0).treeExpression;
            this.expressionY = this.treeExpressions.get((int)1).treeExpression;
            this.expressionYerr = this.treeExpressions.get((int)2).treeExpression;
        }
        if (this.treeExpressions.size() == 4) {
            this.descriptorType = DESCRIPTOR_GRXY_XY_EX_EY;
            this.expressionX = this.treeExpressions.get((int)0).treeExpression;
            this.expressionY = this.treeExpressions.get((int)1).treeExpression;
            this.expressionXerr = this.treeExpressions.get((int)2).treeExpression;
            this.expressionYerr = this.treeExpressions.get((int)3).treeExpression;
        }
        GraphErrors graph = new GraphErrors(name);
        this.descDataset.add(graph);
    }

    public final void setExpression(String expressions, ITree tree) {
        String[] tokens = expressions.split(":");
        this.treeExpressions.clear();
        for (String item : tokens) {
            try {
                TreeExpression exp = new TreeExpression(item, tree.getListOfBranches());
                this.treeExpressions.add(exp);
            }
            catch (Exception e) {
                System.out.println("ERROR : parsing expression [" + item + "]");
            }
        }
        int nexp = this.treeExpressions.size();
        switch (nexp) {
            case 1: {
                this.descriptorType = DESCRIPTOR_H1;
                this.expressionX = this.treeExpressions.get((int)0).treeExpression;
                break;
            }
            case 2: {
                this.descriptorType = DESCRIPTOR_H2;
                this.expressionX = this.treeExpressions.get((int)0).treeExpression;
                this.expressionY = this.treeExpressions.get((int)1).treeExpression;
                break;
            }
            case 3: {
                this.descriptorType = DESCRIPTOR_GRXY_XY_EY;
                this.expressionX = this.treeExpressions.get((int)0).treeExpression;
                this.expressionY = this.treeExpressions.get((int)1).treeExpression;
                this.expressionYerr = this.treeExpressions.get((int)2).treeExpression;
                break;
            }
            case 4: {
                this.descriptorType = DESCRIPTOR_GRXY_XY_EX_EY;
                this.expressionX = this.treeExpressions.get((int)0).treeExpression;
                this.expressionY = this.treeExpressions.get((int)1).treeExpression;
                this.expressionXerr = this.treeExpressions.get((int)2).treeExpression;
                this.expressionYerr = this.treeExpressions.get((int)3).treeExpression;
                break;
            }
            default: {
                this.descriptorType = 0;
            }
        }
    }

    public void addCut(String name, String cutExp, ITree tree) {
        TreeCut cut = new TreeCut(name, cutExp, tree.getListOfBranches());
    }

    public void addCut(TreeCut cut) {
        this.treeCuts.add(cut);
    }

    public void fill(ITree tree) {
        double y;
        double eventWeight = 1.0;
        boolean cutsPassed = true;
        for (TreeCut cut : this.treeCuts) {
            eventWeight *= cut.isValid(tree);
        }
        if (this.descriptorType == DESCRIPTOR_H1) {
            double value = this.treeExpressions.get(0).getValue(tree);
            H1F h1 = (H1F)this.descDataset.get(0);
            h1.fill(value, eventWeight);
            return;
        }
        if (this.descriptorType == DESCRIPTOR_H2) {
            double valueX = this.treeExpressions.get(0).getValue(tree);
            double valueY = this.treeExpressions.get(1).getValue(tree);
            H2F h2 = (H2F)this.descDataset.get(0);
            h2.fill(valueX, valueY, eventWeight);
            return;
        }
        if (this.descriptorType == DESCRIPTOR_GRXY_XY) {
            double x = this.treeExpressions.get(0).getValue(tree);
            y = this.treeExpressions.get(1).getValue(tree);
            GraphErrors graph = (GraphErrors)this.descDataset.get(0);
            if (eventWeight > 0.0) {
                graph.addPoint(x, y, 0.0, 0.0);
            }
        }
        if (this.descriptorType == DESCRIPTOR_GRXY_XY_EY) {
            double x = this.treeExpressions.get(0).getValue(tree);
            y = this.treeExpressions.get(1).getValue(tree);
            double ey = this.treeExpressions.get(2).getValue(tree);
            GraphErrors graph = (GraphErrors)this.descDataset.get(0);
            if (eventWeight > 0.0) {
                graph.addPoint(x, y, 0.0, ey);
            }
        }
        if (this.descriptorType == DESCRIPTOR_GRXY_XY_EX_EY) {
            double x = this.treeExpressions.get(0).getValue(tree);
            y = this.treeExpressions.get(1).getValue(tree);
            double ex = this.treeExpressions.get(2).getValue(tree);
            double ey = this.treeExpressions.get(3).getValue(tree);
            GraphErrors graph = (GraphErrors)this.descDataset.get(0);
            if (eventWeight > 0.0) {
                graph.addPoint(x, y, ex, ey);
            }
        }
    }

    public void initDatasets() {
        this.descDataset.clear();
        System.out.println("initDatasets Descriptortype " + this.descriptorType + " " + this.treeExpressions.size());
        if (this.descriptorType == DESCRIPTOR_H1 && this.treeExpressions.size() == 1) {
            H1F h1 = new H1F(this.descName, this.nbinsX, this.minX, this.maxX);
            this.descDataset.add(h1);
        }
        if (this.descriptorType == DESCRIPTOR_H2 && this.treeExpressions.size() == 2) {
            H2F h2 = new H2F(this.descName, this.nbinsX, this.minX, this.maxX, this.nbinsY, this.minY, this.maxY);
            this.descDataset.add(h2);
        }
        System.out.println("Initialized datasets:" + this.descDataset.size());
    }

    public IDataSet getDataSet() {
        return this.descDataset.get(0);
    }

    public String getDescName() {
        return this.descName;
    }

    public void setDescName(String descName) {
        this.descName = descName;
    }

    public List<IDataSet> getDescDataset() {
        return this.descDataset;
    }

    public void setDescDataset(List<IDataSet> descDataset) {
        this.descDataset = descDataset;
    }

    public List<TreeCut> getTreeCuts() {
        return this.treeCuts;
    }

    public void setTreeCuts(List<TreeCut> treeCuts) {
        this.treeCuts = treeCuts;
    }

    public List<TreeExpression> getTreeExpressions() {
        return this.treeExpressions;
    }

    public void setTreeExpressions(List<TreeExpression> treeExpressions) {
        this.treeExpressions = treeExpressions;
    }

    public int getDescriptorType() {
        return this.descriptorType;
    }

    public void setDescriptorType(int descriptorType) {
        this.descriptorType = descriptorType;
    }

    public String getExpressionX() {
        return this.expressionX;
    }

    public void setExpressionX(String expressionX) {
        this.expressionX = expressionX;
    }

    public String getExpressionY() {
        return this.expressionY;
    }

    public void setExpressionY(String expressionY) {
        this.expressionY = expressionY;
    }

    public String getExpressionXerr() {
        return this.expressionXerr;
    }

    public void setExpressionXerr(String expressionXerr) {
        this.expressionXerr = expressionXerr;
    }

    public String getExpressionYerr() {
        return this.expressionYerr;
    }

    public void setExpressionYerr(String expressionYerr) {
        this.expressionYerr = expressionYerr;
    }

    public int getNbinsX() {
        return this.nbinsX;
    }

    public void setNbinsX(int nbinsX) {
        this.nbinsX = nbinsX;
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public int getNbinsY() {
        return this.nbinsY;
    }

    public void setNbinsY(int nbinsY) {
        this.nbinsY = nbinsY;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    @Override
    public void processTreeEvent(Tree tree) {
        double y;
        double eventWeight = 1.0;
        boolean cutsPassed = true;
        for (TreeCut cut : this.treeCuts) {
            eventWeight *= cut.isValid(tree);
        }
        if (this.descriptorType == DESCRIPTOR_H1) {
            double value = this.treeExpressions.get(0).getValue(tree);
            H1F h1 = (H1F)this.descDataset.get(0);
            h1.fill(value, eventWeight);
            return;
        }
        if (this.descriptorType == DESCRIPTOR_H2) {
            double valueX = this.treeExpressions.get(0).getValue(tree);
            double valueY = this.treeExpressions.get(1).getValue(tree);
            H2F h2 = (H2F)this.descDataset.get(0);
            h2.fill(valueX, valueY, eventWeight);
            return;
        }
        if (this.descriptorType == DESCRIPTOR_GRXY_XY) {
            double x = this.treeExpressions.get(0).getValue(tree);
            y = this.treeExpressions.get(1).getValue(tree);
            GraphErrors graph = (GraphErrors)this.descDataset.get(0);
            if (eventWeight > 0.0) {
                graph.addPoint(x, y, 0.0, 0.0);
            }
        }
        if (this.descriptorType == DESCRIPTOR_GRXY_XY_EY) {
            double x = this.treeExpressions.get(0).getValue(tree);
            y = this.treeExpressions.get(1).getValue(tree);
            double ey = this.treeExpressions.get(2).getValue(tree);
            GraphErrors graph = (GraphErrors)this.descDataset.get(0);
            if (eventWeight > 0.0) {
                graph.addPoint(x, y, 0.0, ey);
            }
        }
        if (this.descriptorType == DESCRIPTOR_GRXY_XY_EX_EY) {
            double x = this.treeExpressions.get(0).getValue(tree);
            y = this.treeExpressions.get(1).getValue(tree);
            double ex = this.treeExpressions.get(2).getValue(tree);
            double ey = this.treeExpressions.get(3).getValue(tree);
            GraphErrors graph = (GraphErrors)this.descDataset.get(0);
            if (eventWeight > 0.0) {
                graph.addPoint(x, y, ex, ey);
            }
        }
    }

    @Override
    public JDialog edit(Tree tree) {
        return null;
    }

    public void clearCuts() {
        this.treeCuts.clear();
    }
}

