/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.studio;

import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jlab.groot.tree.Tree;

public class StudioToolBar {
    private int iconSizeX = 25;
    private int iconSizeY = 25;
    public JToggleButton fastButton;
    private JToolBar toolbar = null;
    Map<String, JButton> toolBarButtons = new HashMap<String, JButton>();

    public StudioToolBar(ActionListener listener) {
        this.init(listener);
    }

    private void init(ActionListener listener) {
        ImageIcon histogramIcon = new ImageIcon();
        ImageIcon cutIcon = new ImageIcon();
        ImageIcon grapherrorsIcon = new ImageIcon();
        ImageIcon playIcon = new ImageIcon();
        ImageIcon importIcon = new ImageIcon();
        ImageIcon fastIcon = new ImageIcon();
        ImageIcon operationIcon = new ImageIcon();
        ImageIcon editTreeIcon = new ImageIcon();
        try {
            BufferedImage graphErrorsImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/tree/grapherrors.png"));
            BufferedImage cutImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/tree/cut.png"));
            BufferedImage histogramImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/tree/histogram.png"));
            BufferedImage playImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/tree/play.png"));
            BufferedImage importImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/tree/import.png"));
            BufferedImage fastImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/tree/fast.png"));
            BufferedImage operationImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/tree/operations.png"));
            BufferedImage editTreeImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/tree/edit_tree.png"));
            grapherrorsIcon.setImage(graphErrorsImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
            cutIcon.setImage(cutImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
            histogramIcon.setImage(histogramImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
            playIcon.setImage(playImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
            importIcon.setImage(importImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
            fastIcon.setImage(fastImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
            operationIcon.setImage(operationImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
            editTreeIcon.setImage(editTreeImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
        }
        catch (IOException e) {
            System.out.println("Error: Could not load icons!");
            e.printStackTrace();
        }
        this.toolbar = new JToolBar();
        JButton histogramButton = new JButton(histogramIcon);
        JButton graphErrorsButton = new JButton(grapherrorsIcon);
        JButton cutButton = new JButton(cutIcon);
        JButton playButton = new JButton(playIcon);
        JButton importButton = new JButton(importIcon);
        this.fastButton = new JToggleButton(fastIcon);
        JButton operationButton = new JButton(operationIcon);
        JButton editTreeButton = new JButton(editTreeIcon);
        histogramButton.setToolTipText("Add Histogram");
        cutButton.setToolTipText("Add Cut");
        histogramButton.setActionCommand("Add Descriptor");
        cutButton.setActionCommand("Add Cut");
        graphErrorsButton.setActionCommand("Add GraphErrors");
        importButton.setActionCommand("Import ASCII");
        this.fastButton.setActionCommand("Preview Mode");
        playButton.setActionCommand("Play");
        operationButton.setActionCommand("Action Jack");
        editTreeButton.setActionCommand("Edit Tree");
        histogramButton.addActionListener(listener);
        cutButton.addActionListener(listener);
        graphErrorsButton.addActionListener(listener);
        importButton.addActionListener(listener);
        this.fastButton.addActionListener(listener);
        playButton.addActionListener(listener);
        operationButton.addActionListener(listener);
        editTreeButton.addActionListener(listener);
        this.toolbar.add(importButton);
        this.toolbar.addSeparator();
        this.toolbar.add(histogramButton);
        this.toolbar.add(graphErrorsButton);
        this.toolbar.add(cutButton);
        this.toolbar.add(operationButton);
        this.toolbar.addSeparator();
        this.toolbar.add(editTreeButton);
        this.toolbar.addSeparator();
        this.toolbar.add(playButton);
        this.toolbar.add(this.fastButton);
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }
}

