/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.math;

import java.util.ArrayList;
import java.util.List;
import org.jlab.groot.math.Dimension1D;

public class Dimension3D {
    private List<Dimension1D> dimensions = new ArrayList<Dimension1D>();

    public Dimension3D() {
        this.dimensions.add(new Dimension1D());
        this.dimensions.add(new Dimension1D());
        this.dimensions.add(new Dimension1D());
    }

    public final void set(double min1, double max1, double min2, double max2, double min3, double max3) {
        this.dimensions.get(0).setMinMax(min1, max1);
        this.dimensions.get(1).setMinMax(min2, max2);
        this.dimensions.get(2).setMinMax(min3, max3);
    }

    public Dimension1D getDimension(int index) {
        return this.dimensions.get(index);
    }

    public void grow(double x, double y, double z) {
        this.dimensions.get(0).grow(x);
        this.dimensions.get(1).grow(y);
        this.dimensions.get(2).grow(z);
    }

    public void grow(Dimension3D dim) {
        this.getDimension(0).grow(dim.getDimension(0).getMin());
        this.getDimension(0).grow(dim.getDimension(0).getMax());
        this.getDimension(1).grow(dim.getDimension(1).getMin());
        this.getDimension(1).grow(dim.getDimension(1).getMax());
        this.getDimension(2).grow(dim.getDimension(2).getMin());
        this.getDimension(2).grow(dim.getDimension(2).getMax());
    }

    public void copy(Dimension3D object) {
        this.set(object.getDimension(0).getMin(), object.getDimension(0).getMax(), object.getDimension(1).getMin(), object.getDimension(1).getMax(), object.getDimension(2).getMin(), object.getDimension(2).getMax());
    }

    public void combine(Dimension3D dim) {
        this.getDimension(0).grow(dim.getDimension(0).getMin());
        this.getDimension(0).grow(dim.getDimension(0).getMax());
        this.getDimension(1).grow(dim.getDimension(1).getMin());
        this.getDimension(1).grow(dim.getDimension(1).getMax());
        this.getDimension(2).grow(dim.getDimension(2).getMin());
        this.getDimension(2).grow(dim.getDimension(2).getMax());
    }

    public String toString() {
        return String.format("Dimension2D : (%8.3f - %8.3f) (%8.3f - %8.3f) (%8.3f - %8.3f)", this.dimensions.get(0).getMin(), this.dimensions.get(0).getMax(), this.dimensions.get(1).getMin(), this.dimensions.get(1).getMax(), this.dimensions.get(2).getMin(), this.dimensions.get(2).getMax());
    }
}

