/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.math;

import java.util.ArrayList;
import java.util.List;

public class Dimension1D
implements Cloneable {
    public final double SMALL_NUMBER = 1.0E-24;
    double dimMin = 0.0;
    double dimMax = 1.0;
    boolean isLog = false;

    public Dimension1D() {
    }

    public Dimension1D(double min, double max) {
        this.setMinMax(min, max);
    }

    public final void setMinMax(double min, double max) {
        this.dimMin = min;
        this.dimMax = max;
    }

    public double getMin() {
        return this.dimMin;
    }

    public boolean getLog() {
        return this.isLog;
    }

    public void setLog(boolean flag) {
        this.isLog = flag;
    }

    public double getMax() {
        return this.dimMax;
    }

    public Dimension1D clone() throws CloneNotSupportedException {
        return (Dimension1D)super.clone();
    }

    public void copy(Dimension1D dim) {
        this.setMinMax(dim.getMin(), dim.getMax());
    }

    public double getFraction(double point) {
        if (!this.isLog) {
            return (point - this.dimMin) / (this.dimMax - this.dimMin);
        }
        double min = this.dimMin;
        double datapoint = point;
        if (datapoint < 1.0E-24) {
            datapoint = 0.1;
        }
        if (min < 1.0E-24) {
            min = 0.1;
        }
        double distance = Math.log10(datapoint) - Math.log10(min);
        double frac = distance / this.length();
        return frac;
    }

    public double getPoint(double fraction) {
        if (this.isLog) {
            double axisMinimum = this.dimMin;
            if (axisMinimum < 1.0E-24) {
                axisMinimum = 0.1;
            }
            double orderMax = Math.log10(this.dimMax);
            double orderMin = Math.log10(axisMinimum);
            return orderMin + (orderMax - orderMin) * Math.log10(fraction);
        }
        return this.dimMin + (this.dimMax - this.dimMin) * fraction;
    }

    public double getLength() {
        return Math.abs(this.dimMax - this.dimMin);
    }

    public double convert(double x, Dimension1D dim) {
        double xf = dim.getFraction(x);
        return this.getPoint(xf);
    }

    public double length() {
        if (!this.isLog) {
            return this.dimMax - this.dimMin;
        }
        double min = this.dimMin;
        if (min < 1.0E-24) {
            min = 0.1;
        }
        return Math.log10(this.dimMax) - Math.log10(min);
    }

    public void grow(double point) {
        if (point < this.dimMin) {
            this.setMinMax(point, this.dimMax);
        } else if (point > this.dimMax) {
            this.setMinMax(this.dimMin, point);
        }
    }

    public List<Double> getDimensionTicks(int maxTicks) {
        ArrayList<Double> axisTicks = new ArrayList<Double>();
        double range = this.niceNum(this.dimMax - this.dimMin, false);
        double tickSpacing = this.niceNum(range / (double)(maxTicks - 1), true);
        double niceMin = Math.floor(this.dimMin / tickSpacing) * tickSpacing;
        double niceMax = Math.ceil(this.dimMax / tickSpacing) * tickSpacing;
        for (double numberX = niceMin; numberX <= this.dimMax; numberX += tickSpacing) {
            if (!(numberX >= this.dimMin) || !(numberX <= this.dimMax)) continue;
            axisTicks.add(numberX);
        }
        return axisTicks;
    }

    private List<Double> createTicks(int maxTicks, double min, double max) {
        ArrayList<Double> axisTicks = new ArrayList<Double>();
        double range = this.niceNum(max - min, false);
        double tickSpacing = this.niceNum(range / (double)(maxTicks - 1), true);
        double niceMin = Math.floor(min / tickSpacing) * tickSpacing;
        double niceMax = Math.ceil(max / tickSpacing) * tickSpacing;
        for (double numberX = niceMin; numberX <= max; numberX += tickSpacing) {
            if (!(numberX >= min) || !(numberX <= max)) continue;
            axisTicks.add(numberX);
        }
        return axisTicks;
    }

    public List<Double> getDimensionTicksLog(int maxTicks) {
        ArrayList<Double> ticks = new ArrayList<Double>();
        double axisMinimum = this.dimMin;
        if (axisMinimum < 1.0E-24) {
            axisMinimum = 0.1;
        }
        double orderMax = Math.log10(this.dimMax);
        double orderMin = Math.log10(axisMinimum);
        List<Double> orderTicks = this.createTicks(maxTicks, orderMin, orderMax);
        boolean count = false;
        for (Double value : orderTicks) {
            int power = value.intValue();
            ticks.add(Math.pow(10.0, power));
        }
        return ticks;
    }

    public boolean contains(double x) {
        return x >= this.dimMin && x <= this.dimMax;
    }

    private double niceNum(double range, boolean round) {
        double exponent = Math.floor(Math.log10(range));
        double fraction = range / Math.pow(10.0, exponent);
        double niceFraction = round ? (fraction < 1.5 ? 1.0 : (fraction < 3.0 ? 2.0 : (fraction < 7.0 ? 5.0 : 10.0))) : (fraction <= 1.0 ? 1.0 : (fraction <= 2.0 ? 2.0 : (fraction <= 5.0 ? 5.0 : 10.0)));
        return niceFraction * Math.pow(10.0, exponent);
    }

    public void addPadding(double fraction) {
        double value = fraction * this.getLength();
        this.setMinMax(this.dimMin - value, this.dimMax + value);
    }

    public void addPadding(double frLow, double frHigh) {
        double valueL = frLow * this.getLength();
        double valueH = frHigh * this.getLength();
        this.setMinMax(this.dimMin - valueL, this.dimMax + valueH);
    }

    public String toString() {
        return String.format("Dimension1D :  %8.4f  %8.4f", this.dimMin, this.dimMax);
    }

    public static void main(String[] args) {
        Dimension1D x = new Dimension1D(0.1, 100.0);
        x.setLog(true);
        for (double value = 1.0; value < 10.0; value += 1.0) {
            System.out.println(value + " --> " + x.getFraction(value) + "  length = " + x.length());
        }
        List<Double> ticks = x.getDimensionTicks(8);
        for (Double v : ticks) {
            System.out.println(v);
        }
        List<Double> ticksLog = x.getDimensionTicksLog(8);
    }
}

