/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.graphics;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import org.jlab.groot.base.TStyle;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.graphics.GraphicsAxisFrame;
import org.jlab.groot.graphics.IDataSetPlotter;
import org.jlab.groot.math.Dimension3D;

public class HistogramPlotter
implements IDataSetPlotter {
    String plottingOptions = "";
    IDataSet dataset = null;
    Dimension3D dataRegion = new Dimension3D();
    String datasetName = "";
    public GeneralPath path = null;

    public HistogramPlotter(IDataSet ds) {
        this.dataset = ds;
        this.datasetName = ds.getName();
    }

    public HistogramPlotter(IDataSet ds, String options) {
        this.dataset = ds;
        this.datasetName = ds.getName();
        this.plottingOptions = options;
    }

    @Override
    public String getOptions() {
        return this.plottingOptions;
    }

    @Override
    public void setOptions(String opt) {
        this.plottingOptions = opt;
    }

    @Override
    public String getName() {
        return this.datasetName;
    }

    @Override
    public IDataSet getDataSet() {
        return this.dataset;
    }

    @Override
    public void draw(Graphics2D g2d, GraphicsAxisFrame frame) {
        int npoints = this.dataset.getDataSize(0);
        double dataX = this.dataset.getDataX(0);
        double dataY = this.dataset.getDataY(0);
        double errorX = this.dataset.getDataEX(0);
        double xps = frame.getAxisPointX(dataX - errorX * 0.5);
        double xpe = frame.getAxisPointX(dataX + errorX * 0.5);
        double yp = frame.getAxisPointY(0.0);
        this.path = new GeneralPath();
        this.path.moveTo((int)xps, (int)yp);
        for (int p = 0; p < npoints; ++p) {
            dataX = this.dataset.getDataX(p);
            dataY = this.dataset.getDataY(p);
            errorX = this.dataset.getDataEX(p);
            xps = frame.getAxisPointX(dataX - errorX * 0.5);
            xpe = frame.getAxisPointX(dataX + errorX * 0.5);
            yp = frame.getAxisPointY(dataY);
            this.path.lineTo((int)xps, (int)yp);
            this.path.lineTo((int)xpe, (int)yp);
        }
        yp = frame.getAxisPointY(0.0);
        this.path.lineTo((int)xpe, (int)yp);
        int fillColor = this.dataset.getAttributes().getFillColor();
        if (fillColor >= 0) {
            g2d.setColor(TStyle.getColor(fillColor));
            g2d.fill(this.path);
        }
        g2d.setStroke(new BasicStroke(this.dataset.getAttributes().getLineWidth()));
        int lineColor = this.dataset.getAttributes().getLineColor();
        g2d.setColor(TStyle.getColor(lineColor));
        g2d.draw(this.path);
        if (this.dataset.getAttributes().getDrawOptions().contains("E")) {
            for (int p = 0; p < npoints; ++p) {
                double xp = frame.getAxisPointX(this.dataset.getDataX(p));
                double ypL = frame.getAxisPointY(this.dataset.getDataY(p) - this.dataset.getDataEY(p));
                double ypH = frame.getAxisPointY(this.dataset.getDataY(p) + this.dataset.getDataEY(p));
                g2d.setColor(TStyle.getColor(lineColor));
                g2d.setStroke(new BasicStroke(this.dataset.getAttributes().getLineWidth()));
                g2d.drawLine((int)xp, (int)ypL, (int)xp, (int)ypH);
            }
        }
    }

    @Override
    public Dimension3D getDataRegion() {
        this.dataRegion.set(this.dataset.getDataX(0), this.dataset.getDataX(0), 0.0, 0.0, 0.0, 1.0);
        int dataSize = this.dataset.getDataSize(0);
        for (int p = 0; p < dataSize; ++p) {
            double x1 = this.dataset.getDataX(p) - this.dataset.getDataEX(p) * 0.5;
            double x2 = this.dataset.getDataX(p) + this.dataset.getDataEX(p) * 0.5;
            this.dataRegion.grow(this.dataset.getDataX(p), this.dataset.getDataY(p), 0.5);
            this.dataRegion.getDimension(0).grow(x1);
            this.dataRegion.getDimension(0).grow(x2);
        }
        this.dataRegion.getDimension(1).addPadding(0.0, 0.2);
        return this.dataRegion;
    }
}

