/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.graphics;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Polygon;
import org.jlab.groot.base.TStyle;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.graphics.GraphicsAxisFrame;
import org.jlab.groot.graphics.IDataSetPlotter;
import org.jlab.groot.math.Dimension3D;

public class GraphErrorsPlotter
implements IDataSetPlotter {
    IDataSet graphDataSet = null;
    Dimension3D graphDataRegion = new Dimension3D();
    String plottingOptions = "";

    public GraphErrorsPlotter(IDataSet dataset) {
        this.graphDataSet = dataset;
    }

    @Override
    public String getName() {
        return this.graphDataSet.getName();
    }

    @Override
    public IDataSet getDataSet() {
        return this.graphDataSet;
    }

    @Override
    public void draw(Graphics2D g2d, GraphicsAxisFrame frame) {
        int npoints = this.graphDataSet.getDataSize(0);
        int markerSize = this.getDataSet().getAttributes().getMarkerSize();
        int lineThickness = this.getDataSet().getAttributes().getLineWidth();
        int lineColor = this.getDataSet().getAttributes().getLineColor();
        int style = this.getDataSet().getAttributes().getMarkerStyle();
        BasicStroke strokePoint = new BasicStroke(lineThickness);
        BasicStroke strokeError = new BasicStroke(lineThickness);
        for (int p = 0; p < npoints; ++p) {
            double xp = frame.getAxisPointX(this.graphDataSet.getDataX(p));
            double yp = frame.getAxisPointY(this.graphDataSet.getDataY(p));
            double xpL = frame.getAxisPointX(this.graphDataSet.getDataX(p) - this.graphDataSet.getDataEX(p));
            double xpH = frame.getAxisPointX(this.graphDataSet.getDataX(p) + this.graphDataSet.getDataEX(p));
            double ypL = frame.getAxisPointY(this.graphDataSet.getDataY(p) - this.graphDataSet.getDataEY(p));
            double ypH = frame.getAxisPointY(this.graphDataSet.getDataY(p) + this.graphDataSet.getDataEY(p));
            g2d.setColor(TStyle.getColor(lineColor));
            g2d.setStroke(strokeError);
            g2d.drawLine((int)xpL, (int)yp, (int)xpH, (int)yp);
            g2d.drawLine((int)xp, (int)ypL, (int)xp, (int)ypH);
            g2d.setColor(TStyle.getColor(this.getDataSet().getAttributes().getMarkerColor()));
            g2d.setStroke(strokePoint);
            if (style == 0) {
                g2d.fillOval((int)xp - markerSize, (int)yp - markerSize, markerSize * 2, markerSize * 2);
                continue;
            }
            if (style == 1) {
                g2d.fillRect((int)xp - markerSize, (int)yp - markerSize, markerSize * 2, markerSize * 2);
                continue;
            }
            if (style == 2) {
                Polygon invertedTriangle = new Polygon();
                invertedTriangle.addPoint((int)xp, (int)(yp - (double)markerSize));
                invertedTriangle.addPoint((int)xp + markerSize, (int)(yp + (double)markerSize));
                invertedTriangle.addPoint((int)xp - markerSize, (int)(yp + (double)markerSize));
                g2d.fillPolygon(invertedTriangle);
                continue;
            }
            if (style == 3) {
                Polygon triangle = new Polygon();
                triangle.addPoint((int)xp, (int)(yp + (double)markerSize));
                triangle.addPoint((int)xp + markerSize, (int)(yp - (double)markerSize));
                triangle.addPoint((int)xp - markerSize, (int)(yp - (double)markerSize));
                g2d.fillPolygon(triangle);
                continue;
            }
            g2d.fillOval((int)xp - markerSize, (int)yp - markerSize, markerSize * 2, markerSize * 2);
        }
    }

    @Override
    public Dimension3D getDataRegion() {
        this.graphDataRegion.getDimension(0).setMinMax(this.graphDataSet.getDataX(0), this.graphDataSet.getDataX(0));
        this.graphDataRegion.getDimension(1).setMinMax(this.graphDataSet.getDataY(0), this.graphDataSet.getDataY(0));
        this.graphDataRegion.getDimension(2).setMinMax(0.0, 1.0);
        for (int p = 0; p < this.graphDataSet.getDataSize(0); ++p) {
            this.graphDataRegion.grow(this.graphDataSet.getDataX(p) - this.graphDataSet.getDataEX(p), this.graphDataSet.getDataY(p) - this.graphDataSet.getDataEY(p), 0.5);
            this.graphDataRegion.grow(this.graphDataSet.getDataX(p) + this.graphDataSet.getDataEX(p), this.graphDataSet.getDataY(p) + this.graphDataSet.getDataEY(p), 0.5);
        }
        this.graphDataRegion.getDimension(0).addPadding(0.05);
        this.graphDataRegion.getDimension(1).addPadding(0.0, 0.15);
        return this.graphDataRegion;
    }

    @Override
    public String getOptions() {
        return this.plottingOptions;
    }

    @Override
    public void setOptions(String opt) {
        this.plottingOptions = opt;
    }
}

