/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.graphics;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import org.jlab.groot.base.PadAttributes;
import org.jlab.groot.base.PadMargins;
import org.jlab.groot.data.GraphErrors;
import org.jlab.groot.data.H1F;
import org.jlab.groot.data.H2F;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.graphics.FunctionPlotter;
import org.jlab.groot.graphics.GraphErrorsPlotter;
import org.jlab.groot.graphics.GraphicsAxis;
import org.jlab.groot.graphics.GraphicsAxisFrame;
import org.jlab.groot.graphics.Histogram2DPlotter;
import org.jlab.groot.graphics.HistogramPlotter;
import org.jlab.groot.graphics.IDataSetPlotter;
import org.jlab.groot.math.Dimension2D;
import org.jlab.groot.math.Dimension3D;
import org.jlab.groot.math.Func1D;
import org.jlab.groot.ui.LatexText;
import org.jlab.groot.ui.PaveText;

public class EmbeddedPad {
    PadAttributes attr = new PadAttributes();
    Dimension2D padDimensions = new Dimension2D();
    GraphicsAxisFrame axisFrame = new GraphicsAxisFrame();
    List<IDataSetPlotter> datasetPlotters = new ArrayList<IDataSetPlotter>();
    boolean preliminary = true;
    int preliminarySize = 36;
    PaveText statBox = null;

    public EmbeddedPad() {
    }

    public EmbeddedPad(int x, int y, int width, int height) {
        this.setDimension(x, y, width, height);
    }

    public final EmbeddedPad setDimension(int x, int y, int width, int height) {
        this.padDimensions.getDimension(0).setMinMax(x, x + width);
        this.padDimensions.getDimension(1).setMinMax(y, y + height);
        this.axisFrame.setFrameDimensions(this.padDimensions.getDimension(0).getMin(), this.padDimensions.getDimension(0).getMax(), this.padDimensions.getDimension(1).getMin(), this.padDimensions.getDimension(1).getMax());
        return this;
    }

    public void clear() {
        this.datasetPlotters.clear();
    }

    public Map<String, IDataSet> getObjectMap() {
        LinkedHashMap<String, IDataSet> objects = new LinkedHashMap<String, IDataSet>();
        for (IDataSetPlotter plotter : this.datasetPlotters) {
            objects.put(plotter.getName(), plotter.getDataSet());
        }
        return objects;
    }

    public void setAxisRange(double xmin, double xmax, double ymin, double ymax) {
        this.getAxisX().setRange(xmin, xmax);
        this.getAxisY().setRange(ymin, ymax);
    }

    public void setMargins(PadMargins margins) {
        this.attr.getPadMargins().copy(margins);
    }

    public GraphicsAxisFrame getAxisFrame() {
        return this.axisFrame;
    }

    public void paint(Graphics g) {
        this.draw((Graphics2D)g);
    }

    public List<IDataSetPlotter> getDatasetPlotters() {
        return this.datasetPlotters;
    }

    public void setDatasetPlotters(List<IDataSetPlotter> datasetPlotters) {
        this.datasetPlotters = datasetPlotters;
    }

    public void draw(Graphics2D g2d) {
        g2d.setColor(this.attr.getBackgroundColor());
        Dimension3D axis = new Dimension3D();
        axis.set(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
        if (this.datasetPlotters.size() > 0) {
            axis.copy(this.datasetPlotters.get(0).getDataRegion());
            for (IDataSetPlotter plotter : this.datasetPlotters) {
                Dimension3D d3d = plotter.getDataRegion();
                axis.combine(d3d);
            }
            if (!this.getAxisX().isAutoScale()) {
                axis.getDimension(0).copy(this.getAxisX().getRange());
            } else {
                this.axisFrame.getAxisX().setRange(axis.getDimension(0).getMin(), axis.getDimension(0).getMax());
                this.axisFrame.getAxisX().getAttributes().setAxisAutoScale(true);
            }
            double sum = 0.0;
            for (int i = 0; i < this.datasetPlotters.get(0).getDataSet().getDataSize(1); ++i) {
                sum += this.datasetPlotters.get(0).getDataSet().getDataY(i);
            }
            if (this.datasetPlotters.size() > 0 && this.getDatasetPlotters().get(0) instanceof Histogram2DPlotter) {
                sum = 1.0;
            }
            if (!this.getAxisY().isAutoScale() || sum == 0.0) {
                axis.getDimension(1).copy(this.getAxisY().getRange());
            } else {
                this.axisFrame.getAxisY().setRange(axis.getDimension(1).getMin(), axis.getDimension(1).getMax());
                this.axisFrame.getAxisY().getAttributes().setAxisAutoScale(true);
            }
            if (!this.getAxisZ().isAutoScale()) {
                axis.getDimension(2).copy(this.getAxisZ().getRange());
            } else {
                this.axisFrame.getAxisZ().setRange(axis.getDimension(2).getMin(), axis.getDimension(2).getMax());
                this.axisFrame.getAxisZ().getAttributes().setAxisAutoScale(true);
            }
            if (this.attr.getTitle() != "") {
                this.attr.getPadMargins().setTopMargin(this.attr.getPadMargins().getTopMargin() + this.getTitleFontSize());
                this.axisFrame.setAxisMargins(this.attr.getPadMargins());
                this.axisFrame.updateMargins(g2d);
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(this.axisFrame.getFrameDimensions().getDimension(0).getMin() + (double)this.attr.getPadMargins().getLeftMargin(), this.axisFrame.getFrameDimensions().getDimension(1).getMin() + (double)this.attr.getPadMargins().getTopMargin(), this.axisFrame.getFrameDimensions().getDimension(0).getLength() - (double)this.attr.getPadMargins().getLeftMargin() - (double)this.attr.getPadMargins().getRightMargin(), this.axisFrame.getFrameDimensions().getDimension(1).getLength() - (double)this.attr.getPadMargins().getTopMargin() - (double)this.attr.getPadMargins().getBottomMargin());
            g2d.setClip(rect);
            for (IDataSetPlotter plotter : this.datasetPlotters) {
                plotter.draw(g2d, this.axisFrame);
            }
            g2d.setClip(null);
            this.axisFrame.drawAxis(g2d, this.attr.getPadMargins());
            ArrayList<List<LatexText>> toBeDrawn = new ArrayList<List<LatexText>>();
            for (int i = 0; i < this.datasetPlotters.size(); ++i) {
                List<List<LatexText>> currentStats = this.datasetPlotters.get(i).getDataSet().getStatBox().getPaveTexts();
                String optStat = this.datasetPlotters.get(i).getDataSet().getAttributes().getOptStat();
                int counter = 0;
                for (int j = 0; j < optStat.length() && j < currentStats.size(); ++j) {
                    if (Integer.parseInt("" + optStat.charAt(optStat.length() - 1 - j)) != 0) {
                        toBeDrawn.add(currentStats.get(counter));
                    }
                    ++counter;
                }
            }
            this.axisFrame.updateMargins(g2d);
            if (toBeDrawn.size() > 0) {
                this.statBox = new PaveText(2);
                this.statBox.setPaveTexts(toBeDrawn);
                this.statBox.setFont(this.attr.getStatBoxFont().getFontName());
                this.statBox.setFontSize(this.attr.getStatBoxFont().getFontSize());
                this.statBox.updateDimensions(g2d);
                this.statBox.setBackground(255, 255, 255, 200);
                int x = (int)(this.axisFrame.getFrameDimensions().getDimension(0).getMax() - this.statBox.getBounds().getDimension(0).getLength() - 5.0) + this.attr.getStatBoxOffsetX();
                int y = (int)(this.axisFrame.getFrameDimensions().getDimension(1).getMin() + 5.0) + this.attr.getStatBoxOffsetY();
                this.statBox.setPosition(x - this.attr.getPadMargins().getRightMargin(), y + this.attr.getPadMargins().getTopMargin());
                this.statBox.drawPave(g2d, x - this.attr.getPadMargins().getRightMargin(), y + this.attr.getPadMargins().getTopMargin());
            }
            if (!"".equals(this.attr.getTitle())) {
                LatexText titleLatex = new LatexText(this.attr.getTitle());
                titleLatex.setColor(1);
                titleLatex.setFont(this.getTitleFont());
                titleLatex.setFontSize(this.getTitleFontSize());
                this.attr.getPadMargins().setTopMargin(this.attr.getPadMargins().getTopMargin() + this.getTitleFontSize() + 10);
                titleLatex.drawString(g2d, (int)this.axisFrame.getAxisX().getAxisPosition(this.axisFrame.getAxisX().getRange().getMin() + 0.5 * this.axisFrame.getAxisX().getRange().getLength()), (int)(this.axisFrame.getFrameDimensions().getDimension(1).getMin() + (double)this.attr.getTitleOffset()), 1, 0);
            }
        }
    }

    public void setOptStat(int opts) {
        if (this.getDatasetPlotters().size() > 0) {
            this.getDatasetPlotters().get(0).getDataSet().getAttributes().setOptStat("" + opts);
        }
    }

    public void setOptStat(String opts) {
        if (this.getDatasetPlotters().size() > 0) {
            this.getDatasetPlotters().get(0).getDataSet().getAttributes().setOptStat(opts);
        }
    }

    public String getOptStat() {
        if (this.getDatasetPlotters().size() > 0) {
            return this.getDatasetPlotters().get(0).getDataSet().getAttributes().getOptStat();
        }
        return "0";
    }

    public EmbeddedPad setAutoScale() {
        this.getAxisX().setAutoScale(true);
        this.getAxisY().setAutoScale(true);
        return this;
    }

    public GraphicsAxis getAxisX() {
        return this.axisFrame.getAxisX();
    }

    public GraphicsAxis getAxisY() {
        return this.axisFrame.getAxisY();
    }

    public void setStatBoxFont(String name) {
        this.attr.getStatBoxFont().setFontName(name);
    }

    public void setStatBoxFontSize(int size) {
        this.attr.getStatBoxFont().setFontSize(size);
    }

    public void setAxisFont(String name) {
        this.getAxisFrame().getAxisX().setAxisFont(name);
        this.getAxisFrame().getAxisY().setAxisFont(name);
    }

    public void setAxisFontSize(int size) {
        this.getAxisFrame().getAxisX().setAxisFontSize(size);
        this.getAxisFrame().getAxisY().setAxisFontSize(size);
    }

    public void addPlotter(IDataSetPlotter plotter) {
        this.datasetPlotters.add(plotter);
    }

    public int getWidth() {
        return (int)(this.padDimensions.getDimension(0).getMax() - this.padDimensions.getDimension(0).getMin());
    }

    public int getHeight() {
        return (int)(this.padDimensions.getDimension(1).getMax() - this.padDimensions.getDimension(1).getMin());
    }

    public void draw(IDataSet ds, String options) {
        ds.getAttributes().setDrawOptions(options);
        if (!options.contains("same")) {
            this.datasetPlotters.clear();
        }
        if (this.datasetPlotters.isEmpty()) {
            this.axisFrame.getAxisY().setTitle(ds.getAttributes().getTitleY());
            this.axisFrame.getAxisX().setTitle(ds.getAttributes().getTitleX());
            this.setTitle(ds.getAttributes().getTitle());
        } else {
            this.axisFrame.getAxisY().setTitle(this.datasetPlotters.get(0).getDataSet().getAttributes().getTitleY());
            this.axisFrame.getAxisX().setTitle(this.datasetPlotters.get(0).getDataSet().getAttributes().getTitleX());
        }
        if (ds instanceof Func1D) {
            this.addPlotter(new FunctionPlotter(ds));
        }
        if (ds instanceof H1F) {
            this.addPlotter(new HistogramPlotter(ds, options));
            H1F h = (H1F)ds;
            if (h.getFunction() != null) {
                this.addPlotter(new FunctionPlotter(h.getFunction()));
            }
        }
        if (ds instanceof H2F) {
            this.axisFrame.getAxisZ().getAttributes().setShowAxis(true);
            this.addPlotter(new Histogram2DPlotter(ds));
        }
        if (ds instanceof GraphErrors) {
            this.addPlotter(new GraphErrorsPlotter(ds));
            GraphErrors gr = (GraphErrors)ds;
            if (gr.getFunction() != null) {
                this.addPlotter(new FunctionPlotter(gr.getFunction()));
            }
        }
    }

    public void remove(IDataSet ds) {
        for (IDataSetPlotter plotter : this.datasetPlotters) {
            if (!plotter.getDataSet().equals(ds)) continue;
            this.datasetPlotters.remove(plotter);
            break;
        }
    }

    public EmbeddedPad getCopy() {
        EmbeddedPad pad = new EmbeddedPad();
        for (int i = 0; i < this.datasetPlotters.size(); ++i) {
            IDataSetPlotter plotter = this.datasetPlotters.get(i);
            if (plotter instanceof HistogramPlotter) {
                pad.addPlotter(new HistogramPlotter(plotter.getDataSet()));
            }
            if (plotter instanceof FunctionPlotter) {
                pad.addPlotter(new FunctionPlotter(plotter.getDataSet()));
            }
            if (plotter instanceof Histogram2DPlotter) {
                pad.addPlotter(new Histogram2DPlotter(plotter.getDataSet()));
            }
            if (!(plotter instanceof GraphErrorsPlotter)) continue;
            pad.addPlotter(new GraphErrorsPlotter(plotter.getDataSet()));
        }
        try {
            pad.getAxisX().setAttributes(this.getAxisX().getAttributes().clone());
            pad.getAxisY().setAttributes(this.getAxisY().getAttributes().clone());
            pad.getAxisZ().setAttributes(this.getAxisZ().getAttributes().clone());
            pad.setTitle(this.attr.getTitle());
            pad.setTitleOffset(this.attr.getTitleOffset());
            pad.setTitleFontSize(this.getTitleFontSize());
            pad.setTitleFont(this.getTitleFont());
            pad.setStatBoxFont(this.getStatBoxFontName());
            pad.setStatBoxFontSize(this.getStatBoxFontSize());
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return pad;
    }

    private String getStatBoxFontName() {
        return this.attr.getStatBoxFont().getFontName();
    }

    public GraphicsAxis getAxisZ() {
        return this.axisFrame.getAxisZ();
    }

    public String getTitle() {
        return this.attr.getTitle();
    }

    public int getTitleOffset() {
        return this.attr.getTitleOffset();
    }

    public void setTitleOffset(int titleOffset) {
        this.attr.setTitleOffset(titleOffset);
    }

    public void setTitleFont(String titleFont) {
        this.attr.setTitleFontName(titleFont);
    }

    public void getTitle(String title) {
        this.attr.setTitle(title);
    }

    public int getTitleFontSize() {
        return this.attr.getTitleFontSize();
    }

    public String getTitleFont() {
        return this.attr.getTitleFontName();
    }

    public void setTitleFontSize(int titleFontSize) {
        this.attr.setTitleFontSize(titleFontSize);
    }

    public void getTitleFont(String titleFont) {
        this.attr.setTitleFontName(titleFont);
    }

    public void setAxisTitleFontSize(int parseInt) {
        this.getAxisX().getAttributes().setTitleFontSize(parseInt);
        this.getAxisY().getAttributes().setTitleFontSize(parseInt);
        this.getAxisZ().getAttributes().setTitleFontSize(parseInt);
    }

    public void setAxisLabelFontSize(int parseInt) {
        this.getAxisX().getAttributes().setLabelFontSize(parseInt);
        this.getAxisY().getAttributes().setLabelFontSize(parseInt);
        this.getAxisZ().getAttributes().setLabelFontSize(parseInt);
    }

    public void setFontNameAll(String FontName) {
        this.getAxisX().getAttributes().setLabelFontName(FontName);
        this.getAxisY().getAttributes().setLabelFontName(FontName);
        this.getAxisZ().getAttributes().setLabelFontName(FontName);
        this.getAxisX().getAttributes().setTitleFontName(FontName);
        this.getAxisY().getAttributes().setTitleFontName(FontName);
        this.attr.setTitleFontName(FontName);
        this.attr.getStatBoxFont().setFontName(FontName);
    }

    public int getStatBoxFontSize() {
        return this.attr.getStatBoxFont().getFontSize();
    }

    public void setTitle(String title) {
        this.attr.setTitle(title);
    }

    public static class EmbeddedPadConfigurationPane
    extends JDialog {
        EmbeddedPad embeddedPad = null;
        JTabbedPane tabbedPane = new JTabbedPane();

        public EmbeddedPadConfigurationPane(EmbeddedPad pad) {
            this.setEmbeddedPad(pad);
        }

        public final void setEmbeddedPad(EmbeddedPad pad) {
            this.embeddedPad = pad;
        }

        public void initUI() {
        }
    }
}

