/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.graphics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.graphics.EmbeddedCanvas;
import org.jlab.groot.group.DataGroup;

public class EmbeddedCanvasGroup
extends JPanel
implements ActionListener {
    private EmbeddedCanvas canvas = new EmbeddedCanvas();
    private int padsPerPage = 12;
    private DataGroup dataGroup = new DataGroup();
    private int currentPage = 0;
    private int maxPages = 1;
    private List<IDataSet> canvasDataSets = new ArrayList<IDataSet>();
    JLabel progressLabel = null;

    public EmbeddedCanvasGroup() {
        this.setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel();
        JButton buttonPrev = new JButton("<");
        this.progressLabel = new JLabel("0/0");
        JButton buttonNext = new JButton(">");
        buttonPrev.addActionListener(this);
        buttonNext.addActionListener(this);
        buttonsPanel.setLayout(new FlowLayout());
        buttonsPanel.add(buttonPrev);
        buttonsPanel.add(this.progressLabel);
        buttonsPanel.add(buttonNext);
        this.add((Component)this.canvas, "Center");
        this.add((Component)buttonsPanel, "Last");
    }

    public void setData(List<IDataSet> datasets) {
        this.canvasDataSets.clear();
        this.canvasDataSets.addAll(datasets);
        this.currentPage = 0;
        this.maxPages = this.canvasDataSets.size() / this.padsPerPage;
        if (this.maxPages * this.padsPerPage < this.canvasDataSets.size()) {
            ++this.maxPages;
        }
        this.updateCanvas();
    }

    public void updateCanvas() {
        this.canvas.clear();
        this.canvas.divide(3, 4);
        for (int i = 0; i < this.padsPerPage; ++i) {
            int index = this.currentPage * this.padsPerPage + i;
            this.canvas.cd(i);
            if (index >= this.canvasDataSets.size()) continue;
            this.canvas.draw(this.canvasDataSets.get(index));
        }
        this.progressLabel.setText(String.format("%d/%d", this.currentPage + 1, this.maxPages));
    }

    public void nextPage() {
        if (this.currentPage + 1 < this.maxPages) {
            ++this.currentPage;
            this.updateCanvas();
        }
    }

    public void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.canvas.clear();
            this.updateCanvas();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("<") == 0) {
            this.previousPage();
        }
        if (e.getActionCommand().compareTo(">") == 0) {
            this.nextPage();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        EmbeddedCanvasGroup canvasTab = new EmbeddedCanvasGroup();
        frame.add(canvasTab);
        frame.pack();
        frame.setMinimumSize(new Dimension(300, 300));
        frame.setVisible(true);
    }
}

