/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.data;

import java.util.ArrayList;
import org.jlab.groot.base.DatasetAttributes;
import org.jlab.groot.base.GStyle;
import org.jlab.groot.data.DataVector;
import org.jlab.groot.data.GraphErrors;
import org.jlab.groot.data.H1F;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.math.Axis;
import org.jlab.groot.math.MultiIndex;
import org.jlab.groot.ui.PaveText;

public class H2F
implements IDataSet {
    private String hName = "basic2D";
    private Axis xAxis = new Axis();
    private Axis yAxis = new Axis();
    private float[] hBuffer;
    private MultiIndex offset;
    private DatasetAttributes attr = new DatasetAttributes(1);
    private Float maximumBinValue = Float.valueOf(0.0f);

    public H2F() {
        this.offset = new MultiIndex(this.xAxis.getNBins(), this.yAxis.getNBins());
        this.hBuffer = new float[this.offset.getArraySize()];
        this.initAttributes();
    }

    @Override
    public void setName(String name) {
        this.hName = name;
    }

    public H2F(String name) {
        this.hName = name;
        this.offset = new MultiIndex(this.xAxis.getNBins(), this.yAxis.getNBins());
        this.hBuffer = new float[this.offset.getArraySize()];
        this.initAttributes();
    }

    public H2F(String name, int bx, double xmin, double xmax, int by, double ymin, double ymax) {
        this.hName = name;
        this.set(bx, xmin, xmax, by, ymin, ymax);
        this.offset = new MultiIndex(bx, by);
        this.hBuffer = new float[this.offset.getArraySize()];
        this.initAttributes();
    }

    public H2F(String name, String title, int bx, double xmin, double xmax, int by, double ymin, double ymax) {
        this.hName = name;
        this.setTitle(title);
        this.set(bx, xmin, xmax, by, ymin, ymax);
        this.offset = new MultiIndex(bx, by);
        this.hBuffer = new float[this.offset.getArraySize()];
        this.initAttributes();
    }

    private void initAttributes() {
        try {
            this.attr = GStyle.getH2FAttributes().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public final void set(int bx, double xmin, double xmax, int by, double ymin, double ymax) {
        this.xAxis.set(bx, xmin, xmax);
        this.yAxis.set(by, ymin, ymax);
        this.offset = new MultiIndex(bx, by);
        int buff = this.offset.getArraySize();
        this.hBuffer = new float[buff];
    }

    @Override
    public String getName() {
        return this.hName;
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public double getMaximum() {
        double maximum = 0.0;
        for (int loop = 0; loop < this.hBuffer.length; ++loop) {
            if (!((double)this.hBuffer[loop] > maximum)) continue;
            maximum = this.hBuffer[loop];
        }
        return maximum;
    }

    private boolean isValidBins(int bx, int by) {
        return bx >= 0 && bx <= this.xAxis.getNBins() && by >= 0 && by <= this.yAxis.getNBins();
    }

    public double getBinContent(int bx, int by) {
        if (this.isValidBins(bx, by)) {
            int buff = this.offset.getArrayIndex(bx, by);
            if (buff >= 0 && buff < this.hBuffer.length) {
                return this.hBuffer[buff];
            }
            System.out.println("[Index] error for binx = " + bx + " biny = " + by);
        }
        return 0.0;
    }

    public void modify(DataVector vecX, DataVector vecY, double xmin, double xmax, double ymin, double ymax) {
        int nbinsX = this.xAxis.getNBins();
        int nbinsY = this.yAxis.getNBins();
        this.xAxis.set(nbinsX, xmin, xmax);
        this.yAxis.set(nbinsY, ymin, ymax);
        this.reset();
        for (int loop = 0; loop < vecX.getSize(); ++loop) {
            this.fill(vecX.getValue(loop), vecY.getValue(loop));
        }
    }

    public static H2F create(String name, int binsX, int binsY, DataVector vecX, DataVector vecY) {
        double minX = vecX.getMin();
        double maxX = vecX.getMax();
        double minY = vecY.getMin();
        double maxY = vecY.getMax();
        if (minX == maxX) {
            minX = 0.9999 * minX;
            maxX = 1.0001 * maxX;
        }
        if (minY == maxY) {
            minY = 0.9999 * minY;
            maxY = 1.0001 * maxY;
        }
        H2F h2 = new H2F(name, "", binsX, minX, maxX, binsY, minY, maxY);
        for (int i = 0; i < vecX.getSize(); ++i) {
            h2.fill(vecX.getValue(i), vecY.getValue(i));
        }
        return h2;
    }

    public final void setTitleX(String xTitle) {
        this.attr.setTitleX(xTitle);
    }

    public final void setTitleY(String yTitle) {
        this.attr.setTitleY(yTitle);
    }

    public String getTitle() {
        return this.attr.getTitle();
    }

    public String getTitleX() {
        return this.attr.getTitleX();
    }

    public String getTitleY() {
        return this.attr.getTitleY();
    }

    public final void setTitle(String title) {
        this.attr.setTitle(title);
    }

    public int getDataBufferSize() {
        return this.hBuffer.length;
    }

    public float getDataBufferBin(int bin) {
        return this.hBuffer[bin];
    }

    public void setDataBufferBin(int bin, float value) {
        this.hBuffer[bin] = value;
    }

    public void setBinContent(int bx, int by, double w) {
        if (this.isValidBins(bx, by)) {
            int buff = this.offset.getArrayIndex(bx, by);
            this.hBuffer[buff] = (float)w;
        }
    }

    public void fill(double x, double y) {
        int bin = this.findBin(x, y);
        if (bin >= 0) {
            this.addBinContent(bin);
        }
    }

    public void fill(double x, double y, double w) {
        int bin = this.findBin(x, y);
        if (bin >= 0) {
            this.addBinContent(bin, w);
        }
    }

    private void addBinContent(int bin) {
        this.hBuffer[bin] = (float)((double)this.hBuffer[bin] + 1.0);
        if (this.hBuffer[bin] > this.maximumBinValue.floatValue()) {
            this.maximumBinValue = Float.valueOf(this.hBuffer[bin]);
        }
    }

    private void addBinContent(int bin, double w) {
        this.hBuffer[bin] = (float)((double)this.hBuffer[bin] + w);
        if (this.hBuffer[bin] > this.maximumBinValue.floatValue()) {
            this.maximumBinValue = Float.valueOf(this.hBuffer[bin]);
        }
    }

    public ArrayList<H1F> getSlicesX() {
        ArrayList<H1F> slices = new ArrayList<H1F>();
        for (int loop = 0; loop < this.getXAxis().getNBins(); ++loop) {
            H1F slice = this.sliceX(loop);
            slice.setName(this.getName() + "_" + loop);
            slice.setTitleX(this.getTitleY());
            slices.add(slice);
        }
        return slices;
    }

    public ArrayList<H1F> getSlicesY() {
        ArrayList<H1F> slices = new ArrayList<H1F>();
        for (int loop = 0; loop < this.getYAxis().getNBins(); ++loop) {
            H1F slice = this.sliceY(loop);
            slice.setName(this.getName() + "_" + loop);
            slice.setTitleX(this.getTitleX());
            slices.add(slice);
        }
        return slices;
    }

    public void add(H2F h) {
        if (h.getXAxis().getNBins() == this.getXAxis().getNBins() && h.getYAxis().getNBins() == this.getYAxis().getNBins()) {
            for (int loop = 0; loop < this.hBuffer.length; ++loop) {
                this.hBuffer[loop] = this.hBuffer[loop] + h.hBuffer[loop];
            }
        } else {
            System.out.println("[warning] ---> error adding histograms " + this.getName() + "  " + h.getName() + ". inconsistent bin numbers");
        }
    }

    public static H2F divide(H2F h1, H2F h2) {
        if (h1.getXAxis().getNBins() != h2.getXAxis().getNBins() || h1.getYAxis().getNBins() != h2.getYAxis().getNBins()) {
            System.out.println("[H2D::divide] error : histograms have inconsistent bins");
            return null;
        }
        H2F h2div = new H2F(h1.getName() + "_DIV", h1.getXAxis().getNBins(), h1.getXAxis().min(), h1.getXAxis().max(), h1.getYAxis().getNBins(), h1.getYAxis().min(), h1.getYAxis().max());
        for (int bx = 0; bx < h1.getXAxis().getNBins(); ++bx) {
            for (int by = 0; by < h1.getYAxis().getNBins(); ++by) {
                if (h2.getBinContent(bx, by) == 0.0) continue;
                h2div.setBinContent(bx, by, h1.getBinContent(bx, by) / h2.getBinContent(bx, by));
            }
        }
        return h2div;
    }

    public void divide(H2F h) {
        if (h.getXAxis().getNBins() == this.getXAxis().getNBins() && h.getYAxis().getNBins() == this.getYAxis().getNBins()) {
            for (int loop = 0; loop < this.hBuffer.length; ++loop) {
                this.hBuffer[loop] = h.hBuffer[loop] == 0.0f ? 0.0f : this.hBuffer[loop] / h.hBuffer[loop];
            }
        } else {
            System.err.println("[H2D::divide] error the bins in 2d histogram do not match");
        }
    }

    public int findBin(double x, double y) {
        int by;
        int bx = this.xAxis.getBin(x);
        if (this.isValidBins(bx, by = this.yAxis.getBin(y))) {
            return this.offset.getArrayIndex(bx, by);
        }
        return -1;
    }

    public double[][] getContentBuffer() {
        double[][] buff = new double[this.xAxis.getNBins()][this.yAxis.getNBins()];
        for (int xloop = 0; xloop < this.xAxis.getNBins(); ++xloop) {
            for (int yloop = 0; yloop < this.yAxis.getNBins(); ++yloop) {
                buff[xloop][yloop] = this.getBinContent(xloop, yloop);
            }
        }
        return buff;
    }

    public double[][] getErrorBuffer() {
        double[][] buff = new double[this.xAxis.getNBins()][this.yAxis.getNBins()];
        for (int xloop = 0; xloop < this.xAxis.getNBins(); ++xloop) {
            for (int yloop = 0; yloop < this.yAxis.getNBins(); ++yloop) {
                buff[xloop][yloop] = 0.0;
            }
        }
        return buff;
    }

    public H2F getRegion(String name, int bx_start, int bx_end, int by_start, int by_end) {
        double xBinWidth = this.xAxis.getBinWidth(bx_start);
        double newXMin = this.xAxis.min() + xBinWidth * (double)bx_start;
        double newXMax = this.xAxis.min() + xBinWidth * (double)bx_end;
        double yBinWidth = this.yAxis.getBinWidth(by_start);
        double newYMin = this.yAxis.min() + yBinWidth * (double)by_start;
        double newYMax = this.yAxis.min() + yBinWidth * (double)by_end;
        H2F regHist = new H2F(name, bx_end - bx_start, newXMin, newXMax, by_end - by_start, newYMin, newYMax);
        double content = 0.0;
        for (int y = by_start; y < by_end; ++y) {
            for (int x = bx_start; x < bx_end; ++x) {
                content = this.getBinContent(x, y);
                regHist.setBinContent(x, y, content);
            }
        }
        return regHist;
    }

    public H2F histClone(String name) {
        H2F hclone = new H2F(name, this.xAxis.getNBins(), this.xAxis.min(), this.xAxis.max(), this.yAxis.getNBins(), this.yAxis.min(), this.yAxis.max());
        for (int loop = 0; loop < this.hBuffer.length; ++loop) {
            hclone.hBuffer[loop] = this.hBuffer[loop];
        }
        return hclone;
    }

    public GraphErrors getProfileX() {
        GraphErrors graph = new GraphErrors();
        int nbinsX = this.getXAxis().getNBins();
        for (int loop = 0; loop < nbinsX; ++loop) {
            H1F h1 = this.sliceX(loop);
            double mean = h1.getMean();
            double rms = h1.getRMS();
            double bincenter = this.getXAxis().getBinCenter(loop);
            if (!(h1.integral() > 1.0)) continue;
            graph.addPoint(bincenter, mean, this.getXAxis().getBinWidth(loop) / 2.0, rms);
        }
        return graph;
    }

    public GraphErrors getProfileY() {
        GraphErrors graph = new GraphErrors();
        int nbinsY = this.getYAxis().getNBins();
        for (int loop = 0; loop < nbinsY; ++loop) {
            H1F h1 = this.sliceY(loop);
            double mean = h1.getMean();
            double rms = h1.getRMS();
            double bincenter = this.getYAxis().getBinCenter(loop);
            graph.addPoint(bincenter, mean, 0.0, rms);
        }
        return graph;
    }

    public H2F rebinX(int ngroups) {
        int nbinsX = this.xAxis.getNBins() / ngroups;
        H2F hrebinX = new H2F(this.hName, this.getTitle(), nbinsX, this.xAxis.min(), this.xAxis.min() + (double)(nbinsX * ngroups) * this.xAxis.getBinWidth(0), this.yAxis.getNBins(), this.yAxis.min(), this.yAxis.max());
        for (int iby = 0; iby < this.yAxis.getNBins(); ++iby) {
            for (int ibx = 0; ibx < nbinsX; ++ibx) {
                double height = 0.0;
                for (int igroup = 0; igroup < ngroups; ++igroup) {
                    height += this.getBinContent(ibx * ngroups + igroup, iby);
                }
                hrebinX.setBinContent(ibx, iby, height);
            }
        }
        return hrebinX;
    }

    public H2F rebinY(int ngroups) {
        int nbinsY = this.yAxis.getNBins() / ngroups;
        H2F hrebinY = new H2F(this.hName, this.getTitle(), this.xAxis.getNBins(), this.xAxis.min(), this.xAxis.max(), nbinsY, this.yAxis.min(), this.yAxis.min() + (double)(nbinsY * ngroups) * this.yAxis.getBinWidth(0));
        for (int ibx = 0; ibx < this.xAxis.getNBins(); ++ibx) {
            for (int iby = 0; iby < nbinsY; ++iby) {
                double height = 0.0;
                for (int igroup = 0; igroup < ngroups; ++igroup) {
                    height += this.getBinContent(ibx, iby * ngroups + igroup);
                }
                hrebinY.setBinContent(ibx, iby, height);
            }
        }
        return hrebinY;
    }

    public H1F projectionX() {
        String name = "X Projection";
        double xMin = this.xAxis.min();
        double xMax = this.xAxis.max();
        int xNum = this.xAxis.getNBins();
        H1F projX = new H1F(name, xNum, xMin, xMax);
        double height = 0.0;
        for (int x = 0; x < this.xAxis.getNBins(); ++x) {
            height = 0.0;
            for (int y = 0; y < this.yAxis.getNBins(); ++y) {
                height += this.getBinContent(x, y);
            }
            projX.setBinContent(x, height);
        }
        return projX;
    }

    public H1F projectionY() {
        String name = "Y Projection";
        double yMin = this.yAxis.min();
        double yMax = this.yAxis.max();
        int yNum = this.yAxis.getNBins();
        H1F projY = new H1F(name, yNum, yMin, yMax);
        double height = 0.0;
        for (int y = 0; y < this.yAxis.getNBins(); ++y) {
            height = 0.0;
            for (int x = 0; x < this.xAxis.getNBins(); ++x) {
                height += this.getBinContent(x, y);
            }
            projY.setBinContent(y, height);
        }
        return projY;
    }

    public H1F sliceX(int xBin) {
        String name = "Slice of " + xBin + " X Bin";
        double xMin = this.yAxis.min();
        double xMax = this.yAxis.max();
        int xNum = this.yAxis.getNBins();
        H1F sliceX = new H1F(name, name, xNum, xMin, xMax);
        for (int x = 0; x < xNum; ++x) {
            sliceX.setBinContent(x, this.getBinContent(xBin, x));
        }
        return sliceX;
    }

    public H1F sliceY(int yBin) {
        String name = "Slice of " + yBin + " Y Bin";
        double xMin = this.xAxis.min();
        double xMax = this.xAxis.max();
        int xNum = this.xAxis.getNBins();
        H1F sliceY = new H1F(name, name, xNum, xMin, xMax);
        for (int y = 0; y < xNum; ++y) {
            sliceY.setBinContent(y, this.getBinContent(y, yBin));
        }
        return sliceY;
    }

    public float[] offset() {
        return this.hBuffer;
    }

    @Override
    public void reset() {
        for (int bin = 0; bin < this.hBuffer.length; ++bin) {
            this.hBuffer[bin] = 0.0f;
        }
    }

    @Override
    public int getDataSize(int axis) {
        if (axis == 0) {
            return this.xAxis.getNBins();
        }
        return this.yAxis.getNBins();
    }

    @Override
    public DatasetAttributes getAttributes() {
        return this.attr;
    }

    @Override
    public double getDataX(int bin) {
        return this.xAxis.getBinCenter(bin);
    }

    @Override
    public double getDataY(int bin) {
        return this.yAxis.getBinCenter(bin);
    }

    @Override
    public double getDataEX(int bin) {
        return this.xAxis.getBinWidth(bin);
    }

    @Override
    public double getDataEY(int bin) {
        return this.yAxis.getBinWidth(bin);
    }

    @Override
    public double getData(int xbin, int ybin) {
        return this.getBinContent(xbin, ybin);
    }

    @Override
    public PaveText getStatBox() {
        return new PaveText(2);
    }
}

