/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.data;

import org.jlab.groot.base.DatasetAttributes;
import org.jlab.groot.base.GStyle;
import org.jlab.groot.data.DataVector;
import org.jlab.groot.data.GraphErrors;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.math.Axis;
import org.jlab.groot.math.Func1D;
import org.jlab.groot.math.StatNumber;
import org.jlab.groot.ui.PaveText;

public class H1F
implements IDataSet {
    Axis xAxis;
    Axis yAxis;
    float[] histogramData;
    float[] histogramDataError;
    String histName = "";
    int histogramUnderFlow = 0;
    int histogramOverFlow = 0;
    int histogramEntries = 0;
    DatasetAttributes hAttr = new DatasetAttributes(0);
    Func1D fittedFunction = null;

    public H1F() {
        this.setName("default");
        this.setTitle("default");
        this.set(1, 0.0, 1.0);
        this.initDataStore(1);
        this.initAttributes();
    }

    public H1F(String hName, String xTitle, String yTitle, int bins, double xMin, double xMax) {
        this.setName(hName);
        this.set(bins, xMin, xMax);
        this.initDataStore(bins);
        this.initAttributes();
        this.setTitleX(xTitle);
        this.setTitleY(yTitle);
    }

    public H1F(String name, double xMin, double xMax, float[] binHeights) {
        this.setName(name);
        this.set(binHeights.length, xMin, xMax);
        for (int i = 0; i < binHeights.length; ++i) {
            this.histogramData[i] = binHeights[i];
        }
        this.initAttributes();
    }

    public H1F(String name, int bins, double xMin, double xMax) {
        this.setName(name);
        this.set(bins, xMin, xMax);
        this.initAttributes();
    }

    public H1F(String name, String title, int bins, double xMin, double xMax) {
        this.setName(name);
        this.setTitle(title);
        this.set(bins, xMin, xMax);
        this.initAttributes();
    }

    public H1F(String name, String title, double xMin, double xMax) {
        this.setName(name);
        this.setTitle(title);
        this.set((int)(xMax - xMin), xMin, xMax);
        this.initAttributes();
    }

    public final void initAttributes() {
        try {
            this.hAttr = GStyle.getH1FAttributes().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public final void setTitle(String title) {
        this.hAttr.setTitle(title);
    }

    public final void setTitleX(String xTitle) {
        this.hAttr.setTitleX(xTitle);
    }

    public final void setTitleY(String yTitle) {
        this.hAttr.setTitleY(yTitle);
    }

    public static H1F create(String name, int bins, DataVector vec, DataVector weight) {
        double max;
        double min = vec.getMin();
        if (min == (max = vec.getMax())) {
            min = 0.9999 * min;
            max = 1.0001 * max;
        }
        H1F h = new H1F(name, "", bins, min, max);
        for (int i = 0; i < vec.getSize(); ++i) {
            h.fill(vec.getValue(i), weight.getValue(i));
        }
        h.setFillColor(43);
        return h;
    }

    public static H1F create(String name, int bins, DataVector vec) {
        double max;
        double min = vec.getMin();
        if (min == (max = vec.getMax())) {
            min = 0.9999 * min;
            max = 1.0001 * max;
        }
        H1F h = new H1F(name, "", bins, min, max);
        for (int i = 0; i < vec.getSize(); ++i) {
            h.fill(vec.getValue(i));
        }
        h.setFillColor(43);
        return h;
    }

    public String getTitle() {
        return this.hAttr.getTitle();
    }

    public String getTitleX() {
        return this.hAttr.getTitleX();
    }

    public String getTitleY() {
        return this.hAttr.getTitleY();
    }

    @Override
    public final void setName(String name) {
        this.histName = name;
    }

    @Override
    public void reset() {
        this.histogramEntries = 0;
        this.histogramOverFlow = 0;
        this.histogramUnderFlow = 0;
        for (int loop = 0; loop < this.histogramData.length; ++loop) {
            this.histogramData[loop] = 0.0f;
            if (this.histogramDataError.length != this.histogramData.length) continue;
            this.histogramDataError[loop] = 0.0f;
        }
    }

    public int getEntries() {
        int entries = 0;
        for (int loop = 0; loop < this.histogramData.length; ++loop) {
            entries += (int)this.histogramData[loop];
        }
        return this.histogramEntries;
    }

    public double getMean() {
        double mean = 0.0;
        double summ = 0.0;
        double count = 0.0;
        for (int i = 0; i < this.getAxis().getNBins(); ++i) {
            double bincontent = this.getBinContent(i);
            if (bincontent == 0.0) continue;
            summ += this.getAxis().getBinCenter(i) * this.getBinContent(i);
            count += this.getBinContent(i);
        }
        if (count != 0.0) {
            mean = summ / count;
        }
        return mean;
    }

    public String[] getStatText() {
        String[] lines = new String[]{this.histName, String.format("%-14s %9d", "Entries", this.getEntries()), String.format("%-14s %9.4f", "Mean", this.getMean()), String.format("%-14s %9.4f", "RMS", this.getRMS())};
        return lines;
    }

    public double getRMS() {
        double mean = this.getMean();
        double rms = 0.0;
        double summ = 0.0;
        int count = 0;
        for (int i = 0; i < this.getAxis().getNBins(); ++i) {
            int bincontent = (int)this.getBinContent(i);
            if (bincontent == 0) continue;
            double variance = this.getAxis().getBinCenter(i) - mean;
            summ += variance * variance * this.getBinContent(i);
            count += (int)this.getBinContent(i);
        }
        if (count != 0) {
            rms = summ / (double)count;
            return Math.sqrt(rms);
        }
        return rms;
    }

    public final void set(int bins, double min, double max) {
        this.xAxis = new Axis(bins, min, max);
        this.yAxis = new Axis();
        this.initDataStore(bins);
    }

    public double getIntegral() {
        return this.integral();
    }

    public double integral() {
        return this.integral(0, this.histogramData.length - 1);
    }

    public double integral(int start_bin, int end_bin) {
        double integral = 0.0;
        for (int loop = start_bin; loop <= end_bin; ++loop) {
            integral += (double)this.histogramData[loop];
        }
        return integral;
    }

    final void initDataStore(int size) {
        this.histogramData = new float[size];
        this.histogramDataError = new float[size];
    }

    public void fill(double value) {
        this.incrementBinContent(this.xAxis.getBin(value));
    }

    public void fill(double value, double weight) {
        this.incrementBinContent(this.xAxis.getBin(value), weight);
    }

    public void normalize(double number) {
        int i = 0;
        while (i < this.histogramData.length) {
            int n = i++;
            this.histogramData[n] = (float)((double)this.histogramData[n] / number);
        }
    }

    public void incrementBinContent(int bin) {
        ++this.histogramEntries;
        if (bin >= 0 && bin < this.histogramData.length) {
            this.histogramData[bin] = (float)((double)this.histogramData[bin] + 1.0);
            this.histogramDataError[bin] = (float)Math.sqrt(Math.abs(this.histogramData[bin]));
        } else if (bin < 0) {
            ++this.histogramUnderFlow;
        } else {
            ++this.histogramOverFlow;
        }
    }

    public void incrementBinContent(int bin, double weight) {
        ++this.histogramEntries;
        if (bin >= 0 && bin < this.histogramData.length) {
            this.histogramData[bin] = (float)((double)this.histogramData[bin] + weight);
            this.histogramDataError[bin] = (float)Math.sqrt(Math.abs(this.histogramData[bin]));
        } else if (bin < 0) {
            ++this.histogramUnderFlow;
        } else {
            ++this.histogramOverFlow;
        }
    }

    public void modify(DataVector vec, double rmin, double rmax) {
        int nbins = this.xAxis.getNBins();
        this.xAxis.set(nbins, rmin, rmax);
        this.reset();
        for (int loop = 0; loop < vec.getSize(); ++loop) {
            this.fill(vec.getValue(loop));
        }
    }

    public void fill(DataVector vec) {
        for (int loop = 0; loop < vec.getSize(); ++loop) {
            this.fill(vec.getValue(loop));
        }
    }

    public void fill(DataVector vec, DataVector weight) {
        for (int loop = 0; loop < vec.getSize(); ++loop) {
            this.fill(vec.getValue(loop), weight.getValue(loop));
        }
    }

    public void add(H1F h) {
        if (h.getAxis().getNBins() == this.getXaxis().getNBins()) {
            for (int loop = 0; loop < this.histogramData.length; ++loop) {
                this.setBinContent(loop, this.getBinContent(loop) + h.getBinContent(loop));
            }
        } else {
            System.out.println("[warning] ---> histograms have different bin number. not added.");
        }
    }

    public void divide(double number) {
        for (int i = 0; i < this.getAxis().getNBins(); ++i) {
            this.histogramData[i] = (float)((double)this.histogramData[i] / number);
        }
    }

    public static H1F divide(H1F h1, H1F h2) {
        if (h1.getXaxis().getNBins() != h2.getXaxis().getNBins()) {
            System.out.println("[H1D::divide] error : histograms have inconsistent bins");
            return null;
        }
        H1F h1div = new H1F(h1.getName() + "_DIV_" + h2.getName(), h1.getXaxis().getNBins(), h1.getXaxis().min(), h1.getXaxis().max());
        StatNumber result = new StatNumber();
        StatNumber denom = new StatNumber();
        for (int bin = 0; bin < h1.getXaxis().getNBins(); ++bin) {
            result.set(h1.getBinContent(bin), h1.getBinError(bin));
            denom.set(h2.getBinContent(bin), h2.getBinError(bin));
            result.divide(denom);
            h1div.setBinContent(bin, result.number());
            h1div.setBinError(bin, result.error());
        }
        return h1div;
    }

    public static H1F add(H1F h1, H1F h2) {
        if (h1.getXaxis().getNBins() != h2.getXaxis().getNBins()) {
            System.out.println("[H1D::divide] error : histograms have inconsistent bins");
            return null;
        }
        H1F h1div = new H1F(h1.getName() + "_ADD_" + h2.getName(), h1.getXaxis().getNBins(), h1.getXaxis().min(), h1.getXaxis().max());
        StatNumber result = new StatNumber();
        StatNumber denom = new StatNumber();
        for (int bin = 0; bin < h1.getXaxis().getNBins(); ++bin) {
            result.set(h1.getBinContent(bin), h1.getBinError(bin));
            denom.set(h2.getBinContent(bin), h2.getBinError(bin));
            result.add(denom);
            h1div.setBinContent(bin, result.number());
            h1div.setBinError(bin, result.error());
        }
        return h1div;
    }

    public static H1F normalized(H1F h1, H1F h2) {
        H1F h1norm = new H1F(h1.getName() + "_NORM_" + h2.getName(), h1.getXaxis().getNBins(), h1.getXaxis().min(), h1.getXaxis().max());
        double integral_h1 = h1.integral();
        double integral_h2 = h2.integral();
        double ratio = integral_h2 / integral_h1;
        for (int bin = 0; bin < h1.getXaxis().getNBins(); ++bin) {
            h1norm.setBinContent(bin, h1.getBinContent(bin) * ratio);
        }
        return h1norm;
    }

    public void divide(H1F hist) {
        if (hist.getAxis().getNBins() != this.getAxis().getNBins()) {
            System.out.println("ERROR: inconsistent bins in histograms");
            return;
        }
        StatNumber result = new StatNumber();
        StatNumber hdiv = new StatNumber();
        for (int i = 0; i < this.getAxis().getNBins(); ++i) {
            result.set(this.getBinContent(i), this.getBinError(i));
            hdiv.set(hist.getBinContent(i), hist.getBinError(i));
            result.divide(hdiv);
            this.setBinContent(i, result.number());
            this.setBinError(i, result.error());
        }
    }

    public void setBinContent(int bin, double value) {
        if (bin >= 0 && bin < this.histogramData.length) {
            this.histogramData[bin] = (float)value;
            this.histogramDataError[bin] = (float)Math.sqrt(Math.abs(this.histogramData[bin]));
        } else if (bin < 0) {
            ++this.histogramUnderFlow;
        } else {
            ++this.histogramOverFlow;
        }
    }

    public H1F histClone(String name) {
        H1F hclone = new H1F(name, this.getTitleX(), this.getTitleY(), this.xAxis.getNBins(), this.xAxis.min(), this.xAxis.max());
        for (int loop = 0; loop < this.xAxis.getNBins(); ++loop) {
            hclone.setBinContent(loop, this.getBinContent(loop));
            hclone.setBinError(loop, this.getBinError(loop));
        }
        return hclone;
    }

    public void setBinError(int bin, double value) {
        if (bin >= 0 && bin < this.histogramDataError.length) {
            this.histogramDataError[bin] = (float)value;
        }
    }

    public double getBinContent(int bin) {
        if (bin >= 0 && bin < this.histogramData.length) {
            return this.histogramData[bin];
        }
        return 0.0;
    }

    public double getBinError(int bin) {
        if (bin >= 0 && bin < this.histogramDataError.length) {
            return this.histogramDataError[bin];
        }
        return 0.0;
    }

    public Axis getXaxis() {
        return this.xAxis;
    }

    public Axis getYaxis() {
        return this.yAxis;
    }

    public Axis getxAxis() {
        return this.xAxis;
    }

    public Axis getyAxis() {
        return this.yAxis;
    }

    public Axis getAxis() {
        return this.xAxis;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.xAxis.getNBins(); ++i) {
            buffer.append(String.format("%12.6f %12.6f %12.6f\n", this.xAxis.getBinCenter(i), this.getBinContent(i), this.getBinError(i)));
        }
        return buffer.toString();
    }

    public GraphErrors getGraph() {
        GraphErrors graph = new GraphErrors();
        int npoints = this.getDataSize(0);
        for (int loop = 0; loop < npoints; ++loop) {
            graph.addPoint(this.getDataX(loop), this.getDataY(loop), this.getDataEX(loop) / 2.0, this.getDataEY(loop));
        }
        return graph;
    }

    public float[] getData() {
        return this.histogramData;
    }

    public float[] getDataError() {
        return this.histogramDataError;
    }

    public int getMaximumBin() {
        int bin = 0;
        double max = this.histogramData[0];
        for (int loop = 0; loop < this.histogramData.length; ++loop) {
            if (!((double)this.histogramData[loop] > max)) continue;
            max = this.histogramData[loop];
            bin = loop;
        }
        return bin;
    }

    public void fixBinWidths(double sensitivity) {
        int i;
        double maxSlope = Math.abs(this.histogramData[1] - this.histogramData[0]);
        for (int i2 = 1; i2 < this.histogramData.length - 1; ++i2) {
            double slope = Math.abs(this.histogramData[i2 + 1] - this.histogramData[i2]);
            if (!(slope > maxSlope)) continue;
            maxSlope = slope;
        }
        double minSlope = maxSlope * sensitivity;
        double[] histData = new double[this.histogramData.length];
        double[] histMargins = new double[this.xAxis.axisMargins.length];
        for (int i3 = 0; i3 < histData.length; ++i3) {
            histData[i3] = -1.0;
        }
        histData[0] = this.histogramData[0];
        histMargins[0] = this.xAxis.axisMargins[0];
        int index = 0;
        for (i = 0; i < this.histogramData.length - 1; ++i) {
            if ((double)Math.abs(this.histogramData[i + 1] - this.histogramData[i]) < minSlope) {
                if (histData[index] == -1.0) {
                    histData[index] = 0.0;
                }
                int n = index;
                histData[n] = histData[n] + (double)this.histogramData[i + 1];
                histMargins[index + 1] = this.xAxis.axisMargins[i + 2];
                continue;
            }
            histData[index + 1] = this.histogramData[i + 1];
            histMargins[index + 1] = this.xAxis.axisMargins[i + 1];
            ++index;
        }
        this.set(index + 1, this.xAxis.min(), this.xAxis.max());
        for (i = 0; i < this.histogramData.length; ++i) {
            this.setBinContent(i, histData[i]);
            this.xAxis.set(histMargins);
        }
        for (i = 0; i < this.histogramData.length - 1; ++i) {
            if (!((double)Math.abs(this.histogramData[i + 1] - this.histogramData[i]) < minSlope)) continue;
            this.fixBinWidths(sensitivity);
            break;
        }
    }

    @Override
    public String getName() {
        return this.histName;
    }

    @Override
    public int getDataSize(int axis) {
        return this.xAxis.getNBins();
    }

    @Override
    public DatasetAttributes getAttributes() {
        return this.hAttr;
    }

    @Override
    public double getDataX(int bin) {
        double binCenter = this.xAxis.getBinCenter(bin);
        return binCenter;
    }

    @Override
    public double getDataY(int bin) {
        return this.histogramData[bin];
    }

    @Override
    public double getDataEX(int bin) {
        return this.xAxis.getBinWidth(bin);
    }

    @Override
    public double getDataEY(int bin) {
        return this.histogramDataError[bin];
    }

    @Override
    public double getData(int xbin, int ybin) {
        return 0.0;
    }

    public H1F setFillColor(int color) {
        this.hAttr.setFillColor(color);
        return this;
    }

    public int getFillColor() {
        return this.hAttr.getFillColor();
    }

    public H1F setLineColor(int color) {
        this.hAttr.setLineColor(color);
        return this;
    }

    public int getLineColor() {
        return this.hAttr.getLineColor();
    }

    public H1F setLineWidth(int width) {
        this.hAttr.setLineWidth(width);
        return this;
    }

    public int getLineWidth() {
        return this.hAttr.getLineWidth();
    }

    public void setFunction(Func1D f) {
        this.fittedFunction = f;
    }

    public Func1D getFunction() {
        return this.fittedFunction;
    }

    @Override
    public PaveText getStatBox() {
        PaveText stat = new PaveText(2);
        stat.addText("Name", this.getName());
        stat.addText("Entries", Integer.toString(this.getEntries()));
        stat.addText("Mean", String.format("%.3f", this.getMean()));
        stat.addText("RMS", String.format("%.3f", this.getRMS()));
        stat.addText("Underflow", Integer.toString(this.histogramUnderFlow));
        stat.addText("Overflow", Integer.toString(this.histogramOverFlow));
        stat.addText("Integral", String.format("%.3f", this.getIntegral()));
        if (this.fittedFunction != null) {
            stat.addText("#chi^2/NDF", String.format("%.3f/%d", this.fittedFunction.getChiSquare(), this.fittedFunction.getNDF()));
            int npars = this.fittedFunction.getNPars();
            for (int i = 0; i < npars; ++i) {
                stat.addText(this.fittedFunction.parameter(i).name(), String.format("%.3f/%.4f", this.fittedFunction.parameter(i).value(), this.fittedFunction.parameter(i).error()));
            }
        }
        return stat;
    }

    public void setOptStat(int i) {
        this.hAttr.setOptStat("" + i);
    }

    public void setOptStat(String i) {
        this.hAttr.setOptStat(i);
    }
}

