/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.base;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.jlab.groot.base.FontProperties;
import org.jlab.groot.base.GStyle;
import org.jlab.groot.graphics.EmbeddedCanvas;
import org.jlab.groot.math.Dimension1D;
import org.jlab.groot.ui.DoubleSpinner;
import org.jlab.groot.ui.LatexText;

public class AxisAttributes
implements Cloneable {
    private Dimension1D axisDimension = new Dimension1D();
    Dimension1D range = new Dimension1D();
    public static final int X = 1;
    public static final int Y = 2;
    public static final int Z = 3;
    private String labelFontName = "Avenir";
    private int labelFontSize = 12;
    private String titleFontName = "Avenir";
    private int titleFontSize = 12;
    private boolean axisAutoScale = true;
    private double axisMinimum = 0.0;
    private double axisMaximum = 2.0;
    private int labelOffset = 4;
    private int titleOffset = 5;
    private boolean axisGrid = true;
    private int lineColor = 1;
    private int lineWidth = 1;
    private int tickSize = 5;
    private boolean log = false;
    private boolean showAxis = true;
    private int lineStyle = 1;
    private int axisType = 1;
    private String axisTitleString = "";
    private LatexText axisTitle = new LatexText(this.axisTitleString);
    private FontProperties labelFont = new FontProperties();
    private FontProperties titleFont = new FontProperties();
    private EmbeddedCanvas can = null;

    public AxisAttributes(int axisType) {
        this.axisType = axisType;
        if (this.axisType == 3) {
            this.showAxis = false;
        }
    }

    public Dimension1D getAxisDimension() {
        return this.axisDimension;
    }

    public int getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(int labelOffset) {
        this.labelOffset = labelOffset;
    }

    public int getTitleOffset() {
        return this.titleOffset;
    }

    public void setTitleOffset(int titleOffset) {
        this.titleOffset = titleOffset;
    }

    public String getAxisTitleString() {
        return this.axisTitleString;
    }

    public void setAxisTitleString(String axisTitleString) {
        this.axisTitleString = axisTitleString;
    }

    public EmbeddedCanvas getCan() {
        return this.can;
    }

    public void setCan(EmbeddedCanvas can) {
        this.can = can;
    }

    public String getLabelFontName() {
        return this.labelFontName;
    }

    public int getLabelFontSize() {
        return this.labelFontSize;
    }

    public String getTitleFontName() {
        return this.titleFontName;
    }

    public int getTitleFontSize() {
        return this.titleFontSize;
    }

    public boolean isAxisAutoScale() {
        return this.axisAutoScale;
    }

    public double getAxisMinimum() {
        return this.axisMinimum;
    }

    public double getAxisMaximum() {
        return this.axisMaximum;
    }

    public int getAxisType() {
        return this.axisType;
    }

    public void setAxisType(int axisType) {
        this.axisType = axisType;
    }

    public boolean isAxisGrid() {
        return this.axisGrid;
    }

    public int getLineColor() {
        return this.lineColor;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getTickSize() {
        return this.tickSize;
    }

    public AxisAttributes clone() throws CloneNotSupportedException {
        AxisAttributes copy = (AxisAttributes)super.clone();
        copy.range = this.range.clone();
        copy.axisDimension = this.axisDimension.clone();
        return copy;
    }

    public void setLabelFontName(String fn) {
        this.labelFontName = fn;
    }

    public void setLabelFontSize(int fs) {
        this.labelFontSize = fs;
    }

    public void setTitleFontName(String fn) {
        this.titleFontName = fn;
    }

    public void setTitleFontSize(int fs) {
        this.titleFontSize = fs;
    }

    public void setAxisAutoScale(boolean autoscale) {
        this.axisAutoScale = autoscale;
    }

    public void setAxisMinimum(double min) {
        this.axisMinimum = min;
        this.range.setMinMax(this.axisMinimum, this.range.getMax());
    }

    public void setAxisMaximum(double max) {
        this.axisMaximum = max;
        this.range.setMinMax(this.range.getMin(), this.axisMaximum);
    }

    public void setAxisGrid(boolean grid) {
        this.axisGrid = grid;
    }

    public void setLineColor(int color) {
        this.lineColor = color;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public void setTickSize(int size) {
        this.tickSize = size;
    }

    public void setAxisTitle(String title) {
        this.axisTitleString = title;
    }

    public void setCanvas(EmbeddedCanvas can) {
        this.can = can;
    }

    public void updateCanvas() {
        this.can.update();
    }

    public JPanel getPane() {
        return new AxisAttributesPane(this);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        AxisAttributes attr = new AxisAttributes(1);
        frame.add(attr.getPane());
        frame.pack();
        frame.setVisible(true);
    }

    public void setAttributes(AxisAttributes attr) {
        this.labelFontName = attr.getLabelFontName();
        this.labelFontSize = attr.getLabelFontSize();
        this.titleFontName = attr.getTitleFontName();
        this.titleFontSize = attr.getTitleFontSize();
        this.axisAutoScale = attr.isAxisAutoScale();
        this.axisMinimum = attr.getAxisMinimum();
        this.axisMaximum = attr.getAxisMaximum();
        this.labelOffset = attr.getLabelOffset();
        this.titleOffset = attr.getTitleOffset();
        this.axisGrid = attr.getGrid();
        this.lineColor = attr.getLineColor();
        this.lineWidth = attr.getLineWidth();
        this.tickSize = attr.getTickSize();
        this.log = attr.isLog();
        this.showAxis = attr.showAxis();
        this.lineStyle = attr.getLineStyle();
        this.axisType = attr.getAxisType();
    }

    public LatexText getTitle() {
        this.axisTitle.setText(this.axisTitleString);
        this.axisTitle.setFont(this.titleFontName);
        this.axisTitle.setFontSize(this.titleFontSize);
        return this.axisTitle;
    }

    public FontProperties getTitleFont() {
        this.titleFont.setFontName(this.titleFontName);
        this.titleFont.setFontSize(this.titleFontSize);
        return this.titleFont;
    }

    public FontProperties getLabelFont() {
        this.labelFont.setFontName(this.labelFontName);
        this.labelFont.setFontSize(this.labelFontSize);
        return this.labelFont;
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
        this.axisDimension.setLog(log);
        this.getRange().setLog(log);
    }

    private static int returnIndex(String[] strings, int number) {
        for (int i = 0; i < strings.length; ++i) {
            if (Integer.parseInt(strings[i]) != number) continue;
            return i;
        }
        return 0;
    }

    public Dimension1D getRange() {
        this.range.setMinMax(this.axisMinimum, this.axisMaximum);
        return this.range;
    }

    public boolean getGrid() {
        return this.axisGrid;
    }

    public void setGrid(boolean axisGrid) {
        this.axisGrid = axisGrid;
    }

    public boolean showAxis() {
        return this.showAxis;
    }

    public void setShowAxis(boolean showAxis) {
        this.showAxis = showAxis;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
    }

    public static class AxisAttributesPane
    extends JPanel
    implements ActionListener,
    ChangeListener {
        AxisAttributes attr = null;
        DoubleSpinner axisMinimum = null;
        DoubleSpinner axisMaximum = null;
        JCheckBox axisAutoScale = null;
        JCheckBox axisGrid = null;
        JCheckBox axisLog = null;
        JCheckBox axisShow = null;
        JComboBox labelFont = null;
        JComboBox titleFont = null;
        JComboBox labelFontSize = null;
        JComboBox titleFontSize = null;
        JTextField axisTitle = null;
        private List<ActionListener> listeners = new ArrayList<ActionListener>();

        public void addAttributeListener(ActionListener al) {
            this.listeners.add(al);
        }

        public AxisAttributesPane(AxisAttributes aa) {
            this.attr = aa;
            this.setBorder(BorderFactory.createTitledBorder("Axis Attributes"));
            this.setLayout((LayoutManager)new MigLayout());
            this.initUI();
        }

        private void initUI() {
            this.labelFont = new JComboBox<String>(FontProperties.getSystemFontsArray());
            this.titleFont = new JComboBox<String>(FontProperties.getSystemFontsArray());
            this.labelFontSize = new JComboBox<String>(FontProperties.getFontSizeArray());
            this.titleFontSize = new JComboBox<String>(FontProperties.getFontSizeArray());
            this.labelFont.setSelectedItem(this.attr.getLabelFontName());
            this.titleFont.setSelectedItem(this.attr.getTitleFontName());
            this.labelFontSize.setSelectedIndex(AxisAttributes.returnIndex(FontProperties.getFontSizeArray(), this.attr.getLabelFontSize()));
            this.titleFontSize.setSelectedIndex(AxisAttributes.returnIndex(FontProperties.getFontSizeArray(), this.attr.getTitleFontSize()));
            this.labelFont.addActionListener(this);
            this.titleFont.addActionListener(this);
            this.labelFontSize.addActionListener(this);
            this.titleFontSize.addActionListener(this);
            this.add((Component)new JSeparator(), "skip, wrap, growx");
            this.add(new JLabel("Label Font:"));
            this.add((Component)this.labelFont, "wrap, pushx, growx");
            this.add(new JLabel("Title Font:"));
            this.add((Component)this.titleFont, "wrap, pushx, growx");
            this.add(new JLabel("Label Font Size:"));
            this.add((Component)this.labelFontSize, "wrap, pushx, growx");
            this.add(new JLabel("Title Font Size:"));
            this.add((Component)this.titleFontSize, "wrap, pushx, growx");
            this.add((Component)new JSeparator(), "skip, wrap, growx");
            this.add(new JLabel("Title:"));
            this.axisTitle = new JTextField();
            this.axisTitle.addActionListener(this);
            this.add((Component)this.axisTitle, "wrap, pushx, growx");
            this.axisTitle.setText(this.attr.getAxisTitleString());
            this.add((Component)new JSeparator(), "skip, wrap, growx");
            this.axisMinimum = new DoubleSpinner();
            this.axisMaximum = new DoubleSpinner();
            this.axisAutoScale = new JCheckBox();
            this.axisGrid = new JCheckBox();
            this.axisShow = new JCheckBox();
            this.axisLog = new JCheckBox();
            this.axisMinimum.setValue(this.attr.getAxisMinimum());
            this.axisMaximum.setValue(this.attr.getAxisMaximum());
            this.axisAutoScale.setSelected(this.attr.isAxisAutoScale());
            this.axisGrid.setSelected(this.attr.isAxisGrid());
            this.axisLog.setSelected(this.attr.isLog());
            this.axisShow.setSelected(this.attr.showAxis());
            this.axisMinimum.addChangeListener(this);
            this.axisMaximum.addChangeListener(this);
            this.axisAutoScale.addChangeListener(this);
            this.axisGrid.addChangeListener(this);
            this.axisLog.addChangeListener(this);
            this.axisShow.addChangeListener(this);
            this.add(new JLabel("Axis Min:"));
            this.add((Component)this.axisMinimum, "wrap, pushx, growx");
            this.add(new JLabel("Axis Max:"));
            this.add((Component)this.axisMaximum, "wrap, pushx, growx");
            this.add((Component)new JLabel("Auto Scale:"), "skip, split4");
            this.add(this.axisAutoScale);
            this.add((Component)new JLabel("Grid:"), "pushx");
            this.add((Component)this.axisGrid, "wrap, pushx, growx");
            this.add((Component)new JLabel("Show Axis:"), "skip,split4");
            this.add(this.axisShow);
            this.add((Component)new JLabel("Log:"), "skip, split4");
            this.add((Component)this.axisLog, "wrap");
            JButton buttonDefault = new JButton("Default");
            JButton buttonSetDefault = new JButton("Set Default");
            this.add((Component)buttonSetDefault, "skip");
            buttonSetDefault.addActionListener(e -> {
                if (this.attr.axisType == 1) {
                    GStyle.getAxisAttributesX().setAttributes(this.attr);
                }
                if (this.attr.axisType == 2) {
                    GStyle.getAxisAttributesY().setAttributes(this.attr);
                }
                if (this.attr.axisType == 3) {
                    GStyle.getAxisAttributesZ().setAttributes(this.attr);
                }
            });
            JButton buttonApply = new JButton("Apply");
        }

        public void updateCanvas() {
            for (ActionListener actionListener : this.listeners) {
                actionListener.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.labelFont) {
                this.attr.setLabelFontName(FontProperties.getSystemFontsArray()[this.labelFont.getSelectedIndex()]);
            } else if (e.getSource() == this.titleFont) {
                this.attr.setTitleFontName(FontProperties.getSystemFontsArray()[this.titleFont.getSelectedIndex()]);
            } else if (e.getSource() == this.labelFontSize) {
                this.attr.setLabelFontSize(Integer.parseInt(FontProperties.getFontSizeArray()[this.labelFontSize.getSelectedIndex()]));
            } else if (e.getSource() == this.titleFontSize) {
                this.attr.setTitleFontSize(Integer.parseInt(FontProperties.getFontSizeArray()[this.titleFontSize.getSelectedIndex()]));
            } else if (e.getSource() == this.axisTitle) {
                this.attr.setAxisTitle(this.axisTitle.getText());
            }
            this.updateCanvas();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == this.axisMinimum) {
                this.axisAutoScale.setSelected(false);
                this.attr.setAxisAutoScale(false);
                this.attr.setAxisMinimum(this.axisMinimum.getDouble());
            } else if (e.getSource() == this.axisMaximum) {
                this.axisAutoScale.setSelected(false);
                this.attr.setAxisAutoScale(false);
                this.attr.setAxisMaximum(this.axisMaximum.getDouble());
            } else if (e.getSource() == this.axisAutoScale) {
                this.attr.setAxisAutoScale(this.axisAutoScale.isSelected());
                this.attr.setAxisMinimum(this.axisMinimum.getDouble());
                this.attr.setAxisMaximum(this.axisMaximum.getDouble());
            } else if (e.getSource() == this.axisGrid) {
                this.attr.setAxisGrid(this.axisGrid.isSelected());
            } else if (e.getSource() == this.axisLog) {
                this.attr.setLog(this.axisLog.isSelected());
            } else if (e.getSource() == this.axisShow) {
                this.attr.setShowAxis(this.axisShow.isSelected());
            }
            this.updateCanvas();
        }
    }
}

