/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class TableUtilities {
    public static boolean isDataChanged(TableModelEvent e) {
        if (e == null) {
            return false;
        }
        return e.getType() == 0 && e.getFirstRow() == 0 && e.getLastRow() == Integer.MAX_VALUE;
    }

    public static boolean isUpdate(TableModelEvent e) {
        if (TableUtilities.isStructureChanged(e)) {
            return false;
        }
        return e.getType() == 0 && e.getLastRow() < Integer.MAX_VALUE;
    }

    public static boolean isInsert(TableModelEvent e) {
        if (e == null) {
            return false;
        }
        return 1 == e.getType();
    }

    public static boolean isDelete(TableModelEvent e) {
        if (e == null) {
            return false;
        }
        return -1 == e.getType();
    }

    public static boolean isStructureChanged(TableModelEvent e) {
        return e == null || e.getFirstRow() == -1;
    }

    public static int getPreferredRowHeight(JTable table, int row) {
        int pref = 0;
        for (int column = 0; column < table.getColumnCount(); ++column) {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            Component comp = table.prepareRenderer(renderer, row, column);
            pref = Math.max(pref, comp.getPreferredSize().height);
        }
        return pref > 0 ? pref : table.getRowHeight();
    }

    public static void setPreferredRowHeight(JTable table, int row) {
        int prefHeight = TableUtilities.getPreferredRowHeight(table, row);
        table.setRowHeight(row, prefHeight);
    }

    public static void setPreferredRowHeights(JTable table) {
        for (int row = 0; row < table.getRowCount(); ++row) {
            TableUtilities.setPreferredRowHeight(table, row);
        }
    }

    public static int[] ordinalsOf(Enum<?> ... values) {
        int[] cols = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            cols[i] = values[i].ordinal();
        }
        return cols;
    }

    public static void clear(TableColumnModel model, boolean includeHidden) {
        if (model instanceof TableColumnModelExt) {
            TableUtilities.clear(model, ((TableColumnModelExt)model).getColumns(includeHidden));
        } else {
            TableUtilities.clear(model, Collections.list(model.getColumns()));
        }
    }

    private static void clear(TableColumnModel model, List<TableColumn> columns) {
        for (TableColumn tableColumn : columns) {
            model.removeColumn(tableColumn);
        }
    }

    private TableUtilities() {
    }
}

